/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.file;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.LinkedList;
import java.util.List;
import org.gdstash.file.GDAbstractBuffer;

public class GDByteBuffer
extends GDAbstractBuffer {
    private int bufferSize;
    private int lastBlockSize;
    private int fileSize;
    private List<byte[]> list;
    private int pos;
    private ByteOrder bo;

    public GDByteBuffer(String filename) {
        this(new File(filename), 0x6400000);
    }

    public GDByteBuffer(String filename, int bufferSize) {
        this(new File(filename), bufferSize);
    }

    public GDByteBuffer(File file) {
        this(file, 0x6400000);
    }

    public GDByteBuffer(File file, int bufferSize) {
        this.bufferSize = bufferSize;
        this.list = new LinkedList<byte[]>();
        try (RandomAccessFile raf = new RandomAccessFile(file, "r");){
            int rest = this.fileSize = (int)raf.length();
            int size = 0;
            if (rest < bufferSize) {
                size = rest;
                this.lastBlockSize = rest;
            } else {
                size = bufferSize;
            }
            while (size > 0) {
                byte[] bytes = new byte[size];
                raf.readFully(bytes);
                this.list.add(bytes);
                if ((rest -= size) < bufferSize) {
                    size = rest;
                    if (rest <= 0) continue;
                    this.lastBlockSize = rest;
                    continue;
                }
                size = bufferSize;
            }
        }
        catch (IOException ex) {
            this.list = new LinkedList<byte[]>();
        }
        this.pos = 0;
        this.bo = ByteOrder.LITTLE_ENDIAN;
    }

    @Override
    public byte[] getByteArray(int length) {
        return this.getByteArray(this.pos, length);
    }

    @Override
    public byte[] getByteArray(int pos, int length) {
        int listSize = (this.list.size() - 1) * this.bufferSize + this.lastBlockSize;
        if (listSize < pos) {
            return null;
        }
        int byteSize = length;
        if (listSize < pos + length) {
            byteSize = listSize - pos;
        }
        if (byteSize <= 0) {
            return null;
        }
        byte[] result = new byte[byteSize];
        int tempPos = pos;
        int tempLen = length;
        int resOffset = 0;
        int listPos = 0;
        for (byte[] bytes : this.list) {
            if (listPos <= tempPos && bytes.length + listPos > tempPos) {
                int bufferOffset = tempPos - listPos;
                int maxPos = bufferOffset + tempLen;
                if (maxPos > bytes.length) {
                    maxPos = bytes.length;
                }
                for (int i = bufferOffset; i < maxPos; ++i) {
                    result[i - bufferOffset + resOffset] = bytes[i];
                }
                if ((listPos += this.bufferSize) > tempPos + tempLen) break;
                tempPos = listPos;
                tempLen -= maxPos - bufferOffset;
                resOffset += maxPos - bufferOffset;
                continue;
            }
            listPos += this.bufferSize;
        }
        this.pos = tempPos + tempLen;
        return result;
    }

    @Override
    public byte getByte() {
        byte[] bytes = this.getByteArray(1);
        return bytes[0];
    }

    @Override
    public int getInt() {
        byte[] bytes = this.getByteArray(4);
        return ByteBuffer.wrap(bytes).order(this.bo).getInt();
    }

    @Override
    public long getLong() {
        byte[] bytes = this.getByteArray(8);
        return ByteBuffer.wrap(bytes).order(this.bo).getLong();
    }

    @Override
    public short getShort() {
        byte[] bytes = this.getByteArray(2);
        return ByteBuffer.wrap(bytes).order(this.bo).getShort();
    }

    @Override
    public int getPosition() {
        return this.pos;
    }

    @Override
    public void setPosition(int pos) {
        this.pos = pos;
    }

    @Override
    public void close() {
        this.list = null;
    }
}

