/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.file;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.gdstash.file.GDAbstractBuffer;

public class GDMappedByteBuffer
extends GDAbstractBuffer {
    private File file;
    private RandomAccessFile raf;
    private MappedByteBuffer buffer;

    public GDMappedByteBuffer(File file) {
        this.file = file;
        try {
            this.raf = new RandomAccessFile(file, "r");
            this.buffer = this.raf.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, this.raf.length());
            this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        }
        catch (IOException ex) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public byte[] getByteArray(int length) throws IOException {
        byte[] b = new byte[length];
        this.buffer.get(b);
        return b;
    }

    @Override
    public byte getByte() {
        return this.buffer.get();
    }

    @Override
    public int getInt() throws IOException {
        return this.buffer.getInt();
    }

    @Override
    public long getLong() throws IOException {
        return this.buffer.getLong();
    }

    @Override
    public short getShort() throws IOException {
        return this.buffer.getShort();
    }

    @Override
    public int getPosition() throws IOException {
        return this.buffer.position();
    }

    @Override
    public void setPosition(int pos) throws IOException {
        this.buffer.position(pos);
    }

    @Override
    public void close() throws IOException {
        this.buffer = null;
        this.raf.close();
    }
}

