/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.file;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.gdstash.file.GDAbstractBuffer;

public class GDRandomAccessBuffer
extends GDAbstractBuffer {
    private File file;
    private ByteOrder bo;
    private RandomAccessFile raf;

    public GDRandomAccessBuffer(File file) {
        this.file = file;
        this.bo = ByteOrder.LITTLE_ENDIAN;
        try {
            this.raf = new RandomAccessFile(file, "r");
        }
        catch (IOException ex) {
            try {
                this.raf.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public byte[] getByteArray(int length) throws IOException {
        byte[] b = new byte[length];
        this.raf.readFully(b);
        return b;
    }

    @Override
    public byte getByte() throws IOException {
        return this.raf.readByte();
    }

    @Override
    public int getInt() throws IOException {
        byte[] bytes = this.getByteArray(4);
        return ByteBuffer.wrap(bytes).order(this.bo).getInt();
    }

    @Override
    public long getLong() throws IOException {
        byte[] bytes = this.getByteArray(8);
        return ByteBuffer.wrap(bytes).order(this.bo).getLong();
    }

    @Override
    public short getShort() throws IOException {
        byte[] bytes = this.getByteArray(2);
        return ByteBuffer.wrap(bytes).order(this.bo).getShort();
    }

    @Override
    public int getPosition() throws IOException {
        return (int)this.raf.getFilePointer();
    }

    @Override
    public void setPosition(int pos) throws IOException {
        this.raf.seek(pos);
    }

    @Override
    public void close() throws IOException {
        this.raf.close();
    }
}

