/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.file;

import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.gdstash.file.GDFileSize;
import org.gdstash.file.GDReader;
import org.gdstash.util.GDConstants;
import org.gdstash.util.GDMsgFormatter;

public class GDWriter {
    private static int key;
    private static int[] table;
    private static byte[] buffer;
    private static int pos;

    public static void reserveBuffer(GDFileSize gfs) {
        buffer = new byte[gfs.getByteSize()];
        pos = 0;
    }

    public static void writeBuffer(File file) throws IOException {
        try (FileOutputStream writer = new FileOutputStream(file);){
            writer.write(buffer, 0, pos);
            writer.flush();
        }
    }

    public static void writeByteArr(byte[] b) throws IOException {
        if (pos + b.length > buffer.length) {
            throw new EOFException(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_UNEXPECTED_EOF"));
        }
        for (int i = 0; i < b.length; ++i) {
            GDWriter.buffer[GDWriter.pos + i] = b[i];
        }
        pos += b.length;
    }

    public static void writeBlockStart(GDReader.Block block, int n) throws IOException {
        GDWriter.writeInt(n);
        GDWriter.writeInt(0);
        block.end = pos;
    }

    public static void writeBlockEnd(GDReader.Block block) throws IOException {
        int currPos = pos;
        pos = block.end - 4;
        GDWriter.writeInt(currPos - block.end);
        pos = currPos;
        GDWriter.writeInt(0);
    }

    public static void writeByte(byte b) throws IOException {
        byte[] bArr = new byte[]{b};
        GDWriter.writeByteArr(bArr);
    }

    public static void writeFloat(float value) throws IOException {
        int i = Float.floatToIntBits(value);
        GDWriter.writeInt(i);
    }

    public static void writeInt(int value) throws IOException {
        byte[] b = GDWriter.intToBytes4(value);
        GDWriter.writeByteArr(b);
    }

    public static void writeString(String s) throws IOException {
        if (s == null) {
            GDWriter.writeInt(0);
            return;
        }
        int len = s.length();
        GDWriter.writeInt(len);
        byte[] b = s.getBytes(GDConstants.CHARSET_STASH);
        GDWriter.writeByteArr(b);
    }

    public static void writeWideString(String s) throws IOException {
        if (s == null) {
            GDWriter.writeInt(0);
            return;
        }
        int len = s.length();
        GDWriter.writeInt(len);
        byte[] b = s.getBytes(GDConstants.CHARSET_WIDE);
        GDWriter.writeByteArr(b);
    }

    public static void writeKey(FileOutputStream writer, int key) throws IOException {
        GDWriter.key = key;
        table = GDReader.buildTable(GDWriter.key);
        int k = key ^ 0x55555555;
        byte[] b = GDWriter.intToBytes4(k);
        writer.write(b);
    }

    public static void writeCurrentKey(FileOutputStream writer) throws IOException {
        GDWriter.writeEncInt(writer, key, false);
    }

    private static void updateKey(int value) {
        byte[] b = ByteBuffer.allocate(4).putInt(value).array();
        for (int i = 0; i < b.length; ++i) {
            int j = b[i];
            if (j < 0) {
                j += 256;
            }
            key ^= table[j];
        }
    }

    private static void updateKey(byte value) {
        byte[] b = new byte[]{value};
        for (int i = 0; i < b.length; ++i) {
            int j = b[i];
            if (j < 0) {
                j += 256;
            }
            key ^= table[j];
        }
    }

    public static void writeEncByte(FileOutputStream writer, byte value) throws IOException {
        byte[] b = new byte[]{(byte)(value ^ key)};
        GDWriter.updateKey(value);
        writer.write(b);
    }

    public static void writeEncFloat(FileOutputStream writer, float value) throws IOException {
        int i = Float.floatToIntBits(value);
        GDWriter.writeEncInt(writer, i, true);
    }

    public static void writeEncInt(FileOutputStream writer, int value, boolean updateKey) throws IOException {
        int enc = value ^ key;
        if (updateKey) {
            GDWriter.updateKey(value);
        }
        byte[] b = GDWriter.intToBytes4(enc);
        writer.write(b);
    }

    public static void writeEncString(FileOutputStream writer, String s) throws IOException {
        if (s == null) {
            GDWriter.writeEncInt(writer, 0, true);
            return;
        }
        GDWriter.writeEncInt(writer, s.length(), true);
        char[] c = s.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            byte b = (byte)c[i];
            GDWriter.writeEncByte(writer, b);
        }
    }

    public static String getOSFilePath(String filename) {
        String osName = "";
        int pos = 0;
        while (pos != -1) {
            pos = filename.indexOf("/");
            if (pos != -1) {
                osName = osName + filename.substring(0, pos) + System.getProperty("file.separator");
                filename = filename.substring(pos + 1);
                continue;
            }
            osName = osName + filename;
        }
        return osName;
    }

    public static String getOSDirPath(String filename) {
        String osPath = null;
        int pos = filename.lastIndexOf(System.getProperty("file.separator"));
        if (pos != -1) {
            osPath = filename.substring(0, pos + 1);
        }
        return osPath;
    }

    public static byte lengthToByte(String s) {
        byte b = 0;
        if (s == null) {
            return b;
        }
        b = (byte)s.length();
        return b;
    }

    public static byte[] lengthToBytes4(String s) {
        if (s == null) {
            return new byte[4];
        }
        return GDWriter.intToBytes4(s.length());
    }

    public static byte[] intToBytes4(int value) {
        byte[] b = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(value).array();
        return b;
    }

    public static byte[] floatToBytes4(float value) {
        int i = Float.floatToIntBits(value);
        return GDWriter.intToBytes4(i);
    }

    public static void write(String filename, byte[] data) throws IOException {
        String dirName = GDWriter.getOSDirPath(filename);
        File dir = new File(dirName);
        if (!dir.exists() && !dir.mkdirs()) {
            Object[] args = new Object[]{dirName};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_DIR_CREATE_FAIL", args);
            throw new IOException(msg);
        }
        File file = new File(filename);
        file.createNewFile();
        try (FileOutputStream writer = new FileOutputStream(file);){
            writer.write(data);
            writer.flush();
        }
    }

    public static void write(String filename, String data) throws IOException {
        String dirName = GDWriter.getOSDirPath(filename);
        File dir = new File(dirName);
        if (!dir.exists() && !dir.mkdirs()) {
            Object[] args = new Object[]{dirName};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_DIR_CREATE_FAIL", args);
            throw new IOException(msg);
        }
        File file = new File(filename);
        file.createNewFile();
        try (FileWriter writer = new FileWriter(file);){
            writer.write(data);
            writer.flush();
        }
    }
}

