/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.item;

public class GDRandomUniform {
    private static final int a = 16807;
    private static final int m = Integer.MAX_VALUE;
    private static final int q = 127773;
    private static final int r = 2836;
    private long previous;

    public GDRandomUniform(int seed) {
        this.setSeed(seed);
    }

    private long generate() {
        int hi = (int)(this.previous / 127773L);
        int lo = (int)(this.previous - (long)(127773 * hi));
        int t = 16807 * lo - 2836 * hi;
        this.previous = t >= 0 ? (long)t : (long)(t + Integer.MAX_VALUE);
        return this.previous;
    }

    public void setSeed(int seed) {
        long l = 0L;
        if (seed < 0) {
            l = 0x100000000L;
            l += (long)seed;
        } else {
            l = seed;
        }
        this.setSeedLong(l);
    }

    private void setSeedLong(long seed) {
        this.previous = seed;
        this.generate();
    }

    public float generateFloat(int min, int max) {
        float f = (float)this.generate() / 2.1474836E9f;
        return f * (float)(max - min) + (float)min;
    }

    public int generateInt(int min, int max) {
        long l = this.generate();
        return (int)(l % (long)(max - min + 1)) + min;
    }

    public long generateSeed() {
        return this.generate();
    }
}

