/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.item;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.gdstash.file.GDReader;
import org.gdstash.file.GDWriter;
import org.gdstash.item.GDAbstractContainer;
import org.gdstash.item.GDItem;
import org.gdstash.util.GDLog;

public class GDStashPage
extends GDAbstractContainer {
    private InputStream reader;
    private String filename;
    private int stashType;
    private boolean itemError = false;
    private boolean pageError = false;

    public GDStashPage(InputStream reader, int stashType, int version, int w, boolean hardcore, String filename, int page, GDLog log) {
        super(1);
        this.reader = reader;
        this.filename = filename;
        this.stashType = stashType;
        this.width = w;
        if (stashType == 0) {
            this.readOldFormat(hardcore, page + 1, version);
        }
        if (stashType == 1) {
            this.readNewFormat(hardcore, page + 1, version, log);
        }
    }

    public boolean hasItemErrors() {
        return this.itemError;
    }

    public boolean hasPageErrors() {
        return this.pageError;
    }

    private void readNewFormat(boolean hardcore, int page, int version, GDLog log) {
        try {
            int val = 0;
            GDReader.Block block = new GDReader.Block();
            val = GDReader.readBlockStart(block);
            this.width = GDReader.readEncInt(true);
            this.height = GDReader.readEncInt(true);
            int numItems = GDReader.readEncInt(true);
            this.items.clear();
            this.removedItems.clear();
            for (int i = 0; i < numItems; ++i) {
                GDItem item = new GDItem(this.reader, this.stashType, version, hardcore, this.filename, page, log);
                if (!item.hasErrors()) {
                    this.items.add(item);
                    continue;
                }
                this.removedItems.add(item);
                this.itemError = true;
            }
            GDReader.readBlockEnd(block);
            this.changed = false;
        }
        catch (Exception ex) {
            this.pageError = true;
        }
    }

    private void readOldFormat(boolean hardcore, int page, int version) {
        try {
            int numItems = 0;
            int len = 0;
            while (len != -1) {
                len = GDReader.readUInt(this.reader);
                if (len == -1) continue;
                String s = GDReader.readString(this.reader, len);
                if (s.equals("sackWidth")) {
                    this.width = GDReader.readInt(this.reader);
                }
                if (s.equals("sackHeight")) {
                    this.height = GDReader.readInt(this.reader);
                }
                if (!s.equals("numItems")) continue;
                numItems = GDReader.readUInt(this.reader);
                break;
            }
            this.items.clear();
            for (int i = 0; i < numItems; ++i) {
                GDItem item = new GDItem(this.reader, this.stashType, version, hardcore, this.filename, page, null);
                if (!item.hasErrors()) {
                    this.items.add(item);
                    continue;
                }
                this.itemError = true;
            }
            this.removedItems.clear();
            this.changed = false;
        }
        catch (IOException ex) {
            this.pageError = true;
        }
    }

    public int getByteSize() {
        int size = 0;
        size += 4;
        size += 4;
        size += 4;
        for (GDItem item : this.items) {
            size += item.getByteSize();
        }
        for (GDItem item : this.removedItems) {
            size += item.getByteSize();
        }
        return size;
    }

    public void write() throws IOException {
        GDReader.Block block = new GDReader.Block();
        GDWriter.writeBlockStart(block, 0);
        GDWriter.writeInt(this.width);
        GDWriter.writeInt(this.height);
        int val = this.items.size() + this.removedItems.size();
        GDWriter.writeInt(val);
        for (GDItem item : this.items) {
            item.write();
        }
        for (GDItem item : this.removedItems) {
            item.write();
        }
        GDWriter.writeBlockEnd(block);
        this.changed = false;
    }

    public void writeOldFormat(FileOutputStream writer, Charset cs) throws IOException {
        writer.write(GDWriter.lengthToBytes4("sackWidth"));
        writer.write("sackWidth".getBytes(cs));
        writer.write(GDWriter.intToBytes4(this.width));
        writer.write(GDWriter.lengthToBytes4("sackHeight"));
        writer.write("sackHeight".getBytes(cs));
        writer.write(GDWriter.intToBytes4(this.height));
        writer.write(GDWriter.lengthToBytes4("numItems"));
        writer.write("numItems".getBytes(cs));
        int val = this.items.size() + this.removedItems.size();
        GDWriter.writeInt(val);
        writer.write(GDWriter.intToBytes4(val));
        for (GDItem item : this.items) {
            item.writeOldFormat(writer, cs);
        }
        for (GDItem item : this.removedItems) {
            item.writeOldFormat(writer, cs);
        }
        this.changed = false;
    }
}

