/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.ui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import org.gdstash.db.DBItem;
import org.gdstash.db.DBStashItem;
import org.gdstash.db.SelectionCriteria;
import org.gdstash.item.GDItem;
import org.gdstash.ui.GDDialog;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.ui.select.ItemSelectionPane;
import org.gdstash.ui.table.GDItemCollectionSorter;
import org.gdstash.ui.table.GDItemCollectionTableModel;
import org.gdstash.ui.util.AdjustablePanel;
import org.gdstash.util.GDImagePool;
import org.gdstash.util.GDMsgFormatter;
import org.gdstash.util.GDMsgLogger;

public class GDCollectionPane
extends AdjustablePanel {
    private GDStashFrame frame;
    private List<GDItemInfo> data;
    private List<GDItem> itemsAll;
    private List<GDItem> itemsFound;
    private GDItemCollectionTableModel model;
    private JTable table;
    private JButton btnSearch;
    private ItemSelectionPane pnlSelect;
    private JButton btnFilterAll;
    private JButton btnFilterFound;
    private JButton btnFilterMiss;

    public GDCollectionPane(GDStashFrame frame) {
        this.frame = frame;
        this.init();
    }

    @Override
    public void adjustUI() {
        Font fntTable;
        Font fntLabel = UIManager.getDefaults().getFont("Label.font");
        Font fntButton = UIManager.getDefaults().getFont("Button.font");
        if (fntButton == null) {
            fntButton = fntLabel;
        }
        if ((fntTable = UIManager.getDefaults().getFont("TableHeader.font")) == null) {
            fntTable = fntLabel;
        }
        fntLabel = fntLabel.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntButton = fntButton.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntTable = fntTable.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        if (this.btnSearch == null) {
            this.btnSearch = new JButton();
            this.btnSearch.addActionListener(new SearchItemsListener());
        }
        this.btnSearch.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "BTN_SEARCH"));
        this.btnSearch.setIcon(GDImagePool.iconBtnSearch24);
        this.btnSearch.setFont(fntButton);
        GDStashFrame.setMnemonic(this.btnSearch, "MNC_SEARCH");
        if (this.btnFilterAll == null) {
            this.btnFilterAll = new JButton();
            this.btnFilterAll.addActionListener(new SelectAllListener());
        }
        this.btnFilterAll.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "BTN_FILTER_ALL"));
        this.btnFilterAll.setIcon(GDImagePool.iconCollectAll24);
        this.btnFilterAll.setFont(fntButton);
        GDStashFrame.setMnemonic(this.btnFilterAll, "MNC_FILTER_ALL");
        if (this.btnFilterFound == null) {
            this.btnFilterFound = new JButton();
            this.btnFilterFound.addActionListener(new SelectFoundListener());
        }
        this.btnFilterFound.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "BTN_FILTER_FOUND"));
        this.btnFilterFound.setIcon(GDImagePool.iconCollectFound24);
        this.btnFilterFound.setFont(fntButton);
        GDStashFrame.setMnemonic(this.btnFilterFound, "MNC_FILTER_FOUND");
        if (this.btnFilterMiss == null) {
            this.btnFilterMiss = new JButton();
            this.btnFilterMiss.addActionListener(new SelectMissingListener());
        }
        this.btnFilterMiss.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "BTN_FILTER_MISS"));
        this.btnFilterMiss.setIcon(GDImagePool.iconCollectMiss24);
        this.btnFilterMiss.setFont(fntButton);
        GDStashFrame.setMnemonic(this.btnFilterMiss, "MNC_FILTER_MISS");
        if (this.table == null) {
            this.table = new JTable();
            GDItemCollectionSorter sorter = new GDItemCollectionSorter();
            this.table.setRowSorter(sorter);
            this.table.getTableHeader().addMouseListener(new SortListener());
            this.setItems(null);
        }
        this.table.getTableHeader().setFont(fntTable);
        this.table.setFont(fntLabel);
        int height = -1;
        if (this.data != null) {
            for (GDItemInfo info : this.data) {
                BufferedImage img = info.gdItem.getImage();
                if (img == null || img.getHeight() <= height) continue;
                height = img.getHeight();
            }
        }
        if (height == -1) {
            height = 12;
        }
        if (height != -1) {
            height = height * GDStashFrame.iniConfig.sectUI.graphicScale / 100;
            this.table.setRowHeight(height);
        }
        GDItemCollectionTableModel model = (GDItemCollectionTableModel)this.table.getModel();
        model.adjustUI();
        this.updateTableColumns();
        if (this.pnlSelect == null) {
            this.pnlSelect = new ItemSelectionPane();
        } else {
            this.pnlSelect.adjustUI();
        }
    }

    public void refresh() {
        if (this.table != null) {
            GDItemCollectionTableModel model = (GDItemCollectionTableModel)this.table.getModel();
            model.setData(null);
        }
    }

    private List<GDItemInfo> buildInfo(List<GDItem> all, List<GDItem> found) {
        if (all == null) {
            return null;
        }
        if (all.size() == 0) {
            return null;
        }
        LinkedList<GDItemInfo> infos = new LinkedList<GDItemInfo>();
        for (GDItem item : all) {
            GDItemInfo info = new GDItemInfo(item);
            infos.add(info);
            for (GDItem item2 : found) {
                if (!item.getItemID().equals(item2.getItemID())) continue;
                if (item2.isHardcore()) {
                    ++info.hcCount;
                    continue;
                }
                ++info.scCount;
            }
        }
        return infos;
    }

    private void init() {
        this.adjustUI();
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        JPanel pnlMain = this.buildMainPanel();
        JScrollPane scroll = new JScrollPane(pnlMain);
        scroll.getVerticalScrollBar().setUnitIncrement(100);
        scroll.getVerticalScrollBar().putClientProperty("JScrollBar.fastWheelScrolling", true);
        scroll.setWheelScrollingEnabled(true);
        layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(scroll));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(scroll));
        layout.setVerticalGroup(vGroup);
    }

    private JPanel buildMainPanel() {
        JPanel panel = new JPanel();
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        JPanel pnlSearch = this.buildSearchPanel();
        JPanel pnlFilter = this.buildFilterPanel();
        this.setItems(this.data);
        JScrollPane scrTable = new JScrollPane(this.table);
        layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(pnlSearch)).addGroup(layout.createParallelGroup().addComponent(scrTable).addComponent(pnlFilter));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(scrTable).addComponent(pnlSearch)).addGroup(layout.createParallelGroup().addComponent(pnlFilter));
        layout.setVerticalGroup(vGroup);
        return panel;
    }

    private JPanel buildSearchPanel() {
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        JPanel panel = new JPanel();
        layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(this.btnSearch).addComponent(this.pnlSelect));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(this.btnSearch)).addGroup(layout.createParallelGroup().addComponent(this.pnlSelect));
        layout.setVerticalGroup(vGroup);
        layout.linkSize(0, this.btnSearch, this.pnlSelect);
        return panel;
    }

    private JPanel buildFilterPanel() {
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        JPanel panel = new JPanel();
        layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(this.btnFilterMiss)).addGroup(layout.createParallelGroup().addComponent(this.btnFilterFound)).addGroup(layout.createParallelGroup().addComponent(this.btnFilterAll));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(this.btnFilterMiss).addComponent(this.btnFilterFound).addComponent(this.btnFilterAll));
        layout.setVerticalGroup(vGroup);
        layout.linkSize(0, this.btnFilterMiss, this.btnFilterFound);
        layout.linkSize(0, this.btnFilterMiss, this.btnFilterAll);
        layout.linkSize(1, this.btnFilterMiss, this.btnFilterFound);
        layout.linkSize(1, this.btnFilterMiss, this.btnFilterAll);
        return panel;
    }

    public void updateConfig() {
        if (this.pnlSelect != null) {
            this.pnlSelect.updateConfig();
        }
    }

    private void search() {
        this.itemsAll = new LinkedList<GDItem>();
        LinkedList<String> itemIDs = new LinkedList<String>();
        SelectionCriteria criteria = new SelectionCriteria();
        this.pnlSelect.addCriteria(criteria);
        criteria.noEnemyOnly = true;
        if ((criteria.itemIDs == null || criteria.itemIDs.isEmpty()) && (criteria.itemClass == null || criteria.itemClass.isEmpty())) {
            GDDialog dialog = new GDDialog(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERR_SEL_ITEM_TYPE"), 4, this.frame, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERROR"), true);
            dialog.setVisible(true);
            return;
        }
        List<DBItem> dbItems = DBItem.getByCriteria(criteria);
        for (DBItem dbi : dbItems) {
            GDItem item = new GDItem(dbi);
            this.itemsAll.add(item);
            if (dbi == null) {
                itemIDs.add(null);
                continue;
            }
            itemIDs.add(dbi.getItemID());
        }
        Collections.sort(this.itemsAll);
        this.itemsFound = DBStashItem.getGDItemsByItemIDs(itemIDs);
        this.data = this.buildInfo(this.itemsAll, this.itemsFound);
        this.setItems(this.data);
        GDMsgLogger.showLog(this, GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_SEARCH"));
    }

    public void setItems(List<GDItem> all, List<GDItem> found) {
        List<GDItemInfo> list = this.buildInfo(all, found);
        this.setItems(list);
    }

    private void updateTableColumns() {
        this.table.getColumnModel().getColumn(1).setCellRenderer(new GDItemTableCellRenderer());
        this.table.getColumnModel().getColumn(2).setCellRenderer(new GDItemTableCellRenderer());
        int scale = 100;
        int size = 12;
        if (GDStashFrame.iniConfig != null) {
            scale = GDStashFrame.iniConfig.sectUI.graphicScale;
            size = GDStashFrame.iniConfig.sectUI.fontSize;
        }
        this.table.getColumnModel().getColumn(0).setPreferredWidth(100 * scale / 100);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(42 * size);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(8 * size);
        this.table.getColumnModel().getColumn(3).setPreferredWidth(3 * size);
        this.table.getColumnModel().getColumn(4).setPreferredWidth(3 * size);
    }

    public void setItems(List<GDItemInfo> list) {
        this.data = list;
        if (this.data != null) {
            Collections.sort(this.data);
        }
        int height = -1;
        if (this.data != null) {
            for (GDItemInfo info : this.data) {
                BufferedImage img = info.gdItem.getImage();
                if (img == null || img.getHeight() <= height) continue;
                height = img.getHeight();
            }
        }
        if (height == -1) {
            height = 12;
        }
        this.model = new GDItemCollectionTableModel(this.data);
        this.table.setModel(this.model);
        this.table.setSelectionMode(0);
        this.table.getSelectionModel().addListSelectionListener(this.table);
        GDItemCollectionSorter sorter = new GDItemCollectionSorter(this.model);
        this.table.setRowSorter(sorter);
        this.updateTableColumns();
        Rectangle rect = this.table.getVisibleRect();
        rect.setLocation(0, 0);
        this.table.scrollRectToVisible(rect);
        if (height != -1) {
            height = height * GDStashFrame.iniConfig.sectUI.graphicScale / 100;
            this.table.setRowHeight(height);
        }
    }

    private class SortListener
    extends MouseAdapter {
        private SortListener() {
        }

        @Override
        public void mouseClicked(MouseEvent ev) {
            int idx = GDCollectionPane.this.table.getColumnModel().getColumnIndexAtX(ev.getX());
            GDItemCollectionSorter sorter = (GDItemCollectionSorter)GDCollectionPane.this.table.getRowSorter();
            sorter.sort();
        }
    }

    private class SelectAllListener
    implements ActionListener {
        private SelectAllListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GDCollectionPane.this.model.filter(1);
        }
    }

    private class SelectMissingListener
    implements ActionListener {
        private SelectMissingListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GDCollectionPane.this.model.filter(3);
        }
    }

    private class SelectFoundListener
    implements ActionListener {
        private SelectFoundListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GDCollectionPane.this.model.filter(2);
        }
    }

    private class SearchItemsListener
    implements ActionListener {
        private SearchItemsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GDCollectionPane.this.setCursor(Cursor.getPredefinedCursor(3));
            GDCollectionPane.this.search();
            GDCollectionPane.this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private static class GDItemTableCellRenderer
    extends DefaultTableCellRenderer {
        private GDItemTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            if (col == 0) {
                return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            }
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            GDItemCollectionTableModel model = (GDItemCollectionTableModel)table.getModel();
            label.setForeground(model.getCellTextColor(row, col));
            label.setBackground(model.getCellBgColor(row, col));
            return label;
        }
    }

    public static class GDItemInfo
    implements Comparable<GDItemInfo> {
        public GDItem gdItem;
        public int scCount;
        public int hcCount;

        public GDItemInfo(GDItem item) {
            this.gdItem = item;
            this.scCount = 0;
            this.hcCount = 0;
        }

        @Override
        public int compareTo(GDItemInfo info) {
            int i = this.gdItem.compareTo(info.gdItem);
            if (i != 0) {
                return i;
            }
            if (this.scCount != info.scCount) {
                return this.scCount - info.scCount;
            }
            return this.hcCount - info.hcCount;
        }
    }
}

