/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import org.gdstash.db.DBStashItem;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.ui.table.GDItemSimilarTableHeader;
import org.gdstash.ui.table.GDItemSimilarTableModel;
import org.gdstash.ui.util.AdjustablePanel;

public class GDItemInfoSimilarTablePane
extends AdjustablePanel {
    private GDItemSimilarTableModel model;
    private GDItemSimilarTableHeader header;
    private JTable table;
    private JScrollPane scrollPane;
    private DBStashItem.DuplicateInfo info = null;

    public GDItemInfoSimilarTablePane() {
        this.init();
    }

    @Override
    public void adjustUI() {
        Font fntLabel = UIManager.getDefaults().getFont("Label.font");
        Font fntTable = UIManager.getDefaults().getFont("TableHeader.font");
        if (fntTable == null) {
            fntTable = fntLabel;
        }
        fntLabel = fntLabel.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntTable = fntTable.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        GDItemSimilarTableHeader.updateToolTips();
        if (this.table == null) {
            this.table = new JTable();
            this.setInfo(this.info);
            if (this.header == null) {
                this.header = new GDItemSimilarTableHeader(this.table.getColumnModel());
                this.table.setTableHeader(this.header);
            }
        }
        this.table.getTableHeader().setFont(fntTable);
        this.table.setFont(fntLabel);
        int size = 12;
        if (GDStashFrame.iniConfig != null) {
            size = GDStashFrame.iniConfig.sectUI.fontSize;
        }
        this.table.setRowHeight((int)(1.5 * (double)size));
        GDItemSimilarTableModel model = (GDItemSimilarTableModel)this.table.getModel();
        model.adjustUI();
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane(this.table);
            this.scrollPane.getVerticalScrollBar().setUnitIncrement(2 * GDStashFrame.iniConfig.sectUI.fontSize);
        }
        this.updateTableColumns();
        JTableHeader jth = this.table.getTableHeader();
        int rh = this.table.getRowHeight();
        int hh = jth.getPreferredSize().height;
        Dimension dimMax = new Dimension(this.table.getPreferredSize().width, this.table.getRowHeight() + jth.getPreferredSize().height + 6);
        this.setMaximumSize(dimMax);
    }

    private void init() {
        this.adjustUI();
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateGaps(false);
        layout.setAutoCreateContainerGaps(false);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(this.scrollPane));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(this.scrollPane));
        layout.setVerticalGroup(vGroup);
    }

    private void updateTableColumns() {
        this.table.getColumnModel().getColumn(0).setCellRenderer(new GDItemSimilarTableCellRenderer());
        this.table.getColumnModel().getColumn(1).setCellRenderer(new GDItemSimilarTableCellRenderer());
        this.table.getColumnModel().getColumn(2).setCellRenderer(new GDItemSimilarTableCellRenderer());
        this.table.getColumnModel().getColumn(3).setCellRenderer(new GDItemSimilarTableCellRenderer());
        this.table.getColumnModel().getColumn(4).setCellRenderer(new GDItemSimilarTableCellRenderer());
        this.table.getColumnModel().getColumn(5).setCellRenderer(new GDItemSimilarTableCellRenderer());
    }

    public void setInfo(DBStashItem.DuplicateInfo info) {
        this.info = info;
        this.model = new GDItemSimilarTableModel(info);
        this.table.setModel(this.model);
        this.updateTableColumns();
    }

    private class GDItemSimilarTableCellRenderer
    extends DefaultTableCellRenderer {
        public GDItemSimilarTableCellRenderer() {
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            GDItemSimilarTableModel model = (GDItemSimilarTableModel)table.getModel();
            label.setForeground(model.getCellTextColor(row, col));
            label.setBackground(model.getCellBackgroundColor(row, col));
            return label;
        }
    }
}

