/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.ui;

import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableModel;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.util.GDImagePool;
import org.gdstash.util.GDLog;
import org.gdstash.util.GDMsgFormatter;

public class GDLogDialog
extends JDialog {
    private JLabel lblMessage;
    private JButton btnOk;
    private GDIconCheckBox cbSuccess;
    private GDIconCheckBox cbInfo;
    private GDIconCheckBox cbWarning;
    private GDIconCheckBox cbError;
    private GDLogTableModel model;
    private JTable table;

    public GDLogDialog(Frame owner, String message, int type, GDLog log) {
        super(owner, true);
        this.adjustUI();
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        JPanel panel = this.buildFilterPanel();
        ImageIcon icon = null;
        if (type == 0) {
            icon = GDImagePool.iconMsgSuccess32;
        }
        if (type == 1) {
            icon = GDImagePool.iconMsgInfo32;
        }
        if (type == 2) {
            icon = GDImagePool.iconMsgWarning32;
        }
        if (type == 3) {
            icon = GDImagePool.iconMsgError32;
        }
        this.lblMessage = new JLabel(message, icon, 0);
        this.btnOk.addActionListener(new OkActionListener());
        this.model = new GDLogTableModel(log);
        this.table = new JTable(this.model);
        this.table.setRowHeight(18);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(40);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(400);
        this.table.setAutoResizeMode(3);
        JScrollPane scroll = new JScrollPane(this.table);
        scroll.getVerticalScrollBar().setUnitIncrement(2 * GDStashFrame.iniConfig.sectUI.fontSize);
        layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(this.lblMessage).addComponent(this.btnOk).addComponent(panel).addComponent(scroll));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(this.lblMessage)).addGroup(layout.createParallelGroup().addComponent(this.btnOk)).addGroup(layout.createParallelGroup().addComponent(panel)).addGroup(layout.createParallelGroup().addComponent(scroll));
        layout.setVerticalGroup(vGroup);
        layout.linkSize(0, this.lblMessage, this.btnOk);
        layout.linkSize(0, this.lblMessage, panel);
        layout.linkSize(1, this.lblMessage, this.btnOk);
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setLocationRelativeTo(owner);
        this.setVisible(true);
    }

    public void adjustUI() {
        Font fntTable;
        Font fntLabel = UIManager.getDefaults().getFont("Label.font");
        Font fntButton = UIManager.getDefaults().getFont("Button.font");
        if (fntButton == null) {
            fntButton = fntLabel;
        }
        if ((fntTable = UIManager.getDefaults().getFont("TableHeader.font")) == null) {
            fntTable = fntLabel;
        }
        fntLabel = fntLabel.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntButton = fntButton.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntTable = fntTable.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        if (this.btnOk == null) {
            this.btnOk = new JButton();
        }
        this.btnOk.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "BTN_OK"));
        this.btnOk.setFont(fntButton);
        if (this.table != null) {
            this.table.getTableHeader().setFont(fntTable);
            this.table.setFont(fntLabel);
            GDLogTableModel model = (GDLogTableModel)this.table.getModel();
            model.adjustUI();
        }
        if (this.cbSuccess == null) {
            this.cbSuccess = new GDIconCheckBox(GDImagePool.iconMsgSuccess32, true);
            this.cbSuccess.addActionListener(new CheckboxActionListener());
        }
        if (this.cbInfo == null) {
            this.cbInfo = new GDIconCheckBox(GDImagePool.iconMsgInfo32, true);
            this.cbInfo.addActionListener(new CheckboxActionListener());
        }
        if (this.cbWarning == null) {
            this.cbWarning = new GDIconCheckBox(GDImagePool.iconMsgWarning32, true);
            this.cbWarning.addActionListener(new CheckboxActionListener());
        }
        if (this.cbError == null) {
            this.cbError = new GDIconCheckBox(GDImagePool.iconMsgError32, true);
            this.cbError.addActionListener(new CheckboxActionListener());
        }
    }

    private JPanel buildFilterPanel() {
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        JPanel panel = new JPanel();
        layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(this.cbSuccess)).addGroup(layout.createParallelGroup().addComponent(this.cbInfo)).addGroup(layout.createParallelGroup().addComponent(this.cbWarning)).addGroup(layout.createParallelGroup().addComponent(this.cbError));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(this.cbSuccess).addComponent(this.cbInfo).addComponent(this.cbWarning).addComponent(this.cbError));
        layout.setVerticalGroup(vGroup);
        layout.linkSize(0, this.cbSuccess, this.cbInfo);
        layout.linkSize(0, this.cbSuccess, this.cbWarning);
        layout.linkSize(0, this.cbSuccess, this.cbError);
        layout.linkSize(1, this.cbSuccess, this.cbInfo);
        layout.linkSize(1, this.cbSuccess, this.cbWarning);
        layout.linkSize(1, this.cbSuccess, this.cbError);
        return panel;
    }

    private class OkActionListener
    implements ActionListener {
        private OkActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GDLogDialog.this.setVisible(false);
            GDLogDialog.this.dispatchEvent(new WindowEvent(GDLogDialog.this, 201));
        }
    }

    private class CheckboxActionListener
    implements ActionListener {
        private CheckboxActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GDLogDialog.this.model.filterMessages(GDLogDialog.this.cbSuccess.isSeleted(), GDLogDialog.this.cbInfo.isSeleted(), GDLogDialog.this.cbWarning.isSeleted(), GDLogDialog.this.cbError.isSeleted());
        }
    }

    private static class GDIconCheckBox
    extends JComponent {
        private JCheckBox checkbox = new JCheckBox();
        private JLabel label;

        public GDIconCheckBox(Icon icon, boolean selected) {
            this.checkbox.setSelected(selected);
            this.label = new JLabel(icon);
            GroupLayout layout = null;
            GroupLayout.SequentialGroup hGroup = null;
            GroupLayout.SequentialGroup vGroup = null;
            layout = new GroupLayout(this);
            this.setLayout(layout);
            layout.setAutoCreateGaps(true);
            layout.setAutoCreateContainerGaps(true);
            hGroup = layout.createSequentialGroup();
            hGroup.addGroup(layout.createParallelGroup().addComponent(this.checkbox)).addGroup(layout.createParallelGroup().addComponent(this.label));
            layout.setHorizontalGroup(hGroup);
            vGroup = layout.createSequentialGroup();
            vGroup.addGroup(layout.createParallelGroup().addComponent(this.checkbox).addComponent(this.label));
            layout.setVerticalGroup(vGroup);
            layout.linkSize(1, this.checkbox, this.label);
        }

        public void addActionListener(ActionListener listener) {
            this.checkbox.addActionListener(listener);
        }

        public void addItemListener(ItemListener listener) {
            this.checkbox.addItemListener(listener);
        }

        public void removeActionListener(ActionListener listener) {
            this.checkbox.removeActionListener(listener);
        }

        public void removeItemListener(ItemListener listener) {
            this.checkbox.removeItemListener(listener);
        }

        public boolean isSeleted() {
            return this.checkbox.isSelected();
        }

        public void setSelected(boolean selected) {
            this.checkbox.setSelected(selected);
        }
    }

    private static class GDLogTableModel
    extends DefaultTableModel {
        private static String[] columnNames = null;
        private GDLog.LogEntry[] entries;
        private String[] messages;
        private Icon[] icons;
        private int iSuccess;
        private int iInfo;
        private int iWarning;
        private int iError;

        public GDLogTableModel(GDLog log) {
            List<GDLog.LogEntry> list = log.getLog();
            this.adjustUI();
            this.entries = new GDLog.LogEntry[list.size()];
            this.iSuccess = 0;
            this.iInfo = 0;
            this.iWarning = 0;
            this.iError = 0;
            int i = 0;
            for (GDLog.LogEntry entry : list) {
                if (entry.type == 0) {
                    ++this.iSuccess;
                }
                if (entry.type == 1) {
                    ++this.iInfo;
                }
                if (entry.type == 2) {
                    ++this.iWarning;
                }
                if (entry.type == 3) {
                    ++this.iError;
                }
                this.entries[i] = entry;
                ++i;
            }
            this.filterMessages(true, true, true, true);
        }

        public void adjustUI() {
            if (columnNames == null) {
                columnNames = new String[2];
            }
            GDLogTableModel.columnNames[0] = GDMsgFormatter.getString(GDMsgFormatter.rbUI, "TXT_TYPE");
            GDLogTableModel.columnNames[1] = GDMsgFormatter.getString(GDMsgFormatter.rbUI, "TXT_MESSAGE");
            this.setColumnIdentifiers(columnNames);
        }

        @Override
        public int getRowCount() {
            if (this.messages == null) {
                return 0;
            }
            return this.messages.length;
        }

        @Override
        public int getColumnCount() {
            return columnNames.length;
        }

        @Override
        public String getColumnName(int column) {
            return columnNames[column];
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (this.messages == null) {
                return null;
            }
            if (column == 0) {
                return this.icons[row];
            }
            if (column == 1) {
                return this.messages[row];
            }
            return null;
        }

        public Class getColumnClass(int column) {
            if (column == 0) {
                return Icon.class;
            }
            if (column == 1) {
                return String.class;
            }
            return Object.class;
        }

        public void filterMessages(boolean success, boolean info, boolean warning, boolean error) {
            int size = 0;
            if (success) {
                size += this.iSuccess;
            }
            if (info) {
                size += this.iInfo;
            }
            if (warning) {
                size += this.iWarning;
            }
            if (error) {
                size += this.iError;
            }
            if (size == 0) {
                this.messages = null;
                this.icons = null;
                this.fireTableDataChanged();
                return;
            }
            this.messages = new String[size];
            this.icons = new Icon[size];
            int count = 0;
            for (int i = 0; i < this.entries.length; ++i) {
                boolean match = false;
                ImageIcon icon = null;
                if (success && this.entries[i].type == 0) {
                    match = true;
                    icon = GDImagePool.iconMsgSuccess16;
                }
                if (info && this.entries[i].type == 1) {
                    match = true;
                    icon = GDImagePool.iconMsgInfo16;
                }
                if (warning && this.entries[i].type == 2) {
                    match = true;
                    icon = GDImagePool.iconMsgWarning16;
                }
                if (error && this.entries[i].type == 3) {
                    match = true;
                    icon = GDImagePool.iconMsgError16;
                }
                if (!match) continue;
                this.messages[count] = this.entries[i].str;
                this.icons[count] = icon;
                ++count;
            }
            this.fireTableDataChanged();
        }
    }
}

