/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.ui;

import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.util.GDImagePool;
import org.gdstash.util.GDMsgFormatter;

public class GDLogoDialog
extends JDialog {
    private Component owner;
    private JPanel panel;
    private JLabel lblImage;
    private JLabel lblIcon;
    private JLabel lblText;
    private JButton btnClose;

    public GDLogoDialog(String text) {
        this(text, 0);
    }

    public GDLogoDialog(String text, int iconType) {
        this.owner = null;
        this.buildPanel(text, iconType);
    }

    public GDLogoDialog(String text, Frame owner) {
        this(text, 0, owner, "", false);
    }

    public GDLogoDialog(String text, int iconType, Frame owner) {
        this(text, iconType, owner, "", false);
    }

    public GDLogoDialog(String text, Frame owner, boolean modal) {
        this(text, 0, owner, "", modal);
    }

    public GDLogoDialog(String text, int iconType, Frame owner, boolean modal) {
        this(text, iconType, owner, "", modal);
    }

    public GDLogoDialog(String text, Frame owner, String title) {
        this(text, 0, owner, title, false);
    }

    public GDLogoDialog(String text, int iconType, Frame owner, String title) {
        this(text, iconType, owner, title, false);
    }

    public GDLogoDialog(String text, int iconType, Frame owner, String title, boolean modal) {
        super(owner, title, modal);
        this.owner = owner;
        this.buildPanel(text, iconType);
    }

    protected void buildPanel(String text, int iconType) {
        this.panel = new JPanel();
        Font fntLabel = UIManager.getDefaults().getFont("Label.font");
        Font fntButton = UIManager.getDefaults().getFont("Button.font");
        if (fntButton == null) {
            fntButton = fntLabel;
        }
        fntLabel = fntLabel.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntButton = fntButton.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        Border lowered = BorderFactory.createEtchedBorder(1);
        Border raised = BorderFactory.createEtchedBorder(0);
        CompoundBorder compound = BorderFactory.createCompoundBorder(raised, lowered);
        this.lblImage = new JLabel();
        this.lblImage.setIcon(GDImagePool.iconLogo460x215);
        this.lblImage.setBorder(compound);
        this.lblImage.setHorizontalAlignment(0);
        JPanel pnlText = this.buildTextPanel(text, iconType);
        this.btnClose = new JButton(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "BTN_OK"));
        this.btnClose.setIcon(GDImagePool.iconBtnOk24);
        this.btnClose.setFont(fntButton);
        this.btnClose.addActionListener(new CloseActionListener());
        layout = new GroupLayout(this.panel);
        this.panel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(this.lblImage).addComponent(pnlText).addComponent(this.btnClose));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(this.lblImage)).addGroup(layout.createParallelGroup().addComponent(pnlText)).addGroup(layout.createParallelGroup().addComponent(this.btnClose));
        layout.setVerticalGroup(vGroup);
        layout.linkSize(0, this.lblImage, pnlText);
        layout.linkSize(0, this.lblImage, this.btnClose);
        this.getContentPane().add(this.panel);
        this.pack();
        this.setLocationRelativeTo(this.owner);
        this.setIconImage(GDImagePool.iconLogo64x64.getImage());
    }

    private JPanel buildTextPanel(String text, int iconType) {
        JPanel panel = new JPanel();
        Font fntLabel = UIManager.getDefaults().getFont("Label.font");
        fntLabel = fntLabel.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        Border lowered = BorderFactory.createEtchedBorder(1);
        Border raised = BorderFactory.createEtchedBorder(0);
        CompoundBorder compound = BorderFactory.createCompoundBorder(raised, lowered);
        panel.setBorder(compound);
        if (iconType != 0) {
            this.lblIcon = new JLabel();
            this.setIcon(iconType);
            this.lblIcon.setBorder(compound);
        }
        this.lblText = new JLabel();
        this.lblText.setText(text);
        this.lblText.setVerticalAlignment(0);
        this.lblText.setFont(fntLabel);
        layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        if (iconType == 0) {
            hGroup.addGroup(layout.createParallelGroup().addComponent(this.lblText));
        } else {
            hGroup.addGroup(layout.createParallelGroup().addComponent(this.lblIcon)).addGroup(layout.createParallelGroup().addComponent(this.lblText));
        }
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        if (iconType == 0) {
            vGroup.addGroup(layout.createParallelGroup().addComponent(this.lblText));
        } else {
            vGroup.addGroup(layout.createParallelGroup().addComponent(this.lblIcon).addComponent(this.lblText));
        }
        layout.setVerticalGroup(vGroup);
        if (iconType != 0) {
            layout.linkSize(1, this.lblIcon, this.lblText);
        }
        return panel;
    }

    private void setIcon(int iconType) {
        switch (iconType) {
            case 1: {
                this.lblIcon.setIcon(GDImagePool.iconMsgSuccess32);
                break;
            }
            case 2: {
                this.lblIcon.setIcon(GDImagePool.iconMsgInfo32);
                break;
            }
            case 3: {
                this.lblIcon.setIcon(GDImagePool.iconMsgWarning32);
                break;
            }
            case 4: {
                this.lblIcon.setIcon(GDImagePool.iconMsgError32);
                break;
            }
            default: {
                this.lblIcon.setIcon(null);
            }
        }
    }

    private class CloseActionListener
    implements ActionListener {
        private CloseActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GDLogoDialog.this.setVisible(false);
            GDLogoDialog.this.dispatchEvent(new WindowEvent(GDLogoDialog.this, 201));
        }
    }
}

