/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.ui;

import java.awt.Cursor;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.gdstash.character.GDChar;
import org.gdstash.db.DBStashItem;
import org.gdstash.item.GDItem;
import org.gdstash.item.GDStash;
import org.gdstash.ui.GDDialog;
import org.gdstash.ui.GDItemImportTablePane;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.ui.util.AdjustablePanel;
import org.gdstash.util.GDConstants;
import org.gdstash.util.GDImagePool;
import org.gdstash.util.GDMsgFormatter;
import org.gdstash.util.GDMsgLogger;

public class GDMassImportPane
extends AdjustablePanel {
    private String strSave;
    private GDStashFrame frame;
    private JLabel lblDir;
    private JButton btnDir;
    private JButton btnLoad;
    private JButton btnImport;
    private JButton btnStashExp;
    private JButton btnStashImp;
    private String strDir;
    private File fileDir;
    private List<GDItem> items;
    private GDItemImportTablePane pnlTable;
    private JPanel pnlDir;
    private JPanel pnlStash;
    private JPanel pnlDB;

    public GDMassImportPane(GDStashFrame frame) {
        this.strSave = GDStashFrame.iniConfig.sectDir.savePath;
        this.frame = frame;
        this.adjustUI();
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        JPanel pnlImExp = this.buildImpExpPanel();
        layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(pnlImExp).addComponent(this.pnlTable));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(pnlImExp)).addGroup(layout.createParallelGroup().addComponent(this.pnlTable));
        layout.setVerticalGroup(vGroup);
    }

    @Override
    public void adjustUI() {
        Font fntBorder;
        Font fntLabel = UIManager.getDefaults().getFont("Label.font");
        Font fntButton = UIManager.getDefaults().getFont("Button.font");
        if (fntButton == null) {
            fntButton = fntLabel;
        }
        if ((fntBorder = UIManager.getDefaults().getFont("TitledBorder.font")) == null) {
            fntBorder = fntLabel;
        }
        fntLabel = fntLabel.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntButton = fntButton.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntBorder = fntBorder.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        if (this.btnDir == null) {
            this.btnDir = new JButton();
            this.btnDir.addActionListener(new ImportDirListener());
        }
        this.btnDir.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "BTN_SET_IMPORT_DIR"));
        this.btnDir.setIcon(GDImagePool.iconBtnDir24);
        this.btnDir.setFont(fntButton);
        if (this.lblDir == null) {
            this.lblDir = new JLabel();
        }
        this.lblDir.setFont(fntLabel);
        if (this.btnLoad == null) {
            this.btnLoad = new JButton();
            this.btnLoad.addActionListener(new FileLoadListener());
        }
        this.btnLoad.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "BTN_LOAD_TRANSFER"));
        this.btnLoad.setIcon(GDImagePool.iconMassItemLoad24);
        this.btnLoad.setFont(fntButton);
        if (this.btnStashImp == null) {
            this.btnStashImp = new JButton();
            this.btnStashImp.addActionListener(new StashLoadListener());
        }
        this.btnStashImp.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "BTN_LOAD_DB_STASH"));
        this.btnStashImp.setIcon(GDImagePool.iconMassGDSLoad24);
        this.btnStashImp.setFont(fntButton);
        if (this.btnImport == null) {
            this.btnImport = new JButton();
            this.btnImport.addActionListener(new ImportDBListener());
        }
        this.btnImport.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "BTN_IMPORT_ITEMS"));
        this.btnImport.setIcon(GDImagePool.iconMassItemImport24);
        this.btnImport.setFont(fntButton);
        if (this.btnStashExp == null) {
            this.btnStashExp = new JButton();
            this.btnStashExp.addActionListener(new StashExportListener());
        }
        this.btnStashExp.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "BTN_EXPORT_STASH"));
        this.btnStashExp.setIcon(GDImagePool.iconMassGDSExport24);
        this.btnStashExp.setFont(fntButton);
        Border lowered = BorderFactory.createEtchedBorder(1);
        Border raised = BorderFactory.createEtchedBorder(0);
        CompoundBorder compound = BorderFactory.createCompoundBorder(raised, lowered);
        TitledBorder text = null;
        if (this.pnlDir != null) {
            text = BorderFactory.createTitledBorder(compound, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "BRD_DIRECTORY"));
            text.setTitleFont(fntBorder);
            this.pnlDir.setBorder(text);
        }
        if (this.pnlStash != null) {
            text = BorderFactory.createTitledBorder(compound, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "BRD_IMPORT_ITEMS"));
            text.setTitleFont(fntBorder);
            this.pnlStash.setBorder(text);
        }
        if (this.pnlDB != null) {
            text = BorderFactory.createTitledBorder(compound, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "BRD_EXPORT_DB"));
            text.setTitleFont(fntBorder);
            this.pnlDB.setBorder(text);
        }
        if (this.pnlTable == null) {
            this.pnlTable = new GDItemImportTablePane((List<GDItem>)null);
        }
        this.pnlTable.adjustUI();
    }

    private JPanel buildImpExpPanel() {
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        this.pnlDir = this.buildDirPanel();
        this.pnlStash = this.buildImportPanel();
        this.pnlDB = this.buildExportPanel();
        JPanel pnlImpExp = new JPanel();
        layout = new GroupLayout(pnlImpExp);
        pnlImpExp.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(false);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(this.pnlStash)).addGroup(layout.createParallelGroup().addComponent(this.pnlDB));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(this.pnlStash).addComponent(this.pnlDB));
        layout.setVerticalGroup(vGroup);
        JPanel panel = new JPanel();
        layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(false);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(this.pnlDir).addComponent(pnlImpExp));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(this.pnlDir)).addGroup(layout.createParallelGroup().addComponent(pnlImpExp));
        layout.setVerticalGroup(vGroup);
        layout.linkSize(0, this.pnlDir, pnlImpExp);
        return panel;
    }

    private JPanel buildDirPanel() {
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        Border lowered = BorderFactory.createEtchedBorder(1);
        Border raised = BorderFactory.createEtchedBorder(0);
        CompoundBorder compound = BorderFactory.createCompoundBorder(raised, lowered);
        TitledBorder text = BorderFactory.createTitledBorder(compound, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "BRD_DIRECTORY"));
        JPanel panel = new JPanel();
        this.strDir = GDStashFrame.iniConfig.sectDir.savePath;
        if (this.strDir != null) {
            this.fileDir = new File(this.strDir);
        }
        if (this.strDir == null) {
            this.lblDir.setText("");
        } else {
            this.lblDir.setText(this.strDir);
        }
        layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(this.btnDir)).addGroup(layout.createParallelGroup().addComponent(this.lblDir));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(this.btnDir).addComponent(this.lblDir));
        layout.setVerticalGroup(vGroup);
        layout.linkSize(1, this.btnDir, this.lblDir);
        panel.setBorder(text);
        return panel;
    }

    private JPanel buildImportPanel() {
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        Border lowered = BorderFactory.createEtchedBorder(1);
        Border raised = BorderFactory.createEtchedBorder(0);
        CompoundBorder compound = BorderFactory.createCompoundBorder(raised, lowered);
        TitledBorder text = BorderFactory.createTitledBorder(compound, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "BRD_IMPORT_ITEMS"));
        JPanel panel = new JPanel();
        layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(this.btnLoad)).addGroup(layout.createParallelGroup().addComponent(this.btnStashImp)).addGroup(layout.createParallelGroup().addComponent(this.btnImport));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(this.btnLoad).addComponent(this.btnStashImp).addComponent(this.btnImport));
        layout.setVerticalGroup(vGroup);
        layout.linkSize(0, this.btnLoad, this.btnStashImp);
        layout.linkSize(0, this.btnLoad, this.btnImport);
        layout.linkSize(1, this.btnLoad, this.btnStashImp);
        layout.linkSize(1, this.btnLoad, this.btnImport);
        panel.setBorder(text);
        return panel;
    }

    private JPanel buildExportPanel() {
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        Border lowered = BorderFactory.createEtchedBorder(1);
        Border raised = BorderFactory.createEtchedBorder(0);
        CompoundBorder compound = BorderFactory.createCompoundBorder(raised, lowered);
        TitledBorder text = BorderFactory.createTitledBorder(compound, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "BRD_EXPORT_DB"));
        JPanel panel = new JPanel();
        layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(this.btnStashExp));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(this.btnStashExp));
        layout.setVerticalGroup(vGroup);
        panel.setBorder(text);
        return panel;
    }

    private void processDir(File dir) {
        if (dir == null) {
            return;
        }
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file == null) continue;
            if (file.isDirectory()) {
                this.processDir(file);
            }
            if (!file.isFile()) continue;
            this.processFile(file);
        }
    }

    private void processFile(File file) {
        String s = file.getName().toUpperCase(GDConstants.LOCALE_US);
        if (s.endsWith(".GST") || s.endsWith(".GSH")) {
            if (!s.equals("FORMULAS.GST") && !s.equals("FORMULAS.GSH")) {
                GDStash stash = new GDStash(file);
                if (stash.hasStashErrors()) {
                    return;
                }
                this.items.addAll(stash.getItems());
            }
            return;
        }
        if (s.equals("PLAYER.GDC")) {
            GDChar gdc = new GDChar(file);
            gdc.read();
            if (gdc.hasErrors()) {
                return;
            }
            this.items.addAll(gdc.getItems());
            return;
        }
    }

    private void loadStash(File file) {
        String s = file.getName();
        int pos = s.indexOf(".GST");
        if (pos == -1) {
            pos = s.indexOf(".gst");
        }
        if (pos == -1) {
            pos = s.indexOf(".GSH");
        }
        if (pos == -1) {
            pos = s.indexOf(".gsh");
        }
        if (pos == s.length() - 4) {
            GDStash stash = new GDStash(file);
            if (stash.hasStashErrors()) {
                return;
            }
            this.items.addAll(stash.getItems());
        }
    }

    private class StashExportListener
    implements ActionListener {
        private StashExportListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser chooser = new JFileChooser(GDMassImportPane.this.strSave);
            chooser.setFileSelectionMode(0);
            chooser.setFileFilter(new FileNameExtensionFilter(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "TXT_GD_STASH"), "gds"));
            chooser.setAcceptAllFileFilterUsed(false);
            if (chooser.showSaveDialog(GDMassImportPane.this) == 0) {
                try {
                    String filename = chooser.getSelectedFile().getCanonicalPath();
                    if (!filename.endsWith(".gds")) {
                        filename = filename + ".gds";
                    }
                    File fStash = new File(filename);
                    DBStashItem.write(fStash);
                }
                catch (IOException ex) {
                    GDMsgLogger.addError(ex);
                }
                GDMsgLogger.showLog(GDMassImportPane.this.frame, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "SUCC_EXPORT"), 0, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERR_EXPORT"), true);
            }
        }
    }

    private class ImportDBListener
    implements ActionListener {
        private ImportDBListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List<GDItem> items = GDMassImportPane.this.pnlTable.getSelectedItems();
            if (items == null || items.isEmpty()) {
                GDDialog dialog = new GDDialog(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERR_ITEM_NO_SEL"), 4, GDMassImportPane.this.frame, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERROR"), true);
                dialog.setVisible(true);
                return;
            }
            GDMassImportPane.this.setCursor(Cursor.getPredefinedCursor(3));
            DBStashItem.storeGDItems(items);
            GDMassImportPane.this.setCursor(Cursor.getDefaultCursor());
            GDMsgLogger.showLog(GDMassImportPane.this.frame, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "SUCC_STORE"), 0, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERR_STORE"), true);
        }
    }

    private class StashLoadListener
    implements ActionListener {
        private StashLoadListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser chooser = new JFileChooser(GDMassImportPane.this.strSave);
            chooser.setFileSelectionMode(0);
            chooser.setFileFilter(new FileNameExtensionFilter(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "TXT_GD_STASH"), "gds"));
            chooser.setAcceptAllFileFilterUsed(false);
            if (chooser.showOpenDialog(GDMassImportPane.this) == 0) {
                File fStash = chooser.getSelectedFile();
                if (!fStash.exists()) {
                    GDDialog dialog = new GDDialog(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERR_FILE_NOT_EXIST"), 4, GDMassImportPane.this.frame, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERROR"), true);
                    dialog.setVisible(true);
                    return;
                }
                GDMassImportPane.this.setCursor(Cursor.getPredefinedCursor(3));
                GDMassImportPane.this.items = DBStashItem.load(fStash);
                GDMassImportPane.this.pnlTable.setItems(GDMassImportPane.this.items);
                GDMassImportPane.this.setCursor(Cursor.getDefaultCursor());
                GDMsgLogger.showLog(GDMassImportPane.this.frame, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "SUCC_IMPORT"), 0, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERR_IMPORT"));
            }
        }
    }

    private class FileLoadListener
    implements ActionListener {
        private FileLoadListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (GDMassImportPane.this.strDir == null) {
                return;
            }
            GDMassImportPane.this.setCursor(Cursor.getPredefinedCursor(3));
            GDMassImportPane.this.items = new LinkedList();
            File file = new File(GDMassImportPane.this.strDir);
            if (file.isDirectory()) {
                GDMassImportPane.this.processDir(file);
            }
            if (file.isFile()) {
                GDMassImportPane.this.processFile(file);
            }
            GDMassImportPane.this.pnlTable.setItems(GDMassImportPane.this.items);
            GDMassImportPane.this.setCursor(Cursor.getDefaultCursor());
            GDMsgLogger.showLog(GDMassImportPane.this.frame, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "SUCC_IMPORT"), 0, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERR_IMPORT"));
        }
    }

    private class ImportDirListener
    implements ActionListener {
        private ImportDirListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser chooser = new JFileChooser(GDMassImportPane.this.fileDir);
            chooser.setFileSelectionMode(1);
            chooser.setAcceptAllFileFilterUsed(false);
            if (chooser.showOpenDialog(GDMassImportPane.this) == 0) {
                try {
                    GDMassImportPane.this.fileDir = chooser.getSelectedFile();
                    GDMassImportPane.this.strDir = GDMassImportPane.this.fileDir.getCanonicalPath();
                    GDMassImportPane.this.lblDir.setText(GDMassImportPane.this.strDir);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

