/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.gdstash.db.SelectionCriteria;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.ui.GDUISearch;
import org.gdstash.ui.select.FullSelectionPane;
import org.gdstash.util.GDImagePool;
import org.gdstash.util.GDLog;
import org.gdstash.util.GDMsgFormatter;
import org.gdstash.util.GDMsgLogger;

public class GDSearchDialog
extends JDialog {
    private Component owner;
    private JButton btnSearch;
    private JButton btnClear;
    private FullSelectionPane pnlSelect;
    private GDUISearch uiSearch;
    private JPanel pnlMain;

    public GDSearchDialog(GDUISearch uiSearch) {
        this(null, uiSearch, true);
    }

    public GDSearchDialog(Frame owner, GDUISearch uiSearch) {
        this(owner, uiSearch, true);
    }

    public GDSearchDialog(Frame owner, GDUISearch uiSearch, boolean modal) {
        super(owner, modal);
        this.owner = owner;
        this.uiSearch = uiSearch;
        this.adjustUI();
        this.pnlMain = this.buildPanel();
        this.getContentPane().add(this.pnlMain);
        this.pack();
        this.setLocationRelativeTo(owner);
    }

    public void adjustUI() {
        this.setTitle(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "BTN_SEARCH"));
        Font fntLabel = UIManager.getDefaults().getFont("Label.font");
        Font fntButton = UIManager.getDefaults().getFont("Button.font");
        if (fntButton == null) {
            fntButton = fntLabel;
        }
        fntButton = fntButton.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        if (this.btnSearch == null) {
            this.btnSearch = new JButton();
            this.btnSearch.addActionListener(new SearchActionListener());
        }
        this.btnSearch.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "BTN_SEARCH"));
        this.btnSearch.setIcon(GDImagePool.iconBtnSearch24);
        this.btnSearch.setFont(fntButton);
        GDStashFrame.setMnemonic(this.btnSearch, "MNC_SEARCH");
        if (this.btnClear == null) {
            this.btnClear = new JButton();
            this.btnClear.addActionListener(new ClearActionListener());
        }
        this.btnClear.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "BTN_CLEAR"));
        this.btnClear.setIcon(GDImagePool.iconItemDelete24);
        this.btnClear.setFont(fntButton);
        GDStashFrame.setMnemonic(this.btnClear, "MNC_CLEAR");
        if (this.pnlSelect == null) {
            this.pnlSelect = new FullSelectionPane();
        } else {
            this.pnlSelect.adjustUI();
        }
        this.pack();
    }

    private JPanel buildPanel() {
        JPanel panel = new JPanel();
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        JPanel pnlButton = this.buildButtonPanel();
        layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(pnlButton).addComponent(this.pnlSelect));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(pnlButton)).addGroup(layout.createParallelGroup().addComponent(this.pnlSelect));
        layout.setVerticalGroup(vGroup);
        layout.linkSize(0, pnlButton, this.pnlSelect);
        return panel;
    }

    private JPanel buildButtonPanel() {
        BorderLayout layout = new BorderLayout();
        JPanel panel = new JPanel();
        panel.setLayout(layout);
        panel.add((Component)this.btnSearch, "Center");
        panel.add((Component)this.btnClear, "West");
        return panel;
    }

    public void updateConfig() {
        if (this.pnlSelect != null) {
            this.pnlSelect.updateConfig();
        }
    }

    private class ClearActionListener
    implements ActionListener {
        private ClearActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GDSearchDialog.this.pnlSelect.clear();
        }
    }

    private class SearchActionListener
    implements ActionListener {
        private SearchActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GDLog log = new GDLog();
            SelectionCriteria criteria = new SelectionCriteria();
            GDSearchDialog.this.pnlSelect.addCriteria(criteria);
            criteria.checkCriteria(log);
            if (log.containsErrors()) {
                GDMsgLogger.addLog(log);
                GDMsgLogger.showLog(GDSearchDialog.this, GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_SEARCH"));
                return;
            }
            GDSearchDialog.this.setCursor(Cursor.getPredefinedCursor(3));
            if (GDSearchDialog.this.uiSearch != null) {
                GDSearchDialog.this.uiSearch.search(criteria);
            }
            GDSearchDialog.this.setVisible(false);
            GDSearchDialog.this.setCursor(Cursor.getDefaultCursor());
        }
    }
}

