/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.ui;

import java.awt.Component;
import java.awt.Font;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.ui.util.AdjustableTabbedPane;
import org.gdstash.util.GDImagePool;
import org.gdstash.util.GDMsgFormatter;

public class GDTabbedPane
extends AdjustableTabbedPane {
    private GDStashFrame frame;

    public GDTabbedPane(GDStashFrame frame) {
        this.frame = frame;
        this.add(frame.pnlTransfer);
        this.add(frame.pnlCharInventory);
        this.add(frame.pnlCraft);
        this.add(frame.pnlCharEdit);
        this.add(frame.pnlCollection);
        this.add(frame.pnlMassImport);
        this.add(frame.pnlConfig);
        this.adjustUI();
        this.addChangeListener(new TabChangeListener());
        this.checkTabs();
        if (!GDStashFrame.dbConfig.configInit || !GDStashFrame.dbConfig.gddbInit) {
            this.setSelectedIndex(this.getTabCount() - 1);
        }
    }

    @Override
    public void adjustUI() {
        Font fntLabel = UIManager.getDefaults().getFont("Label.font");
        Font fntTabbed = UIManager.getDefaults().getFont("TabbedPane.font");
        fntTabbed = fntTabbed.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        this.setFont(fntTabbed);
        int index = 0;
        this.setTitleAt(index, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "HEADER_ITEM_TRANS"));
        this.setIconAt(index, GDImagePool.iconTabStashTransfer16);
        this.setTitleAt(++index, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "HEADER_CHAR_TRANS"));
        this.setIconAt(index, GDImagePool.iconTabCharTransfer16);
        this.setTitleAt(++index, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "HEADER_CRAFTING"));
        this.setIconAt(index, GDImagePool.iconTabStashCraft16);
        this.setTitleAt(++index, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "HEADER_CHAR_EDIT"));
        this.setIconAt(index, GDImagePool.iconTabCharEdit16);
        this.setTitleAt(++index, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "HEADER_COLLECTION"));
        this.setIconAt(index, GDImagePool.iconTabCollection16);
        this.setTitleAt(++index, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "HEADER_MASS_IMPORT"));
        this.setIconAt(index, GDImagePool.iconTabFileImp16);
        this.setTitleAt(++index, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "HEADER_CONFIG"));
        this.setIconAt(index, GDImagePool.iconTabConfigure16);
        ++index;
    }

    public void checkTabs() {
        boolean enable = GDStashFrame.dbConfig.configInit && GDStashFrame.dbConfig.gddbInit;
        int count = this.getTabCount();
        for (int i = 0; i < count - 1; ++i) {
            this.setEnabledAt(i, enable);
        }
    }

    private class TabChangeListener
    implements ChangeListener {
        private TabChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            Component comp = GDTabbedPane.this.getSelectedComponent();
            if (comp == ((GDTabbedPane)GDTabbedPane.this).frame.pnlTransfer) {
                ((GDTabbedPane)GDTabbedPane.this).frame.pnlTransfer.checkSaveButton();
                ((GDTabbedPane)GDTabbedPane.this).frame.pnlTransfer.updateStash();
            }
            if (comp == ((GDTabbedPane)GDTabbedPane.this).frame.pnlCraft) {
                ((GDTabbedPane)GDTabbedPane.this).frame.pnlCraft.checkSaveButton();
                ((GDTabbedPane)GDTabbedPane.this).frame.pnlCraft.updateStash();
            }
        }
    }
}

