/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.ui.character;

import java.awt.Dimension;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import org.gdstash.character.GDChar;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.ui.table.GDDevotionTable;
import org.gdstash.ui.table.GDDevotionTableModel;
import org.gdstash.ui.util.AdjustablePanel;
import org.gdstash.util.GDMsgFormatter;

public class GDCharDevotionPane
extends AdjustablePanel {
    private GDDevotionTableModel model;
    private GDDevotionTable table;

    public GDCharDevotionPane() {
        this.adjustUI();
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        JScrollPane scroll = new JScrollPane(this.table);
        layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(scroll));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(scroll));
        layout.setVerticalGroup(vGroup);
    }

    @Override
    public void adjustUI() {
        Font fntBorder;
        Font fntLabel = UIManager.getDefaults().getFont("Label.font");
        Font fntTable = UIManager.getDefaults().getFont("TableHeader.font");
        if (fntTable == null) {
            fntTable = fntLabel;
        }
        if ((fntBorder = UIManager.getDefaults().getFont("TitledBorder.font")) == null) {
            fntBorder = fntLabel;
        }
        fntLabel = fntLabel.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntTable = fntTable.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntBorder = fntBorder.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        Border lowered = BorderFactory.createEtchedBorder(1);
        Border raised = BorderFactory.createEtchedBorder(0);
        CompoundBorder compound = BorderFactory.createCompoundBorder(raised, lowered);
        TitledBorder text = BorderFactory.createTitledBorder(compound, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "TXT_DEVOTION_SKILLS"));
        text.setTitleFont(fntBorder);
        this.setBorder(text);
        if (this.table == null) {
            this.table = new GDDevotionTable();
            this.table.setPreferredScrollableViewportSize(new Dimension(GDStashFrame.iniConfig.sectUI.fontSize * 25, GDStashFrame.iniConfig.sectUI.fontSize * 15));
            this.setChar(null);
        }
        this.table.getTableHeader().setFont(fntTable);
        this.table.setFont(fntLabel);
    }

    public void setChar(GDChar gdc) {
        this.model = new GDDevotionTableModel(gdc);
        this.table.setModel(this.model);
        this.table.setSelectionMode(0);
    }

    public void updateChar(GDChar gdc) {
        if (gdc == null) {
            return;
        }
        GDDevotionTableModel model = (GDDevotionTableModel)this.table.getModel();
        GDChar.SkillInfo[] devotions = model.getDevotions();
        gdc.setSkillLevel(devotions);
    }
}

