/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.ui.character;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import org.gdstash.character.GDChar;
import org.gdstash.ui.GDLogoDialog;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.ui.character.GDCharDevotionPane;
import org.gdstash.ui.character.GDCharFactionPane;
import org.gdstash.ui.character.GDCharRiftShrineTabbedPane;
import org.gdstash.ui.character.GDCharStatAchievementPane;
import org.gdstash.ui.character.GDCharStatEditPane;
import org.gdstash.ui.util.AdjustablePanel;
import org.gdstash.ui.util.GDCharInfoList;
import org.gdstash.util.GDConstants;
import org.gdstash.util.GDImagePool;
import org.gdstash.util.GDMsgFormatter;
import org.gdstash.util.GDMsgLogger;

public class GDCharEditPane
extends AdjustablePanel {
    private GDStashFrame frame;
    private GDCharStatEditPane pnlEdit;
    private GDCharFactionPane pnlFactions;
    private GDCharDevotionPane pnlDevotions;
    private GDCharRiftShrineTabbedPane pnlRiftShrines;
    private GDCharStatAchievementPane pnlAchieve;
    private JButton btnReload;
    private JComboBox<String> cbSelChar;
    private JButton btnFileSave;
    private JPanel pnlMain;
    private GDCharInfoList.GDCharFileInfo info;

    public GDCharEditPane(GDStashFrame frame) {
        this.frame = frame;
        this.adjustUI();
        this.setChar(null);
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        this.pnlMain = this.buildMainPanel();
        JScrollPane scroll = new JScrollPane(this.pnlMain);
        scroll.getVerticalScrollBar().setUnitIncrement(2 * GDStashFrame.iniConfig.sectUI.fontSize);
        layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(scroll));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(scroll));
        layout.setVerticalGroup(vGroup);
    }

    @Override
    public void adjustUI() {
        Font fntCombo;
        Font fntLabel = UIManager.getDefaults().getFont("Label.font");
        Font fntButton = UIManager.getDefaults().getFont("Button.font");
        if (fntButton == null) {
            fntButton = fntLabel;
        }
        if ((fntCombo = UIManager.getDefaults().getFont("ComboBox.font")) == null) {
            fntCombo = fntLabel;
        }
        fntLabel = fntLabel.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntButton = fntButton.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntCombo = fntCombo.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        GDCharInfoList.adjustCharInfos(null, null);
        if (this.pnlEdit == null) {
            this.pnlEdit = new GDCharStatEditPane();
        } else {
            this.pnlEdit.adjustUI();
        }
        if (this.pnlFactions == null) {
            this.pnlFactions = new GDCharFactionPane();
        } else {
            this.pnlFactions.adjustUI();
        }
        if (this.pnlDevotions == null) {
            this.pnlDevotions = new GDCharDevotionPane();
        } else {
            this.pnlDevotions.adjustUI();
        }
        if (this.pnlRiftShrines == null) {
            this.pnlRiftShrines = new GDCharRiftShrineTabbedPane();
        } else {
            this.pnlRiftShrines.adjustUI();
        }
        if (this.pnlAchieve == null) {
            this.pnlAchieve = new GDCharStatAchievementPane();
        } else {
            this.pnlAchieve.adjustUI();
        }
        if (this.btnReload == null) {
            this.btnReload = new JButton();
            this.btnReload.addActionListener(new ReloadActionListener());
        }
        this.btnReload.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "BTN_RELOAD"));
        this.btnReload.setIcon(GDImagePool.iconBtnReload24);
        this.btnReload.setFont(fntButton);
        GDStashFrame.setMnemonic(this.btnReload, "MNC_RELOAD");
        if (this.cbSelChar == null) {
            this.cbSelChar = new JComboBox();
            this.cbSelChar.addActionListener(new CharSelectActionListener());
        }
        int idx = this.cbSelChar.getSelectedIndex();
        this.cbSelChar.removeAllItems();
        String[] entries = GDCharInfoList.getCharInfos();
        for (int i = 0; i < entries.length; ++i) {
            this.cbSelChar.addItem(entries[i]);
        }
        if (idx != -1) {
            this.cbSelChar.setSelectedIndex(idx);
        }
        this.cbSelChar.setFont(fntCombo);
        this.cbSelChar.setMaximumSize(new Dimension(1000, 3 * GDStashFrame.iniConfig.sectUI.fontSize));
        if (this.btnFileSave == null) {
            this.btnFileSave = new JButton();
            this.btnFileSave.addActionListener(new FileSaveActionListener());
        }
        this.btnFileSave.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "BTN_CHAR_SAVE"));
        this.btnFileSave.setIcon(GDImagePool.iconBtnSave24);
        this.btnFileSave.setFont(fntButton);
        GDStashFrame.setMnemonic(this.btnFileSave, "MNC_CHAR_SAVE");
    }

    public void refresh() {
        this.refreshCharSelection();
    }

    private JPanel buildMainPanel() {
        JPanel panel = new JPanel();
        JPanel pnlLeft = this.buildLeftSidePanel();
        JPanel pnlRight = this.buildRightSidePanel();
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(pnlLeft)).addGroup(layout.createParallelGroup().addComponent(pnlRight));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(pnlLeft).addComponent(pnlRight));
        layout.setVerticalGroup(vGroup);
        return panel;
    }

    private JPanel buildLeftSidePanel() {
        JPanel panel = new JPanel();
        JPanel pnlButtonFile = this.buildFileButtonPanel();
        JPanel pnlEdit = this.buildEditPanel();
        JPanel pnlFactDevo = this.buildFactDevoPanel();
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(pnlButtonFile).addComponent(pnlEdit).addComponent(pnlFactDevo));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(pnlButtonFile)).addGroup(layout.createParallelGroup().addComponent(pnlEdit)).addGroup(layout.createParallelGroup().addComponent(pnlFactDevo));
        layout.setVerticalGroup(vGroup);
        layout.linkSize(0, pnlButtonFile, pnlEdit);
        layout.linkSize(0, pnlButtonFile, pnlFactDevo);
        layout.linkSize(1, pnlEdit, pnlFactDevo);
        return panel;
    }

    private JPanel buildFileButtonPanel() {
        BorderLayout layout = new BorderLayout();
        JPanel panel = new JPanel();
        panel.setLayout(layout);
        panel.add((Component)this.btnFileSave, "Center");
        panel.add((Component)this.btnReload, "West");
        int size = 12;
        if (GDStashFrame.iniConfig != null) {
            size = GDStashFrame.iniConfig.sectUI.fontSize;
        }
        Dimension dimMax = new Dimension(50 * size, 2 * size);
        panel.setPreferredSize(dimMax);
        panel.setMaximumSize(dimMax);
        return panel;
    }

    private JPanel buildRightSidePanel() {
        JPanel panel = new JPanel();
        JPanel pnlEdit = this.buildEditPanel();
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(this.pnlRiftShrines).addComponent(this.pnlAchieve));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(this.pnlRiftShrines)).addGroup(layout.createParallelGroup().addComponent(this.pnlAchieve));
        layout.setVerticalGroup(vGroup);
        layout.linkSize(0, this.pnlRiftShrines, this.pnlAchieve);
        return panel;
    }

    private JPanel buildEditPanel() {
        JPanel panel = new JPanel();
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(this.cbSelChar).addComponent(this.pnlEdit));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(this.cbSelChar)).addGroup(layout.createParallelGroup().addComponent(this.pnlEdit));
        layout.setVerticalGroup(vGroup);
        layout.linkSize(0, this.cbSelChar, this.pnlEdit);
        return panel;
    }

    private JPanel buildFactDevoPanel() {
        JPanel panel = new JPanel();
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(this.pnlFactions)).addGroup(layout.createParallelGroup().addComponent(this.pnlDevotions));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(this.pnlFactions).addComponent(this.pnlDevotions));
        layout.setVerticalGroup(vGroup);
        layout.linkSize(1, this.pnlFactions, this.pnlDevotions);
        return panel;
    }

    public void initCharSelection() {
        this.cbSelChar.removeAllItems();
        this.cbSelChar.addItem("");
        for (GDCharInfoList.GDCharFileInfo info : GDCharInfoList.gdCharFileInfos) {
            this.cbSelChar.addItem(info.charInfo);
        }
    }

    public void refreshCharSelection() {
        File file = null;
        if (this.info != null) {
            file = this.info.charFile;
        }
        this.cbSelChar.removeAllItems();
        this.cbSelChar.addItem("");
        GDCharInfoList.GDCharFileInfo selInfo = null;
        int idx = -1;
        int i = 1;
        for (GDCharInfoList.GDCharFileInfo info : GDCharInfoList.gdCharFileInfos) {
            this.cbSelChar.addItem(info.charInfo);
            if (info.charFile.equals(file)) {
                selInfo = info;
                idx = i;
            }
            ++i;
        }
        if (idx == -1) {
            this.setChar(null);
        } else {
            this.cbSelChar.setSelectedIndex(idx);
        }
    }

    public void refreshCharInfo(GDCharInfoList.GDCharFileInfo info) {
        if (info == null) {
            return;
        }
        if (this.info == null) {
            return;
        }
        if (this.info.fileName.equals(info.fileName)) {
            this.info = info;
            this.setChar(info);
        }
    }

    public void setChar(GDCharInfoList.GDCharFileInfo info) {
        this.info = info;
        if (info == null) {
            this.pnlEdit.setChar(null);
            this.pnlFactions.setChar(null);
            this.pnlDevotions.setChar(null);
            this.pnlRiftShrines.setChar(null);
            this.pnlAchieve.setChar(null);
        } else {
            this.pnlEdit.setChar(info.gdChar);
            this.pnlFactions.setChar(info.gdChar);
            this.pnlDevotions.setChar(info.gdChar);
            this.pnlRiftShrines.setChar(info.gdChar);
            this.pnlAchieve.setChar(info.gdChar);
        }
    }

    public void updateChar() {
        if (this.info == null) {
            return;
        }
        if (this.info.gdChar == null) {
            return;
        }
        this.pnlEdit.updateChar(this.info.gdChar);
        this.pnlFactions.updateChar(this.info.gdChar);
        this.pnlDevotions.updateChar(this.info.gdChar);
        this.pnlRiftShrines.updateChar(this.info.gdChar);
        this.pnlAchieve.updateChar(this.info.gdChar);
    }

    private class FileSaveActionListener
    implements ActionListener {
        private FileSaveActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            if (GDCharEditPane.this.info == null) {
                return;
            }
            if (((GDCharEditPane)GDCharEditPane.this).info.charFile == null) {
                return;
            }
            if (((GDCharEditPane)GDCharEditPane.this).info.gdChar == null) {
                return;
            }
            String origName = ((GDCharEditPane)GDCharEditPane.this).info.gdChar.getCharName();
            String newName = GDCharEditPane.this.pnlEdit.getCharName();
            if (origName != null && newName != null && !origName.equals(newName)) {
                try {
                    File fDirOrig = ((GDCharEditPane)GDCharEditPane.this).info.charFile.getParentFile();
                    String dirOrig = fDirOrig.getCanonicalPath();
                    int pos = dirOrig.lastIndexOf(GDConstants.FILE_SEPARATOR);
                    if (pos != -1) {
                        String name = dirOrig.substring(pos + 2);
                        String dirNew = dirOrig.substring(0, pos + 1);
                        File fDirNew = new File(dirNew = dirNew + "_" + newName);
                        if (fDirNew.exists()) {
                            GDLogoDialog dialog = new GDLogoDialog(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERR_CHAR_EXISTS"), 4, GDCharEditPane.this.frame);
                            dialog.setVisible(true);
                            return;
                        }
                    }
                }
                catch (IOException ex) {
                    GDMsgLogger.addError(ex);
                }
            }
            GDCharEditPane.this.updateChar();
            boolean success = false;
            try {
                File fDirOrig;
                String dirOrig;
                int pos;
                ((GDCharEditPane)GDCharEditPane.this).info.gdChar.write();
                String charName = ((GDCharEditPane)GDCharEditPane.this).info.gdChar.getCharName();
                if (charName != null && !charName.isEmpty() && (pos = (dirOrig = (fDirOrig = ((GDCharEditPane)GDCharEditPane.this).info.charFile.getParentFile()).getCanonicalPath()).lastIndexOf(GDConstants.FILE_SEPARATOR)) != -1) {
                    String name = dirOrig.substring(pos + 2);
                    String dirNew = dirOrig.substring(0, pos + 1);
                    if (!name.equals(charName)) {
                        dirNew = dirNew + "_" + charName;
                        File fDirNew = new File(dirNew);
                        fDirOrig.renameTo(fDirNew);
                        GDStashFrame.renameCharDir(fDirOrig, fDirNew, GDCharEditPane.this.frame);
                    }
                }
                success = true;
            }
            catch (IOException ex) {
                GDMsgLogger.addError(ex);
            }
            GDMsgLogger.showLog(GDCharEditPane.this.frame, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "SUCC_CHAR_SAVE"), 0, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERR_CHAR_SAVE"), true);
        }
    }

    private class CharSelectActionListener
    implements ActionListener {
        private CharSelectActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            int idx = GDCharEditPane.this.cbSelChar.getSelectedIndex();
            if (idx == -1) {
                return;
            }
            if (idx == 0) {
                GDCharEditPane.this.setChar(null);
                return;
            }
            int i = 1;
            for (GDCharInfoList.GDCharFileInfo info : GDCharInfoList.gdCharFileInfos) {
                if (i == idx) {
                    if (info.gdChar == null) {
                        info.gdChar = new GDChar(info.charFile);
                        info.gdChar.read();
                    }
                    if (info.gdChar.hasErrors()) {
                        info.gdChar = null;
                    }
                    if (info.gdChar != null) {
                        info.gdChar.getMasteryInfo();
                    }
                    GDCharEditPane.this.setChar(info);
                    break;
                }
                ++i;
            }
            GDMsgLogger.showLog(GDCharEditPane.this, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERRORS"));
        }
    }

    private class ReloadActionListener
    implements ActionListener {
        private ReloadActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            GDCharInfoList.findChars(GDCharEditPane.this.frame, GDCharEditPane.this.info);
            if (GDCharEditPane.this.info != null) {
                for (GDCharInfoList.GDCharFileInfo ci : GDCharInfoList.gdCharFileInfos) {
                    if (!ci.fileName.equals(((GDCharEditPane)GDCharEditPane.this).info.fileName)) continue;
                    GDCharEditPane.this.info = ci;
                    break;
                }
            }
            if (((GDCharEditPane)GDCharEditPane.this).frame.pnlCharInventory != null) {
                ((GDCharEditPane)GDCharEditPane.this).frame.pnlCharInventory.refreshCharInfo(GDCharEditPane.this.info);
            }
            if (((GDCharEditPane)GDCharEditPane.this).frame.pnlCharEdit != null) {
                ((GDCharEditPane)GDCharEditPane.this).frame.pnlCharEdit.refreshCharInfo(GDCharEditPane.this.info);
            }
            GDMsgLogger.showLog(GDCharEditPane.this, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERRORS"));
        }
    }
}

