/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.ui.character;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import org.gdstash.character.GDChar;
import org.gdstash.character.GDCharTeleportList;
import org.gdstash.character.GDCharUID;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.ui.util.AdjustablePanel;
import org.gdstash.util.GDMsgFormatter;

public class GDCharRiftAct1Pane
extends AdjustablePanel {
    private JCheckBox cbDevilsCrossing;
    private JCheckBox cbLowerCrossing;
    private JCheckBox cbWightmire;
    private JCheckBox cbFoggyBank;
    private JCheckBox cbFloodedPassage;
    private JCheckBox cbBurrwitchOutskirts;
    private JCheckBox cbBurrwitchVillage;
    private JCheckBox cbWardensCellar;
    private JCheckBox cbUndergroundTransit;
    private JCheckBox cbWardensLaboratory;
    private int difficulty;
    private boolean changed;

    public GDCharRiftAct1Pane(int difficulty, int direction) {
        this.difficulty = difficulty;
        this.changed = false;
        this.adjustUI();
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(this.cbDevilsCrossing).addComponent(this.cbLowerCrossing).addComponent(this.cbWightmire).addComponent(this.cbFoggyBank).addComponent(this.cbFloodedPassage).addComponent(this.cbBurrwitchOutskirts).addComponent(this.cbBurrwitchVillage).addComponent(this.cbWardensCellar).addComponent(this.cbUndergroundTransit).addComponent(this.cbWardensLaboratory));
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(this.cbDevilsCrossing)).addGroup(layout.createParallelGroup().addComponent(this.cbLowerCrossing)).addGroup(layout.createParallelGroup().addComponent(this.cbWightmire)).addGroup(layout.createParallelGroup().addComponent(this.cbFoggyBank)).addGroup(layout.createParallelGroup().addComponent(this.cbFloodedPassage)).addGroup(layout.createParallelGroup().addComponent(this.cbBurrwitchOutskirts)).addGroup(layout.createParallelGroup().addComponent(this.cbBurrwitchVillage)).addGroup(layout.createParallelGroup().addComponent(this.cbWardensCellar)).addGroup(layout.createParallelGroup().addComponent(this.cbUndergroundTransit)).addGroup(layout.createParallelGroup().addComponent(this.cbWardensLaboratory));
        if (direction == 0) {
            layout.setHorizontalGroup(vGroup);
            layout.setVerticalGroup(hGroup);
        } else {
            layout.setHorizontalGroup(hGroup);
            layout.setVerticalGroup(vGroup);
        }
        layout.linkSize(0, this.cbDevilsCrossing, this.cbLowerCrossing);
        layout.linkSize(0, this.cbDevilsCrossing, this.cbWightmire);
        layout.linkSize(0, this.cbDevilsCrossing, this.cbFoggyBank);
        layout.linkSize(0, this.cbDevilsCrossing, this.cbFloodedPassage);
        layout.linkSize(0, this.cbDevilsCrossing, this.cbBurrwitchOutskirts);
        layout.linkSize(0, this.cbDevilsCrossing, this.cbBurrwitchVillage);
        layout.linkSize(0, this.cbDevilsCrossing, this.cbWardensCellar);
        layout.linkSize(0, this.cbDevilsCrossing, this.cbUndergroundTransit);
        layout.linkSize(0, this.cbDevilsCrossing, this.cbWardensLaboratory);
        layout.linkSize(1, this.cbDevilsCrossing, this.cbLowerCrossing);
        layout.linkSize(1, this.cbDevilsCrossing, this.cbWightmire);
        layout.linkSize(1, this.cbDevilsCrossing, this.cbFoggyBank);
        layout.linkSize(1, this.cbDevilsCrossing, this.cbFloodedPassage);
        layout.linkSize(1, this.cbDevilsCrossing, this.cbBurrwitchOutskirts);
        layout.linkSize(1, this.cbDevilsCrossing, this.cbBurrwitchVillage);
        layout.linkSize(1, this.cbDevilsCrossing, this.cbWardensCellar);
        layout.linkSize(1, this.cbDevilsCrossing, this.cbUndergroundTransit);
        layout.linkSize(1, this.cbDevilsCrossing, this.cbWardensLaboratory);
    }

    @Override
    public void adjustUI() {
        Font fntBorder;
        Font fntLabel = UIManager.getDefaults().getFont("Label.font");
        Font fntCheck = UIManager.getDefaults().getFont("CheckBox.font");
        if (fntCheck == null) {
            fntCheck = fntLabel;
        }
        if ((fntBorder = UIManager.getDefaults().getFont("TitledBorder.font")) == null) {
            fntBorder = fntLabel;
        }
        fntLabel = fntLabel.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntCheck = fntCheck.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntBorder = fntBorder.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        Border lowered = BorderFactory.createEtchedBorder(1);
        Border raised = BorderFactory.createEtchedBorder(0);
        CompoundBorder compound = BorderFactory.createCompoundBorder(raised, lowered);
        TitledBorder text = BorderFactory.createTitledBorder(compound, GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_RIFT_ACT1"));
        text.setTitleFont(fntBorder);
        this.setBorder(text);
        if (this.cbDevilsCrossing == null) {
            this.cbDevilsCrossing = new JCheckBox();
            this.cbDevilsCrossing.addActionListener(new ChangeActionListener());
        }
        this.cbDevilsCrossing.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_RIFT_01_DEVILS_CROSSING"));
        this.cbDevilsCrossing.setFont(fntCheck);
        if (this.cbLowerCrossing == null) {
            this.cbLowerCrossing = new JCheckBox();
            this.cbLowerCrossing.addActionListener(new ChangeActionListener());
        }
        this.cbLowerCrossing.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_RIFT_01_LOWER_CROSSING"));
        this.cbLowerCrossing.setFont(fntCheck);
        if (this.cbWightmire == null) {
            this.cbWightmire = new JCheckBox();
            this.cbWightmire.addActionListener(new ChangeActionListener());
        }
        this.cbWightmire.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_RIFT_01_WIGHTMIRE"));
        this.cbWightmire.setFont(fntCheck);
        if (this.cbFoggyBank == null) {
            this.cbFoggyBank = new JCheckBox();
            this.cbFoggyBank.addActionListener(new ChangeActionListener());
        }
        this.cbFoggyBank.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_RIFT_01_FOGGY_BANK"));
        this.cbFoggyBank.setFont(fntCheck);
        if (this.cbFloodedPassage == null) {
            this.cbFloodedPassage = new JCheckBox();
            this.cbFloodedPassage.addActionListener(new ChangeActionListener());
        }
        this.cbFloodedPassage.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_RIFT_01_FLOODED_PASSAGE"));
        this.cbFloodedPassage.setFont(fntCheck);
        if (this.cbBurrwitchOutskirts == null) {
            this.cbBurrwitchOutskirts = new JCheckBox();
            this.cbBurrwitchOutskirts.addActionListener(new ChangeActionListener());
        }
        this.cbBurrwitchOutskirts.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_RIFT_01_BURRWITCH_OUTSKIRTS"));
        this.cbBurrwitchOutskirts.setFont(fntCheck);
        if (this.cbBurrwitchVillage == null) {
            this.cbBurrwitchVillage = new JCheckBox();
            this.cbBurrwitchVillage.addActionListener(new ChangeActionListener());
        }
        this.cbBurrwitchVillage.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_RIFT_01_BURRWITCH_VILLAGE"));
        this.cbBurrwitchVillage.setFont(fntCheck);
        if (this.cbWardensCellar == null) {
            this.cbWardensCellar = new JCheckBox();
            this.cbWardensCellar.addActionListener(new ChangeActionListener());
        }
        this.cbWardensCellar.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_RIFT_01_WARDENS_CELLAR"));
        this.cbWardensCellar.setFont(fntCheck);
        if (this.cbUndergroundTransit == null) {
            this.cbUndergroundTransit = new JCheckBox();
            this.cbUndergroundTransit.addActionListener(new ChangeActionListener());
        }
        this.cbUndergroundTransit.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_RIFT_01_UNDERGROUND_TRANSIT"));
        this.cbUndergroundTransit.setFont(fntCheck);
        if (this.cbWardensLaboratory == null) {
            this.cbWardensLaboratory = new JCheckBox();
            this.cbWardensLaboratory.addActionListener(new ChangeActionListener());
        }
        this.cbWardensLaboratory.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_RIFT_01_WARDENS_LABORATORY"));
        this.cbWardensLaboratory.setFont(fntCheck);
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    public void setSelectged(boolean selected) {
        this.cbDevilsCrossing.setSelected(selected);
        this.cbLowerCrossing.setSelected(selected);
        this.cbWightmire.setSelected(selected);
        this.cbFoggyBank.setSelected(selected);
        this.cbFloodedPassage.setSelected(selected);
        this.cbBurrwitchOutskirts.setSelected(selected);
        this.cbBurrwitchVillage.setSelected(selected);
        this.cbWardensCellar.setSelected(selected);
        this.cbUndergroundTransit.setSelected(selected);
        this.cbWardensLaboratory.setSelected(selected);
    }

    public List<GDCharUID> getRiftList() {
        LinkedList<GDCharUID> list = new LinkedList<GDCharUID>();
        if (this.cbDevilsCrossing.isSelected()) {
            list.add(GDCharTeleportList.UID_RIFT_01_DEVILS_CROSSING);
        }
        if (this.cbLowerCrossing.isSelected()) {
            list.add(GDCharTeleportList.UID_RIFT_01_LOWER_CROSSING);
        }
        if (this.cbWightmire.isSelected()) {
            list.add(GDCharTeleportList.UID_RIFT_01_WIGHTMIRE);
        }
        if (this.cbFoggyBank.isSelected()) {
            list.add(GDCharTeleportList.UID_RIFT_01_FOGGY_BANK);
        }
        if (this.cbFloodedPassage.isSelected()) {
            list.add(GDCharTeleportList.UID_RIFT_01_FLOODED_PASSAGE);
        }
        if (this.cbBurrwitchOutskirts.isSelected()) {
            list.add(GDCharTeleportList.UID_RIFT_01_BURRWITCH_OUTSKIRTS);
        }
        if (this.cbBurrwitchVillage.isSelected()) {
            list.add(GDCharTeleportList.UID_RIFT_01_BURRWITCH_VILLAGE);
        }
        if (this.cbWardensCellar.isSelected()) {
            list.add(GDCharTeleportList.UID_RIFT_01_WARDENS_CELLAR);
        }
        if (this.cbUndergroundTransit.isSelected()) {
            list.add(GDCharTeleportList.UID_RIFT_01_UNDERGROUND_TRANSIT);
        }
        if (this.cbWardensLaboratory.isSelected()) {
            list.add(GDCharTeleportList.UID_RIFT_01_WARDENS_LABORATORY);
        }
        return list;
    }

    public void setChar(GDChar gdc) {
        this.setSelectged(false);
        this.changed = false;
        if (gdc == null) {
            return;
        }
        List<GDCharUID> list = gdc.getRiftList(this.difficulty);
        for (GDCharUID uid : list) {
            if (uid.equals(GDCharTeleportList.UID_RIFT_01_DEVILS_CROSSING)) {
                this.cbDevilsCrossing.setSelected(true);
            }
            if (uid.equals(GDCharTeleportList.UID_RIFT_01_LOWER_CROSSING)) {
                this.cbLowerCrossing.setSelected(true);
            }
            if (uid.equals(GDCharTeleportList.UID_RIFT_01_WIGHTMIRE)) {
                this.cbWightmire.setSelected(true);
            }
            if (uid.equals(GDCharTeleportList.UID_RIFT_01_FOGGY_BANK)) {
                this.cbFoggyBank.setSelected(true);
            }
            if (uid.equals(GDCharTeleportList.UID_RIFT_01_FLOODED_PASSAGE)) {
                this.cbFloodedPassage.setSelected(true);
            }
            if (uid.equals(GDCharTeleportList.UID_RIFT_01_BURRWITCH_OUTSKIRTS)) {
                this.cbBurrwitchOutskirts.setSelected(true);
            }
            if (uid.equals(GDCharTeleportList.UID_RIFT_01_BURRWITCH_VILLAGE)) {
                this.cbBurrwitchVillage.setSelected(true);
            }
            if (uid.equals(GDCharTeleportList.UID_RIFT_01_WARDENS_CELLAR)) {
                this.cbWardensCellar.setSelected(true);
            }
            if (uid.equals(GDCharTeleportList.UID_RIFT_01_UNDERGROUND_TRANSIT)) {
                this.cbUndergroundTransit.setSelected(true);
            }
            if (!uid.equals(GDCharTeleportList.UID_RIFT_01_WARDENS_LABORATORY)) continue;
            this.cbWardensLaboratory.setSelected(true);
        }
    }

    private class ChangeActionListener
    implements ActionListener {
        private ChangeActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GDCharRiftAct1Pane.this.changed = true;
        }
    }
}

