/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.ui.character;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import org.gdstash.character.GDChar;
import org.gdstash.character.GDCharTeleportList;
import org.gdstash.character.GDCharUID;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.ui.util.AdjustablePanel;
import org.gdstash.util.GDMsgFormatter;

public class GDCharRiftAct2Pane
extends AdjustablePanel {
    private JCheckBox cbArkovianFoothills;
    private JCheckBox cbOldArkovia;
    private JCheckBox cbCronleysHideout;
    private JCheckBox cbTwinFalls;
    private JCheckBox cbBrokenHills;
    private JCheckBox cbSmugglersPass;
    private int difficulty;
    private boolean changed;

    public GDCharRiftAct2Pane(int difficulty, int direction) {
        this.difficulty = difficulty;
        this.changed = false;
        this.adjustUI();
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(this.cbArkovianFoothills).addComponent(this.cbOldArkovia).addComponent(this.cbCronleysHideout).addComponent(this.cbTwinFalls).addComponent(this.cbBrokenHills).addComponent(this.cbSmugglersPass));
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(this.cbArkovianFoothills)).addGroup(layout.createParallelGroup().addComponent(this.cbOldArkovia)).addGroup(layout.createParallelGroup().addComponent(this.cbCronleysHideout)).addGroup(layout.createParallelGroup().addComponent(this.cbTwinFalls)).addGroup(layout.createParallelGroup().addComponent(this.cbBrokenHills)).addGroup(layout.createParallelGroup().addComponent(this.cbSmugglersPass));
        if (direction == 0) {
            layout.setHorizontalGroup(vGroup);
            layout.setVerticalGroup(hGroup);
        } else {
            layout.setHorizontalGroup(hGroup);
            layout.setVerticalGroup(vGroup);
        }
        layout.linkSize(0, this.cbArkovianFoothills, this.cbOldArkovia);
        layout.linkSize(0, this.cbArkovianFoothills, this.cbCronleysHideout);
        layout.linkSize(0, this.cbArkovianFoothills, this.cbTwinFalls);
        layout.linkSize(0, this.cbArkovianFoothills, this.cbBrokenHills);
        layout.linkSize(0, this.cbArkovianFoothills, this.cbSmugglersPass);
        layout.linkSize(1, this.cbArkovianFoothills, this.cbOldArkovia);
        layout.linkSize(1, this.cbArkovianFoothills, this.cbCronleysHideout);
        layout.linkSize(1, this.cbArkovianFoothills, this.cbTwinFalls);
        layout.linkSize(1, this.cbArkovianFoothills, this.cbBrokenHills);
        layout.linkSize(1, this.cbArkovianFoothills, this.cbSmugglersPass);
    }

    @Override
    public void adjustUI() {
        Font fntBorder;
        Font fntLabel = UIManager.getDefaults().getFont("Label.font");
        Font fntCheck = UIManager.getDefaults().getFont("CheckBox.font");
        if (fntCheck == null) {
            fntCheck = fntLabel;
        }
        if ((fntBorder = UIManager.getDefaults().getFont("TitledBorder.font")) == null) {
            fntBorder = fntLabel;
        }
        fntLabel = fntLabel.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntCheck = fntCheck.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntBorder = fntBorder.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        Border lowered = BorderFactory.createEtchedBorder(1);
        Border raised = BorderFactory.createEtchedBorder(0);
        CompoundBorder compound = BorderFactory.createCompoundBorder(raised, lowered);
        TitledBorder text = BorderFactory.createTitledBorder(compound, GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_RIFT_ACT2"));
        text.setTitleFont(fntBorder);
        this.setBorder(text);
        if (this.cbArkovianFoothills == null) {
            this.cbArkovianFoothills = new JCheckBox();
            this.cbArkovianFoothills.addActionListener(new ChangeActionListener());
        }
        this.cbArkovianFoothills.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_RIFT_02_ARKOVIAN_FOOTHILLS"));
        this.cbArkovianFoothills.setFont(fntCheck);
        if (this.cbOldArkovia == null) {
            this.cbOldArkovia = new JCheckBox();
            this.cbOldArkovia.addActionListener(new ChangeActionListener());
        }
        this.cbOldArkovia.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_RIFT_02_OLD_ARKOVIA"));
        this.cbOldArkovia.setFont(fntCheck);
        if (this.cbCronleysHideout == null) {
            this.cbCronleysHideout = new JCheckBox();
            this.cbCronleysHideout.addActionListener(new ChangeActionListener());
        }
        this.cbCronleysHideout.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_RIFT_02_CRONLEYS_HIDEOUT"));
        this.cbCronleysHideout.setFont(fntCheck);
        if (this.cbTwinFalls == null) {
            this.cbTwinFalls = new JCheckBox();
            this.cbTwinFalls.addActionListener(new ChangeActionListener());
        }
        this.cbTwinFalls.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_RIFT_02_TWIN_FALLS"));
        this.cbTwinFalls.setFont(fntCheck);
        if (this.cbBrokenHills == null) {
            this.cbBrokenHills = new JCheckBox();
            this.cbBrokenHills.addActionListener(new ChangeActionListener());
        }
        this.cbBrokenHills.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_RIFT_02_BROKEN_HILLS"));
        this.cbBrokenHills.setFont(fntCheck);
        if (this.cbSmugglersPass == null) {
            this.cbSmugglersPass = new JCheckBox();
            this.cbSmugglersPass.addActionListener(new ChangeActionListener());
        }
        this.cbSmugglersPass.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_RIFT_02_SMUGGLERS_PASS"));
        this.cbSmugglersPass.setFont(fntCheck);
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    public void setSelectged(boolean selected) {
        this.cbArkovianFoothills.setSelected(selected);
        this.cbOldArkovia.setSelected(selected);
        this.cbCronleysHideout.setSelected(selected);
        this.cbTwinFalls.setSelected(selected);
        this.cbBrokenHills.setSelected(selected);
        this.cbSmugglersPass.setSelected(selected);
    }

    public List<GDCharUID> getRiftList() {
        LinkedList<GDCharUID> list = new LinkedList<GDCharUID>();
        if (this.cbArkovianFoothills.isSelected()) {
            list.add(GDCharTeleportList.UID_RIFT_02_ARKOVIAN_FOOTHILLS);
        }
        if (this.cbOldArkovia.isSelected()) {
            list.add(GDCharTeleportList.UID_RIFT_02_OLD_ARKOVIA);
        }
        if (this.cbCronleysHideout.isSelected()) {
            list.add(GDCharTeleportList.UID_RIFT_02_CRONLEYS_HIDEOUT);
        }
        if (this.cbTwinFalls.isSelected()) {
            list.add(GDCharTeleportList.UID_RIFT_02_TWIN_FALLS);
        }
        if (this.cbBrokenHills.isSelected()) {
            list.add(GDCharTeleportList.UID_RIFT_02_BROKEN_HILLS);
        }
        if (this.cbSmugglersPass.isSelected()) {
            list.add(GDCharTeleportList.UID_RIFT_02_SMUGGLERS_PASS);
        }
        return list;
    }

    public void setChar(GDChar gdc) {
        this.setSelectged(false);
        this.changed = false;
        if (gdc == null) {
            return;
        }
        List<GDCharUID> list = gdc.getRiftList(this.difficulty);
        for (GDCharUID uid : list) {
            if (uid.equals(GDCharTeleportList.UID_RIFT_02_ARKOVIAN_FOOTHILLS)) {
                this.cbArkovianFoothills.setSelected(true);
            }
            if (uid.equals(GDCharTeleportList.UID_RIFT_02_OLD_ARKOVIA)) {
                this.cbOldArkovia.setSelected(true);
            }
            if (uid.equals(GDCharTeleportList.UID_RIFT_02_CRONLEYS_HIDEOUT)) {
                this.cbCronleysHideout.setSelected(true);
            }
            if (uid.equals(GDCharTeleportList.UID_RIFT_02_TWIN_FALLS)) {
                this.cbTwinFalls.setSelected(true);
            }
            if (uid.equals(GDCharTeleportList.UID_RIFT_02_BROKEN_HILLS)) {
                this.cbBrokenHills.setSelected(true);
            }
            if (!uid.equals(GDCharTeleportList.UID_RIFT_02_SMUGGLERS_PASS)) continue;
            this.cbSmugglersPass.setSelected(true);
        }
    }

    private class ChangeActionListener
    implements ActionListener {
        private ChangeActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GDCharRiftAct2Pane.this.changed = true;
        }
    }
}

