/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.ui.character;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import org.gdstash.character.GDChar;
import org.gdstash.character.GDCharTeleportList;
import org.gdstash.character.GDCharUID;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.ui.util.AdjustablePanel;
import org.gdstash.util.GDMsgFormatter;

public class GDCharRiftAct3Pane
extends AdjustablePanel {
    private JCheckBox cbDeadmansGulch;
    private JCheckBox cbProspectorsTrail;
    private JCheckBox cbPineBarrens;
    private JCheckBox cbHomestead;
    private JCheckBox cbRottingCropland;
    private JCheckBox cbSorrowsBastion;
    private JCheckBox cbBloodGrove;
    private JCheckBox cbDarkvaleGate;
    private int difficulty;
    private boolean changed;

    public GDCharRiftAct3Pane(int difficulty, int direction) {
        this.difficulty = difficulty;
        this.changed = false;
        this.adjustUI();
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(this.cbDeadmansGulch).addComponent(this.cbProspectorsTrail).addComponent(this.cbPineBarrens).addComponent(this.cbHomestead).addComponent(this.cbRottingCropland).addComponent(this.cbSorrowsBastion).addComponent(this.cbBloodGrove).addComponent(this.cbDarkvaleGate));
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(this.cbDeadmansGulch)).addGroup(layout.createParallelGroup().addComponent(this.cbProspectorsTrail)).addGroup(layout.createParallelGroup().addComponent(this.cbPineBarrens)).addGroup(layout.createParallelGroup().addComponent(this.cbHomestead)).addGroup(layout.createParallelGroup().addComponent(this.cbRottingCropland)).addGroup(layout.createParallelGroup().addComponent(this.cbSorrowsBastion)).addGroup(layout.createParallelGroup().addComponent(this.cbBloodGrove)).addGroup(layout.createParallelGroup().addComponent(this.cbDarkvaleGate));
        if (direction == 0) {
            layout.setHorizontalGroup(vGroup);
            layout.setVerticalGroup(hGroup);
        } else {
            layout.setHorizontalGroup(hGroup);
            layout.setVerticalGroup(vGroup);
        }
        layout.linkSize(0, this.cbDeadmansGulch, this.cbProspectorsTrail);
        layout.linkSize(0, this.cbDeadmansGulch, this.cbPineBarrens);
        layout.linkSize(0, this.cbDeadmansGulch, this.cbHomestead);
        layout.linkSize(0, this.cbDeadmansGulch, this.cbRottingCropland);
        layout.linkSize(0, this.cbDeadmansGulch, this.cbSorrowsBastion);
        layout.linkSize(0, this.cbDeadmansGulch, this.cbBloodGrove);
        layout.linkSize(0, this.cbDeadmansGulch, this.cbDarkvaleGate);
        layout.linkSize(1, this.cbDeadmansGulch, this.cbProspectorsTrail);
        layout.linkSize(1, this.cbDeadmansGulch, this.cbPineBarrens);
        layout.linkSize(1, this.cbDeadmansGulch, this.cbHomestead);
        layout.linkSize(1, this.cbDeadmansGulch, this.cbRottingCropland);
        layout.linkSize(1, this.cbDeadmansGulch, this.cbSorrowsBastion);
        layout.linkSize(1, this.cbDeadmansGulch, this.cbBloodGrove);
        layout.linkSize(1, this.cbDeadmansGulch, this.cbDarkvaleGate);
    }

    @Override
    public void adjustUI() {
        Font fntBorder;
        Font fntLabel = UIManager.getDefaults().getFont("Label.font");
        Font fntCheck = UIManager.getDefaults().getFont("CheckBox.font");
        if (fntCheck == null) {
            fntCheck = fntLabel;
        }
        if ((fntBorder = UIManager.getDefaults().getFont("TitledBorder.font")) == null) {
            fntBorder = fntLabel;
        }
        fntLabel = fntLabel.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntCheck = fntCheck.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntBorder = fntBorder.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        Border lowered = BorderFactory.createEtchedBorder(1);
        Border raised = BorderFactory.createEtchedBorder(0);
        CompoundBorder compound = BorderFactory.createCompoundBorder(raised, lowered);
        TitledBorder text = BorderFactory.createTitledBorder(compound, GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_RIFT_ACT3"));
        text.setTitleFont(fntBorder);
        this.setBorder(text);
        if (this.cbDeadmansGulch == null) {
            this.cbDeadmansGulch = new JCheckBox();
            this.cbDeadmansGulch.addActionListener(new ChangeActionListener());
        }
        this.cbDeadmansGulch.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_RIFT_03_DEADMANS_GULCH"));
        this.cbDeadmansGulch.setFont(fntCheck);
        if (this.cbProspectorsTrail == null) {
            this.cbProspectorsTrail = new JCheckBox();
            this.cbProspectorsTrail.addActionListener(new ChangeActionListener());
        }
        this.cbProspectorsTrail.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_RIFT_03_PROSPECTORS_TRAIL"));
        this.cbProspectorsTrail.setFont(fntCheck);
        if (this.cbPineBarrens == null) {
            this.cbPineBarrens = new JCheckBox();
            this.cbPineBarrens.addActionListener(new ChangeActionListener());
        }
        this.cbPineBarrens.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_RIFT_03_PINE_BARRENS"));
        this.cbPineBarrens.setFont(fntCheck);
        if (this.cbHomestead == null) {
            this.cbHomestead = new JCheckBox();
            this.cbHomestead.addActionListener(new ChangeActionListener());
        }
        this.cbHomestead.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_RIFT_03_HOMESTEAD"));
        this.cbHomestead.setFont(fntCheck);
        if (this.cbRottingCropland == null) {
            this.cbRottingCropland = new JCheckBox();
            this.cbRottingCropland.addActionListener(new ChangeActionListener());
        }
        this.cbRottingCropland.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_RIFT_03_ROTTING_CROPLANDS"));
        this.cbRottingCropland.setFont(fntCheck);
        if (this.cbSorrowsBastion == null) {
            this.cbSorrowsBastion = new JCheckBox();
            this.cbSorrowsBastion.addActionListener(new ChangeActionListener());
        }
        this.cbSorrowsBastion.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_RIFT_03_SORROWS_BASTION"));
        this.cbSorrowsBastion.setFont(fntCheck);
        if (this.cbBloodGrove == null) {
            this.cbBloodGrove = new JCheckBox();
            this.cbBloodGrove.addActionListener(new ChangeActionListener());
        }
        this.cbBloodGrove.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_RIFT_03_BLOOD_GROVE"));
        this.cbBloodGrove.setFont(fntCheck);
        if (this.cbDarkvaleGate == null) {
            this.cbDarkvaleGate = new JCheckBox();
            this.cbDarkvaleGate.addActionListener(new ChangeActionListener());
        }
        this.cbDarkvaleGate.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_RIFT_03_DARKVALE_GATE"));
        this.cbDarkvaleGate.setFont(fntCheck);
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    public void setSelectged(boolean selected) {
        this.cbDeadmansGulch.setSelected(selected);
        this.cbProspectorsTrail.setSelected(selected);
        this.cbPineBarrens.setSelected(selected);
        this.cbHomestead.setSelected(selected);
        this.cbRottingCropland.setSelected(selected);
        this.cbSorrowsBastion.setSelected(selected);
        this.cbBloodGrove.setSelected(selected);
        this.cbDarkvaleGate.setSelected(selected);
    }

    public List<GDCharUID> getRiftList() {
        LinkedList<GDCharUID> list = new LinkedList<GDCharUID>();
        if (this.cbDeadmansGulch.isSelected()) {
            list.add(GDCharTeleportList.UID_RIFT_03_DEADMANS_GULCH);
        }
        if (this.cbProspectorsTrail.isSelected()) {
            list.add(GDCharTeleportList.UID_RIFT_03_PROSPECTORS_TRAIL);
        }
        if (this.cbPineBarrens.isSelected()) {
            list.add(GDCharTeleportList.UID_RIFT_03_PINE_BARRENS);
        }
        if (this.cbHomestead.isSelected()) {
            list.add(GDCharTeleportList.UID_RIFT_03_HOMESTEAD);
        }
        if (this.cbRottingCropland.isSelected()) {
            list.add(GDCharTeleportList.UID_RIFT_03_ROTTING_CROPLANDS);
        }
        if (this.cbSorrowsBastion.isSelected()) {
            list.add(GDCharTeleportList.UID_RIFT_03_SORROWS_BASTION);
        }
        if (this.cbBloodGrove.isSelected()) {
            list.add(GDCharTeleportList.UID_RIFT_03_BLOOD_GROVE);
        }
        if (this.cbDarkvaleGate.isSelected()) {
            list.add(GDCharTeleportList.UID_RIFT_03_DARKVALE_GATE);
        }
        return list;
    }

    public void setChar(GDChar gdc) {
        this.setSelectged(false);
        this.changed = false;
        if (gdc == null) {
            return;
        }
        List<GDCharUID> list = gdc.getRiftList(this.difficulty);
        for (GDCharUID uid : list) {
            if (uid.equals(GDCharTeleportList.UID_RIFT_03_DEADMANS_GULCH)) {
                this.cbDeadmansGulch.setSelected(true);
            }
            if (uid.equals(GDCharTeleportList.UID_RIFT_03_PROSPECTORS_TRAIL)) {
                this.cbProspectorsTrail.setSelected(true);
            }
            if (uid.equals(GDCharTeleportList.UID_RIFT_03_PINE_BARRENS)) {
                this.cbPineBarrens.setSelected(true);
            }
            if (uid.equals(GDCharTeleportList.UID_RIFT_03_HOMESTEAD)) {
                this.cbHomestead.setSelected(true);
            }
            if (uid.equals(GDCharTeleportList.UID_RIFT_03_ROTTING_CROPLANDS)) {
                this.cbRottingCropland.setSelected(true);
            }
            if (uid.equals(GDCharTeleportList.UID_RIFT_03_SORROWS_BASTION)) {
                this.cbSorrowsBastion.setSelected(true);
            }
            if (uid.equals(GDCharTeleportList.UID_RIFT_03_BLOOD_GROVE)) {
                this.cbBloodGrove.setSelected(true);
            }
            if (!uid.equals(GDCharTeleportList.UID_RIFT_03_DARKVALE_GATE)) continue;
            this.cbDarkvaleGate.setSelected(true);
        }
    }

    private class ChangeActionListener
    implements ActionListener {
        private ChangeActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GDCharRiftAct3Pane.this.changed = true;
        }
    }
}

