/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.ui.character;

import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import org.gdstash.character.GDChar;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.ui.character.GDCharRiftPane;
import org.gdstash.ui.character.GDCharShrinePane;
import org.gdstash.ui.util.AdjustableTabbedPane;
import org.gdstash.util.GDMsgFormatter;

public class GDCharRiftShrineTabbedPane
extends AdjustableTabbedPane {
    private TitledBorder brdRift;
    private GDCharRiftPane pnlRiftNormal;
    private GDCharRiftPane pnlRiftElite;
    private GDCharRiftPane pnlRiftUltimate;
    private TitledBorder brdShrine;
    private GDCharShrinePane pnlShrineNormal;
    private GDCharShrinePane pnlShrineElite;
    private GDCharShrinePane pnlShrineUltimate;

    public GDCharRiftShrineTabbedPane() {
        this.adjustUI();
    }

    @Override
    public void adjustUI() {
        Font fntLabel = UIManager.getDefaults().getFont("Label.font");
        Font fntTabbed = UIManager.getDefaults().getFont("TabbedPane.font");
        Font fntBorder = UIManager.getDefaults().getFont("TitledBorder.font");
        if (fntBorder == null) {
            fntBorder = fntLabel;
        }
        fntTabbed = fntTabbed.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        this.setFont(fntTabbed);
        fntBorder = fntBorder.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        Border lowered = BorderFactory.createEtchedBorder(1);
        Border raised = BorderFactory.createEtchedBorder(0);
        CompoundBorder compound = BorderFactory.createCompoundBorder(raised, lowered);
        this.brdRift = BorderFactory.createTitledBorder(compound, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "TXT_CHAR_RIFTS"));
        this.brdRift.setTitleFont(fntBorder);
        if (this.pnlRiftNormal == null) {
            this.pnlRiftNormal = new GDCharRiftPane(0);
        } else {
            this.pnlRiftNormal.adjustUI();
            this.pnlRiftNormal.setBorder(this.brdRift);
        }
        this.pnlRiftNormal.setBorder(this.brdRift);
        if (this.pnlRiftElite == null) {
            this.pnlRiftElite = new GDCharRiftPane(1);
        } else {
            this.pnlRiftElite.adjustUI();
        }
        this.pnlRiftElite.setBorder(this.brdRift);
        if (this.pnlRiftUltimate == null) {
            this.pnlRiftUltimate = new GDCharRiftPane(2);
        } else {
            this.pnlRiftUltimate.adjustUI();
        }
        this.pnlRiftUltimate.setBorder(this.brdRift);
        this.brdShrine = BorderFactory.createTitledBorder(compound, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "TXT_CHAR_SHRINES"));
        this.brdShrine.setTitleFont(fntBorder);
        if (this.pnlShrineNormal == null) {
            this.pnlShrineNormal = new GDCharShrinePane(0);
        } else {
            this.pnlShrineNormal.adjustUI();
        }
        this.pnlShrineNormal.setBorder(this.brdShrine);
        if (this.pnlShrineElite == null) {
            this.pnlShrineElite = new GDCharShrinePane(1);
        } else {
            this.pnlShrineElite.adjustUI();
        }
        this.pnlShrineElite.setBorder(this.brdShrine);
        if (this.pnlShrineUltimate == null) {
            this.pnlShrineUltimate = new GDCharShrinePane(2);
        } else {
            this.pnlShrineUltimate.adjustUI();
        }
        this.pnlShrineUltimate.setBorder(this.brdShrine);
        if (this.getTabCount() == 0) {
            JPanel pnlNormal = this.buildPagePanel(this.pnlRiftNormal, this.pnlShrineNormal);
            JPanel pnlElite = this.buildPagePanel(this.pnlRiftElite, this.pnlShrineElite);
            JPanel pnlUltimate = this.buildPagePanel(this.pnlRiftUltimate, this.pnlShrineUltimate);
            this.add(pnlNormal);
            this.add(pnlElite);
            this.add(pnlUltimate);
        }
        this.setTitleAt(0, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "TXT_DIFF_NORMAL"));
        this.setTitleAt(1, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "TXT_DIFF_ELITE"));
        this.setTitleAt(2, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "TXT_DIFF_ULTIMATE"));
    }

    private JPanel buildPagePanel(JPanel pnlRift, JPanel pnlShrine) {
        JPanel panel = new JPanel();
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(pnlRift).addComponent(pnlShrine));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(pnlRift)).addGroup(layout.createParallelGroup().addComponent(pnlShrine));
        layout.setVerticalGroup(vGroup);
        layout.linkSize(0, pnlRift, pnlShrine);
        return panel;
    }

    public void setChar(GDChar gdc) {
        this.pnlRiftNormal.setChar(gdc);
        this.pnlRiftElite.setChar(gdc);
        this.pnlRiftUltimate.setChar(gdc);
        this.pnlShrineNormal.setChar(gdc);
        this.pnlShrineElite.setChar(gdc);
        this.pnlShrineUltimate.setChar(gdc);
    }

    public void updateChar(GDChar gdc) {
        if (gdc == null) {
            return;
        }
        this.pnlRiftNormal.updateChar(gdc);
        this.pnlRiftElite.updateChar(gdc);
        this.pnlRiftUltimate.updateChar(gdc);
        this.pnlShrineNormal.updateChar(gdc);
        this.pnlShrineElite.updateChar(gdc);
        this.pnlShrineUltimate.updateChar(gdc);
    }
}

