/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.ui.character;

import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import org.gdstash.character.GDChar;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.ui.character.GDCharRiftPane;
import org.gdstash.ui.util.AdjustableTabbedPane;
import org.gdstash.util.GDMsgFormatter;

public class GDCharRiftTabbedPane
extends AdjustableTabbedPane {
    private GDCharRiftPane pnlNormal;
    private GDCharRiftPane pnlElite;
    private GDCharRiftPane pnlUltimate;

    public GDCharRiftTabbedPane() {
        this.adjustUI();
    }

    @Override
    public void adjustUI() {
        Font fntLabel = UIManager.getDefaults().getFont("Label.font");
        Font fntTabbed = UIManager.getDefaults().getFont("TabbedPane.font");
        Font fntBorder = UIManager.getDefaults().getFont("TitledBorder.font");
        if (fntBorder == null) {
            fntBorder = fntLabel;
        }
        fntTabbed = fntTabbed.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        this.setFont(fntTabbed);
        fntBorder = fntBorder.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        Border lowered = BorderFactory.createEtchedBorder(1);
        Border raised = BorderFactory.createEtchedBorder(0);
        CompoundBorder compound = BorderFactory.createCompoundBorder(raised, lowered);
        TitledBorder text = BorderFactory.createTitledBorder(compound, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "TXT_CHAR_RIFTS"));
        text.setTitleFont(fntBorder);
        this.setBorder(text);
        if (this.pnlNormal == null) {
            this.pnlNormal = new GDCharRiftPane(0);
            this.add(this.pnlNormal);
        } else {
            this.pnlNormal.adjustUI();
        }
        if (this.pnlElite == null) {
            this.pnlElite = new GDCharRiftPane(1);
            this.add(this.pnlElite);
        } else {
            this.pnlElite.adjustUI();
        }
        if (this.pnlUltimate == null) {
            this.pnlUltimate = new GDCharRiftPane(2);
            this.add(this.pnlUltimate);
        } else {
            this.pnlUltimate.adjustUI();
        }
        this.setTitleAt(0, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "TXT_DIFF_NORMAL"));
        this.setTitleAt(1, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "TXT_DIFF_ELITE"));
        this.setTitleAt(2, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "TXT_DIFF_ULTIMATE"));
    }

    public void setChar(GDChar gdc) {
        this.pnlNormal.setChar(gdc);
        this.pnlElite.setChar(gdc);
        this.pnlUltimate.setChar(gdc);
    }

    public void updateChar(GDChar gdc) {
        if (gdc == null) {
            return;
        }
        this.pnlNormal.updateChar(gdc);
        this.pnlElite.updateChar(gdc);
        this.pnlUltimate.updateChar(gdc);
    }
}

