/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.ui.character;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import org.gdstash.character.GDChar;
import org.gdstash.character.GDCharShrineList;
import org.gdstash.character.GDCharUID;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.ui.util.AdjustablePanel;
import org.gdstash.util.GDMsgFormatter;

public class GDCharShrineAct1Pane
extends AdjustablePanel {
    private JCheckBox cbBurialHill;
    private JCheckBox cbDevilsAquifier;
    private JCheckBox cbWightmireCavern;
    private JCheckBox cbFloodedPassage;
    private JCheckBox cbBurialCave;
    private JCheckBox cbBurrwitchEstates;
    private JCheckBox cbUndergroundTransit;
    private JCheckBox cbCraigsCrags;
    private int difficulty;
    private boolean changed;

    public GDCharShrineAct1Pane(int difficulty, int direction) {
        this.difficulty = difficulty;
        this.changed = false;
        this.adjustUI();
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(this.cbBurialHill).addComponent(this.cbDevilsAquifier).addComponent(this.cbWightmireCavern).addComponent(this.cbFloodedPassage).addComponent(this.cbBurialCave).addComponent(this.cbBurrwitchEstates).addComponent(this.cbUndergroundTransit).addComponent(this.cbCraigsCrags));
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(this.cbBurialHill)).addGroup(layout.createParallelGroup().addComponent(this.cbDevilsAquifier)).addGroup(layout.createParallelGroup().addComponent(this.cbWightmireCavern)).addGroup(layout.createParallelGroup().addComponent(this.cbFloodedPassage)).addGroup(layout.createParallelGroup().addComponent(this.cbBurialCave)).addGroup(layout.createParallelGroup().addComponent(this.cbBurrwitchEstates)).addGroup(layout.createParallelGroup().addComponent(this.cbUndergroundTransit)).addGroup(layout.createParallelGroup().addComponent(this.cbCraigsCrags));
        if (direction == 0) {
            layout.setHorizontalGroup(vGroup);
            layout.setVerticalGroup(hGroup);
        } else {
            layout.setHorizontalGroup(hGroup);
            layout.setVerticalGroup(vGroup);
        }
        layout.linkSize(0, this.cbBurialHill, this.cbDevilsAquifier);
        layout.linkSize(0, this.cbBurialHill, this.cbWightmireCavern);
        layout.linkSize(0, this.cbBurialHill, this.cbFloodedPassage);
        layout.linkSize(0, this.cbBurialHill, this.cbBurialCave);
        layout.linkSize(0, this.cbBurialHill, this.cbBurrwitchEstates);
        layout.linkSize(0, this.cbBurialHill, this.cbUndergroundTransit);
        layout.linkSize(0, this.cbBurialHill, this.cbCraigsCrags);
        layout.linkSize(1, this.cbBurialHill, this.cbDevilsAquifier);
        layout.linkSize(1, this.cbBurialHill, this.cbWightmireCavern);
        layout.linkSize(1, this.cbBurialHill, this.cbFloodedPassage);
        layout.linkSize(1, this.cbBurialHill, this.cbBurialCave);
        layout.linkSize(1, this.cbBurialHill, this.cbBurrwitchEstates);
        layout.linkSize(1, this.cbBurialHill, this.cbUndergroundTransit);
        layout.linkSize(1, this.cbBurialHill, this.cbCraigsCrags);
    }

    @Override
    public void adjustUI() {
        Font fntBorder;
        Font fntLabel = UIManager.getDefaults().getFont("Label.font");
        Font fntCheck = UIManager.getDefaults().getFont("CheckBox.font");
        if (fntCheck == null) {
            fntCheck = fntLabel;
        }
        if ((fntBorder = UIManager.getDefaults().getFont("TitledBorder.font")) == null) {
            fntBorder = fntLabel;
        }
        fntLabel = fntLabel.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntCheck = fntCheck.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntBorder = fntBorder.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        Border lowered = BorderFactory.createEtchedBorder(1);
        Border raised = BorderFactory.createEtchedBorder(0);
        CompoundBorder compound = BorderFactory.createCompoundBorder(raised, lowered);
        TitledBorder text = BorderFactory.createTitledBorder(compound, GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_RIFT_ACT1"));
        text.setTitleFont(fntBorder);
        this.setBorder(text);
        if (this.cbBurialHill == null) {
            this.cbBurialHill = new JCheckBox();
            if (this.difficulty > 1) {
                this.cbBurialHill.setEnabled(false);
            } else {
                this.cbBurialHill.addActionListener(new ChangeActionListener());
            }
        }
        this.cbBurialHill.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_SHRINE_01_BURIAL_HILL"));
        this.cbBurialHill.setFont(fntCheck);
        if (this.cbDevilsAquifier == null) {
            this.cbDevilsAquifier = new JCheckBox();
            if (this.difficulty > 0) {
                this.cbDevilsAquifier.setEnabled(false);
            } else {
                this.cbDevilsAquifier.addActionListener(new ChangeActionListener());
            }
        }
        this.cbDevilsAquifier.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_SHRINE_01_DEVILS_AQUIFIER"));
        this.cbDevilsAquifier.setFont(fntCheck);
        if (this.cbWightmireCavern == null) {
            this.cbWightmireCavern = new JCheckBox();
            this.cbWightmireCavern.addActionListener(new ChangeActionListener());
        }
        this.cbWightmireCavern.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_SHRINE_01_WIGHTMIRE_CAVERN"));
        this.cbWightmireCavern.setFont(fntCheck);
        if (this.cbFloodedPassage == null) {
            this.cbFloodedPassage = new JCheckBox();
            if (this.difficulty > 0) {
                this.cbFloodedPassage.setEnabled(false);
            } else {
                this.cbFloodedPassage.addActionListener(new ChangeActionListener());
            }
        }
        this.cbFloodedPassage.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_SHRINE_01_FLOODED_PASSAGE"));
        this.cbFloodedPassage.setFont(fntCheck);
        if (this.cbBurialCave == null) {
            this.cbBurialCave = new JCheckBox();
            if (this.difficulty > 0) {
                this.cbBurialCave.setEnabled(false);
            } else {
                this.cbBurialCave.addActionListener(new ChangeActionListener());
            }
        }
        this.cbBurialCave.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_SHRINE_01_BURIAL_CAVE"));
        this.cbBurialCave.setFont(fntCheck);
        if (this.cbBurrwitchEstates == null) {
            this.cbBurrwitchEstates = new JCheckBox();
            if (this.difficulty > 1) {
                this.cbBurrwitchEstates.setEnabled(false);
            } else {
                this.cbBurrwitchEstates.addActionListener(new ChangeActionListener());
            }
        }
        this.cbBurrwitchEstates.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_SHRINE_01_BURRWITCH_ESTATES"));
        this.cbBurrwitchEstates.setFont(fntCheck);
        if (this.cbUndergroundTransit == null) {
            this.cbUndergroundTransit = new JCheckBox();
            this.cbUndergroundTransit.addActionListener(new ChangeActionListener());
        }
        this.cbUndergroundTransit.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_SHRINE_01_UNDERGROUND_TRANSIT"));
        this.cbUndergroundTransit.setFont(fntCheck);
        if (this.cbCraigsCrags == null) {
            this.cbCraigsCrags = new JCheckBox();
            this.cbCraigsCrags.addActionListener(new ChangeActionListener());
        }
        this.cbCraigsCrags.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_SHRINE_01_CRAIGS_CRAGS"));
        this.cbCraigsCrags.setFont(fntCheck);
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    public void setSelected(boolean selected) {
        this.cbBurialHill.setSelected(selected);
        this.cbDevilsAquifier.setSelected(selected);
        this.cbWightmireCavern.setSelected(selected);
        this.cbFloodedPassage.setSelected(selected);
        this.cbBurialCave.setSelected(selected);
        this.cbBurrwitchEstates.setSelected(selected);
        this.cbUndergroundTransit.setSelected(selected);
        this.cbCraigsCrags.setSelected(selected);
    }

    public List<GDCharUID> getShrineList() {
        LinkedList<GDCharUID> list = new LinkedList<GDCharUID>();
        if (this.cbBurialHill.isSelected()) {
            list.add(GDCharShrineList.UID_SHRINE_01_BURIAL_HILL);
        }
        if (this.cbDevilsAquifier.isSelected()) {
            list.add(GDCharShrineList.UID_SHRINE_01_DEVILS_AQUIFIER);
        }
        if (this.cbWightmireCavern.isSelected()) {
            list.add(GDCharShrineList.UID_SHRINE_01_WIGHTMIRE_CAVERN);
        }
        if (this.cbFloodedPassage.isSelected()) {
            list.add(GDCharShrineList.UID_SHRINE_01_FLOODED_PASSAGE);
        }
        if (this.cbBurialCave.isSelected()) {
            list.add(GDCharShrineList.UID_SHRINE_01_BURIAL_CAVE);
        }
        if (this.cbBurrwitchEstates.isSelected()) {
            list.add(GDCharShrineList.UID_SHRINE_01_BURRWITCH_ESTATES);
        }
        if (this.cbUndergroundTransit.isSelected()) {
            list.add(GDCharShrineList.UID_SHRINE_01_UNDERGROUND_TRANSIT);
        }
        if (this.cbCraigsCrags.isSelected()) {
            list.add(GDCharShrineList.UID_SHRINE_01_CRAIGS_CRAGS);
        }
        return list;
    }

    public void setChar(GDChar gdc) {
        this.setSelected(false);
        this.changed = false;
        if (gdc == null) {
            return;
        }
        List<GDCharUID> list = gdc.getRestoredShrinesList(this.difficulty);
        for (GDCharUID uid : list) {
            if (uid.equals(GDCharShrineList.UID_SHRINE_01_BURIAL_HILL)) {
                this.cbBurialHill.setSelected(true);
            }
            if (uid.equals(GDCharShrineList.UID_SHRINE_01_DEVILS_AQUIFIER)) {
                this.cbDevilsAquifier.setSelected(true);
            }
            if (uid.equals(GDCharShrineList.UID_SHRINE_01_WIGHTMIRE_CAVERN)) {
                this.cbWightmireCavern.setSelected(true);
            }
            if (uid.equals(GDCharShrineList.UID_SHRINE_01_FLOODED_PASSAGE)) {
                this.cbFloodedPassage.setSelected(true);
            }
            if (uid.equals(GDCharShrineList.UID_SHRINE_01_BURIAL_CAVE)) {
                this.cbBurialCave.setSelected(true);
            }
            if (uid.equals(GDCharShrineList.UID_SHRINE_01_BURRWITCH_ESTATES)) {
                this.cbBurrwitchEstates.setSelected(true);
            }
            if (uid.equals(GDCharShrineList.UID_SHRINE_01_UNDERGROUND_TRANSIT)) {
                this.cbUndergroundTransit.setSelected(true);
            }
            if (!uid.equals(GDCharShrineList.UID_SHRINE_01_CRAIGS_CRAGS)) continue;
            this.cbCraigsCrags.setSelected(true);
        }
    }

    private class ChangeActionListener
    implements ActionListener {
        private ChangeActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GDCharShrineAct1Pane.this.changed = true;
        }
    }
}

