/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.ui.character;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import org.gdstash.character.GDChar;
import org.gdstash.character.GDCharShrineList;
import org.gdstash.character.GDCharUID;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.ui.util.AdjustablePanel;
import org.gdstash.util.GDMsgFormatter;

public class GDCharShrineAct3Pane
extends AdjustablePanel {
    private JCheckBox cbMountainDeeps;
    private JCheckBox cbForgottenDepths;
    private JCheckBox cbTyrantsHold;
    private JCheckBox cbInfestedFarms;
    private JCheckBox cbDenOfTheLost;
    private JCheckBox cbBloodGrove;
    private JCheckBox cbVillageOfDarkvale;
    private int difficulty;
    private boolean changed;

    public GDCharShrineAct3Pane(int difficulty, int direction) {
        this.difficulty = difficulty;
        this.changed = false;
        this.adjustUI();
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(this.cbMountainDeeps).addComponent(this.cbForgottenDepths).addComponent(this.cbTyrantsHold).addComponent(this.cbInfestedFarms).addComponent(this.cbDenOfTheLost).addComponent(this.cbBloodGrove).addComponent(this.cbVillageOfDarkvale));
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(this.cbMountainDeeps)).addGroup(layout.createParallelGroup().addComponent(this.cbForgottenDepths)).addGroup(layout.createParallelGroup().addComponent(this.cbTyrantsHold)).addGroup(layout.createParallelGroup().addComponent(this.cbInfestedFarms)).addGroup(layout.createParallelGroup().addComponent(this.cbDenOfTheLost)).addGroup(layout.createParallelGroup().addComponent(this.cbBloodGrove)).addGroup(layout.createParallelGroup().addComponent(this.cbVillageOfDarkvale));
        if (direction == 0) {
            layout.setHorizontalGroup(vGroup);
            layout.setVerticalGroup(hGroup);
        } else {
            layout.setHorizontalGroup(hGroup);
            layout.setVerticalGroup(vGroup);
        }
        layout.linkSize(0, this.cbMountainDeeps, this.cbForgottenDepths);
        layout.linkSize(0, this.cbMountainDeeps, this.cbTyrantsHold);
        layout.linkSize(0, this.cbMountainDeeps, this.cbInfestedFarms);
        layout.linkSize(0, this.cbMountainDeeps, this.cbDenOfTheLost);
        layout.linkSize(0, this.cbMountainDeeps, this.cbBloodGrove);
        layout.linkSize(0, this.cbMountainDeeps, this.cbVillageOfDarkvale);
        layout.linkSize(1, this.cbMountainDeeps, this.cbForgottenDepths);
        layout.linkSize(1, this.cbMountainDeeps, this.cbTyrantsHold);
        layout.linkSize(1, this.cbMountainDeeps, this.cbInfestedFarms);
        layout.linkSize(1, this.cbMountainDeeps, this.cbDenOfTheLost);
        layout.linkSize(1, this.cbMountainDeeps, this.cbBloodGrove);
        layout.linkSize(1, this.cbMountainDeeps, this.cbVillageOfDarkvale);
    }

    @Override
    public void adjustUI() {
        Font fntBorder;
        Font fntLabel = UIManager.getDefaults().getFont("Label.font");
        Font fntCheck = UIManager.getDefaults().getFont("CheckBox.font");
        if (fntCheck == null) {
            fntCheck = fntLabel;
        }
        if ((fntBorder = UIManager.getDefaults().getFont("TitledBorder.font")) == null) {
            fntBorder = fntLabel;
        }
        fntLabel = fntLabel.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntCheck = fntCheck.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntBorder = fntBorder.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        Border lowered = BorderFactory.createEtchedBorder(1);
        Border raised = BorderFactory.createEtchedBorder(0);
        CompoundBorder compound = BorderFactory.createCompoundBorder(raised, lowered);
        TitledBorder text = BorderFactory.createTitledBorder(compound, GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_RIFT_ACT3"));
        text.setTitleFont(fntBorder);
        this.setBorder(text);
        if (this.cbMountainDeeps == null) {
            this.cbMountainDeeps = new JCheckBox();
            if (this.difficulty > 0) {
                this.cbMountainDeeps.setEnabled(false);
            } else {
                this.cbMountainDeeps.addActionListener(new ChangeActionListener());
            }
        }
        this.cbMountainDeeps.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_SHRINE_03_MOUNTAIN_DEEPS"));
        this.cbMountainDeeps.setFont(fntCheck);
        if (this.cbForgottenDepths == null) {
            this.cbForgottenDepths = new JCheckBox();
            if (this.difficulty > 0) {
                this.cbForgottenDepths.setEnabled(false);
            } else {
                this.cbForgottenDepths.addActionListener(new ChangeActionListener());
            }
        }
        this.cbForgottenDepths.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_SHRINE_03_FORGOTTEN_DEPTHS"));
        this.cbForgottenDepths.setFont(fntCheck);
        if (this.cbTyrantsHold == null) {
            this.cbTyrantsHold = new JCheckBox();
            this.cbTyrantsHold.addActionListener(new ChangeActionListener());
        }
        this.cbTyrantsHold.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_SHRINE_03_TYRANTS_HOLD"));
        this.cbTyrantsHold.setFont(fntCheck);
        if (this.cbInfestedFarms == null) {
            this.cbInfestedFarms = new JCheckBox();
            if (this.difficulty > 0) {
                this.cbInfestedFarms.setEnabled(false);
            } else {
                this.cbInfestedFarms.addActionListener(new ChangeActionListener());
            }
        }
        this.cbInfestedFarms.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_SHRINE_03_INFESTED_FARMS"));
        this.cbInfestedFarms.setFont(fntCheck);
        if (this.cbDenOfTheLost == null) {
            this.cbDenOfTheLost = new JCheckBox();
            this.cbDenOfTheLost.addActionListener(new ChangeActionListener());
        }
        this.cbDenOfTheLost.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_SHRINE_03_DEN_OF_THE_LOST"));
        this.cbDenOfTheLost.setFont(fntCheck);
        if (this.cbBloodGrove == null) {
            this.cbBloodGrove = new JCheckBox();
            if (this.difficulty > 0) {
                this.cbBloodGrove.setEnabled(false);
            } else {
                this.cbBloodGrove.addActionListener(new ChangeActionListener());
            }
        }
        this.cbBloodGrove.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_SHRINE_03_BLOOD_GROVE"));
        this.cbBloodGrove.setFont(fntCheck);
        if (this.cbVillageOfDarkvale == null) {
            this.cbVillageOfDarkvale = new JCheckBox();
            this.cbVillageOfDarkvale.addActionListener(new ChangeActionListener());
        }
        this.cbVillageOfDarkvale.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_SHRINE_03_VILLAGE_OF_DARKVALE"));
        this.cbVillageOfDarkvale.setFont(fntCheck);
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    public void setSelectged(boolean selected) {
        this.cbMountainDeeps.setSelected(selected);
        this.cbForgottenDepths.setSelected(selected);
        this.cbTyrantsHold.setSelected(selected);
        this.cbInfestedFarms.setSelected(selected);
        this.cbDenOfTheLost.setSelected(selected);
        this.cbBloodGrove.setSelected(selected);
        this.cbVillageOfDarkvale.setSelected(selected);
    }

    public List<GDCharUID> getShrineList() {
        LinkedList<GDCharUID> list = new LinkedList<GDCharUID>();
        if (this.cbMountainDeeps.isSelected()) {
            list.add(GDCharShrineList.UID_SHRINE_03_MOUNTAIN_DEEPS);
        }
        if (this.cbForgottenDepths.isSelected()) {
            list.add(GDCharShrineList.UID_SHRINE_03_FORGOTTEN_DEPTHS);
        }
        if (this.cbTyrantsHold.isSelected()) {
            list.add(GDCharShrineList.UID_SHRINE_03_TYRANTS_HOLD);
        }
        if (this.cbInfestedFarms.isSelected()) {
            list.add(GDCharShrineList.UID_SHRINE_03_INFESTED_FARMS);
        }
        if (this.cbDenOfTheLost.isSelected()) {
            list.add(GDCharShrineList.UID_SHRINE_03_DEN_OF_THE_LOST);
        }
        if (this.cbBloodGrove.isSelected()) {
            list.add(GDCharShrineList.UID_SHRINE_03_BLOOD_GROVE);
        }
        if (this.cbVillageOfDarkvale.isSelected()) {
            list.add(GDCharShrineList.UID_SHRINE_03_VILLAGE_OF_DARKVALE);
        }
        return list;
    }

    public void setChar(GDChar gdc) {
        this.setSelectged(false);
        this.changed = false;
        if (gdc == null) {
            return;
        }
        List<GDCharUID> list = gdc.getRestoredShrinesList(this.difficulty);
        for (GDCharUID uid : list) {
            if (uid.equals(GDCharShrineList.UID_SHRINE_03_MOUNTAIN_DEEPS)) {
                this.cbMountainDeeps.setSelected(true);
            }
            if (uid.equals(GDCharShrineList.UID_SHRINE_03_FORGOTTEN_DEPTHS)) {
                this.cbForgottenDepths.setSelected(true);
            }
            if (uid.equals(GDCharShrineList.UID_SHRINE_03_TYRANTS_HOLD)) {
                this.cbTyrantsHold.setSelected(true);
            }
            if (uid.equals(GDCharShrineList.UID_SHRINE_03_INFESTED_FARMS)) {
                this.cbInfestedFarms.setSelected(true);
            }
            if (uid.equals(GDCharShrineList.UID_SHRINE_03_DEN_OF_THE_LOST)) {
                this.cbDenOfTheLost.setSelected(true);
            }
            if (uid.equals(GDCharShrineList.UID_SHRINE_03_BLOOD_GROVE)) {
                this.cbBloodGrove.setSelected(true);
            }
            if (!uid.equals(GDCharShrineList.UID_SHRINE_03_VILLAGE_OF_DARKVALE)) continue;
            this.cbVillageOfDarkvale.setSelected(true);
        }
    }

    private class ChangeActionListener
    implements ActionListener {
        private ChangeActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GDCharShrineAct3Pane.this.changed = true;
        }
    }
}

