/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.ui.character;

import java.awt.Font;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.gdstash.character.GDChar;
import org.gdstash.character.GDCharUID;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.ui.character.GDCharShrineAct1Pane;
import org.gdstash.ui.character.GDCharShrineAct2Pane;
import org.gdstash.ui.character.GDCharShrineAct3Pane;
import org.gdstash.ui.character.GDCharShrineAct4Pane;
import org.gdstash.ui.util.AdjustablePanel;

public class GDCharShrinePane
extends AdjustablePanel {
    private GDCharShrineAct1Pane pnlAct1;
    private GDCharShrineAct2Pane pnlAct2;
    private GDCharShrineAct3Pane pnlAct3;
    private GDCharShrineAct4Pane pnlAct4;
    private int difficulty;

    public GDCharShrinePane(int difficulty) {
        this.difficulty = difficulty;
        this.adjustUI();
        JPanel pnlRift = this.buildRiftPanel();
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateGaps(false);
        layout.setAutoCreateContainerGaps(false);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(pnlRift));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(pnlRift));
        layout.setVerticalGroup(vGroup);
    }

    @Override
    public void adjustUI() {
        Font fntLabel = UIManager.getDefaults().getFont("Label.font");
        fntLabel = fntLabel.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        Border lowered = BorderFactory.createEtchedBorder(1);
        Border raised = BorderFactory.createEtchedBorder(0);
        CompoundBorder compound = BorderFactory.createCompoundBorder(raised, lowered);
        this.setBorder(compound);
        if (this.pnlAct1 == null) {
            this.pnlAct1 = new GDCharShrineAct1Pane(this.difficulty, 1);
        } else {
            this.pnlAct1.adjustUI();
        }
        if (this.pnlAct2 == null) {
            this.pnlAct2 = new GDCharShrineAct2Pane(this.difficulty, 1);
        } else {
            this.pnlAct2.adjustUI();
        }
        if (this.pnlAct3 == null) {
            this.pnlAct3 = new GDCharShrineAct3Pane(this.difficulty, 1);
        } else {
            this.pnlAct3.adjustUI();
        }
        if (this.pnlAct4 == null) {
            this.pnlAct4 = new GDCharShrineAct4Pane(this.difficulty, 1);
        } else {
            this.pnlAct4.adjustUI();
        }
    }

    private JPanel buildRiftPanel() {
        JPanel panel = new JPanel();
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setAutoCreateGaps(false);
        layout.setAutoCreateContainerGaps(false);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(this.pnlAct1)).addGroup(layout.createParallelGroup().addComponent(this.pnlAct2)).addGroup(layout.createParallelGroup().addComponent(this.pnlAct3)).addGroup(layout.createParallelGroup().addComponent(this.pnlAct4));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(this.pnlAct1).addComponent(this.pnlAct2).addComponent(this.pnlAct3).addComponent(this.pnlAct4));
        layout.setVerticalGroup(vGroup);
        layout.linkSize(0, this.pnlAct1, this.pnlAct2);
        layout.linkSize(0, this.pnlAct1, this.pnlAct3);
        layout.linkSize(0, this.pnlAct1, this.pnlAct4);
        layout.linkSize(1, this.pnlAct1, this.pnlAct2);
        layout.linkSize(1, this.pnlAct1, this.pnlAct3);
        layout.linkSize(1, this.pnlAct1, this.pnlAct4);
        return panel;
    }

    public List<GDCharUID> getRiftList() {
        LinkedList<GDCharUID> listAll = new LinkedList<GDCharUID>();
        List<GDCharUID> list = null;
        list = this.pnlAct1.getShrineList();
        if (list != null) {
            listAll.addAll(list);
        }
        if ((list = this.pnlAct2.getShrineList()) != null) {
            listAll.addAll(list);
        }
        if ((list = this.pnlAct3.getShrineList()) != null) {
            listAll.addAll(list);
        }
        if ((list = this.pnlAct4.getShrineList()) != null) {
            listAll.addAll(list);
        }
        return listAll;
    }

    public void setChar(GDChar gdc) {
        this.pnlAct1.setChar(gdc);
        this.pnlAct2.setChar(gdc);
        this.pnlAct3.setChar(gdc);
        this.pnlAct4.setChar(gdc);
    }

    public void updateChar(GDChar gdc) {
        if (gdc == null) {
            return;
        }
        boolean changed = false;
        changed = changed || this.pnlAct1.hasChanged();
        changed = changed || this.pnlAct2.hasChanged();
        changed = changed || this.pnlAct3.hasChanged();
        boolean bl = changed = changed || this.pnlAct4.hasChanged();
        if (!changed) {
            return;
        }
        List<GDCharUID> listAll = this.getRiftList();
        gdc.setRestoredShrinesList(this.difficulty, listAll);
        this.pnlAct1.setChanged(false);
        this.pnlAct2.setChanged(false);
        this.pnlAct3.setChanged(false);
        this.pnlAct4.setChanged(false);
    }
}

