/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.ui.font;

import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.gdstash.ui.font.ComparisonResult;
import org.gdstash.ui.font.SelectionListener;

public class FieldListener
implements DocumentListener {
    private JList list;
    private JTextField textField;
    private ListModel model;
    private SelectionListener selectionListener;

    public void setList(JList list) {
        this.list = list;
    }

    public void setTextField(JTextField textField) {
        this.textField = textField;
    }

    public void setModel(ListModel model) {
        this.model = model;
    }

    public void setSelectionListener(SelectionListener selectionListener) {
        this.selectionListener = selectionListener;
    }

    @Override
    public void changedUpdate(DocumentEvent event) {
    }

    @Override
    public void insertUpdate(DocumentEvent event) {
        this.setListSelection(event);
    }

    @Override
    public void removeUpdate(DocumentEvent event) {
        this.setListSelection(event);
    }

    private void setListSelection(DocumentEvent event) {
        Document document = this.textField.getDocument();
        try {
            String s = document.getText(0, document.getLength());
            if (s.equals("")) {
                this.list.clearSelection();
                this.list.ensureIndexIsVisible(0);
            } else {
                ComparisonResult result = this.searchModel(s);
                this.list.removeListSelectionListener(this.selectionListener);
                this.list.ensureIndexIsVisible(this.model.getSize() - 1);
                if (result.isExactMatch()) {
                    this.list.setSelectedIndex(result.getListIndex());
                } else {
                    this.list.clearSelection();
                    this.list.ensureIndexIsVisible(result.getListIndex());
                }
                this.list.addListSelectionListener(this.selectionListener);
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    private ComparisonResult searchModel(String searchTerm) {
        for (int i = 0; i < this.model.getSize(); ++i) {
            String t;
            Object object = this.model.getElementAt(i);
            String s = object.toString().toLowerCase();
            if (s.equals(t = searchTerm.toLowerCase())) {
                return new ComparisonResult(i, true);
            }
            if (!s.startsWith(t)) continue;
            return new ComparisonResult(i, false);
        }
        return new ComparisonResult(0, false);
    }
}

