/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.ui.font;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gdstash.ui.font.EscapeDialog;
import org.gdstash.ui.font.FontSamplePanel;
import org.gdstash.ui.font.TextFieldList;

public class FontChooserDialog {
    private static final Insets LABEL_INSETS = new Insets(10, 10, 0, 0);
    private static final Insets COMBOBOX_INSETS = new Insets(0, 10, 0, 0);
    private static final Insets COMBOBOX_INSETS_LAST = new Insets(0, 10, 0, 10);
    private static final Insets BUTTON_INSETS = new Insets(10, 10, 10, 10);
    private static final String SAMPLE_STRING = "AaBbIiMmYyZz";
    private boolean okPressed;
    private int familySize;
    private int familyStyle;
    private DefaultListModel<String> fontNameListModel;
    private DefaultListModel<String> fontStyleListModel;
    private DefaultListModel<String> fontSizeListModel;
    private EscapeDialog dialog;
    private Font font;
    private JFrame frame;
    private JPanel mainPanel;
    private FontSamplePanel samplePanel;
    private String familyName;
    private TextFieldList fontNameList;
    private TextFieldList fontStyleList;
    private TextFieldList fontSizeList;

    public FontChooserDialog(JFrame frame) {
        this(frame, null);
    }

    public FontChooserDialog(JFrame frame, Font defaultFont) {
        this.frame = frame;
        this.font = defaultFont;
        this.fontNameListModel = new DefaultListModel();
        this.fontStyleListModel = new DefaultListModel();
        this.fontSizeListModel = new DefaultListModel();
        this.getDefaultFontFields();
        this.getAllFontNames();
        this.getAllFontStyles();
        this.getAllFontSizes();
        this.createPartControl();
    }

    public Font getSelectedFont() {
        return this.font;
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    private void getDefaultFontFields() {
        if (this.font != null) {
            this.familyName = this.font.getFamily();
            this.familyStyle = this.font.getStyle();
            this.familySize = this.font.getSize();
        }
    }

    private void getAllFontNames() {
        GraphicsEnvironment e = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (String name : e.getAvailableFontFamilyNames()) {
            this.fontNameListModel.addElement(name);
        }
    }

    private void getAllFontStyles() {
        this.fontStyleListModel.addElement("Regular");
        this.fontStyleListModel.addElement("Bold");
        this.fontStyleListModel.addElement("Italic");
        this.fontStyleListModel.addElement("Bold Italic");
    }

    private void getAllFontSizes() {
        int i;
        for (i = 8; i <= 11; ++i) {
            this.fontSizeListModel.addElement(Integer.toString(i));
        }
        for (i = 12; i <= 28; i += 2) {
            this.fontSizeListModel.addElement(Integer.toString(i));
        }
        this.fontSizeListModel.addElement(Integer.toString(36));
        this.fontSizeListModel.addElement(Integer.toString(48));
        this.fontSizeListModel.addElement(Integer.toString(72));
    }

    private void createPartControl() {
        this.dialog = new EscapeDialog(this.frame);
        this.dialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.dialog.setTitle("Font");
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new GridBagLayout());
        int gridy = 0;
        gridy = this.createFontLabelControl(gridy);
        gridy = this.createFontComboBoxControl(gridy);
        gridy = this.createSampleControl(gridy);
        gridy = this.createButtonControl(gridy);
        this.dialog.add(this.mainPanel);
        this.dialog.pack();
        this.dialog.setVisible(true);
    }

    private int createFontLabelControl(int gridy) {
        JLabel fontNameLabel = new JLabel("Font");
        this.addComponent(this.mainPanel, fontNameLabel, 0, gridy, 1, 1, LABEL_INSETS, 21, 0);
        JLabel fontStyleLabel = new JLabel("Font style");
        this.addComponent(this.mainPanel, fontStyleLabel, 1, gridy, 1, 1, LABEL_INSETS, 21, 0);
        JLabel fontSizeLabel = new JLabel("Size");
        this.addComponent(this.mainPanel, fontSizeLabel, 2, gridy++, 1, 1, LABEL_INSETS, 21, 0);
        return gridy;
    }

    private int createFontComboBoxControl(int gridy) {
        DrawSelectionListener listener = new DrawSelectionListener();
        this.fontNameList = new TextFieldList(this.fontNameListModel);
        this.fontNameList.addListSelectionListener(listener);
        this.fontNameList.setVisibleRowCount(7);
        this.addComponent(this.mainPanel, this.fontNameList, 0, gridy, 1, 1, COMBOBOX_INSETS, 21, 2);
        this.fontStyleList = new TextFieldList(this.fontStyleListModel, 75);
        this.fontStyleList.addListSelectionListener(listener);
        this.fontStyleList.setVisibleRowCount(7);
        this.addComponent(this.mainPanel, this.fontStyleList, 1, gridy, 1, 1, COMBOBOX_INSETS, 21, 2);
        this.fontSizeList = new TextFieldList(this.fontSizeListModel, 25);
        this.fontSizeList.addListSelectionListener(listener);
        this.fontSizeList.setVisibleRowCount(7);
        this.addComponent(this.mainPanel, this.fontSizeList, 2, gridy++, 1, 1, COMBOBOX_INSETS_LAST, 21, 2);
        if (this.font != null) {
            this.fontStyleList.setSelectedIndex(this.familyStyle);
            this.fontNameList.setSelectedValue(this.familyName);
            this.fontSizeList.setSelectedValue(this.familySize);
        }
        return gridy;
    }

    private int createSampleControl(int gridy) {
        TitledBorder titledBorder = BorderFactory.createTitledBorder("Sample");
        Border bevelBorder = BorderFactory.createBevelBorder(1);
        JPanel titlePanel = new JPanel();
        titlePanel.setBorder(titledBorder);
        titlePanel.setLayout(new BorderLayout());
        this.samplePanel = new FontSamplePanel(SAMPLE_STRING);
        this.samplePanel.setBorder(bevelBorder);
        this.samplePanel.setPreferredSize(new Dimension(300, 100));
        titlePanel.add((Component)this.samplePanel, "Center");
        this.addComponent(this.mainPanel, titlePanel, 0, gridy++, 3, 1, COMBOBOX_INSETS_LAST, 21, 2);
        if (this.font != null) {
            this.drawSample();
        }
        return gridy;
    }

    private int createButtonControl(int gridy) {
        JPanel buttondrawingPanel = new JPanel();
        buttondrawingPanel.setLayout(new FlowLayout());
        JButton okButton = new JButton("OK");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Font testFont = FontChooserDialog.this.createSelectedFont();
                if (testFont == null) {
                    return;
                }
                FontChooserDialog.this.okPressed = true;
                FontChooserDialog.this.font = testFont;
                FontChooserDialog.this.dialog.setVisible(false);
            }
        });
        this.dialog.setOkButton(okButton);
        buttondrawingPanel.add(okButton);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                FontChooserDialog.this.okPressed = false;
                FontChooserDialog.this.dialog.setVisible(false);
            }
        });
        buttondrawingPanel.add(cancelButton);
        this.setButtonSizes(okButton, cancelButton);
        this.addComponent(this.mainPanel, buttondrawingPanel, 0, gridy++, 3, 1, BUTTON_INSETS, 21, 2);
        return gridy;
    }

    private void setButtonSizes(JButton ... buttons) {
        Dimension preferredSize = new Dimension();
        for (JButton button : buttons) {
            Dimension d = button.getPreferredSize();
            preferredSize = this.setLarger(preferredSize, d);
        }
        for (JButton button : buttons) {
            button.setPreferredSize(preferredSize);
        }
    }

    private Dimension setLarger(Dimension a, Dimension b) {
        Dimension d = new Dimension();
        d.height = Math.max(a.height, b.height);
        d.width = Math.max(a.width, b.width);
        return d;
    }

    private void addComponent(Container container, Component component, int gridx, int gridy, int gridwidth, int gridheight, Insets insets, int anchor, int fill) {
        GridBagConstraints gbc = new GridBagConstraints(gridx, gridy, gridwidth, gridheight, 1.0, 1.0, anchor, fill, insets, 0, 0);
        container.add(component, gbc);
    }

    public void drawSample() {
        if (this.samplePanel == null) {
            return;
        }
        this.font = this.createSelectedFont();
        if (this.font == null) {
            return;
        }
        this.samplePanel.setSampleFont(this.font);
    }

    private Font createSelectedFont() {
        boolean allValues = true;
        if (this.fontNameList == null || this.fontNameList.getSelectedValue() == null) {
            allValues = false;
        } else {
            this.familyName = this.fontNameList.getSelectedValue();
        }
        if (this.fontStyleList == null) {
            allValues = false;
        } else {
            this.familyStyle = this.fontStyleList.getSelectedIndex();
        }
        if (this.fontSizeList == null || this.fontSizeList.getSelectedValue() == null) {
            allValues = false;
        } else {
            this.familySize = Integer.parseInt(this.fontSizeList.getSelectedValue());
        }
        if (allValues) {
            return new Font(this.familyName, this.familyStyle, this.familySize);
        }
        return null;
    }

    public class DrawSelectionListener
    implements ListSelectionListener {
        @Override
        public void valueChanged(ListSelectionEvent event) {
            FontChooserDialog.this.drawSample();
        }
    }
}

