/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.ui.font;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import javax.swing.JPanel;

public class FontSamplePanel
extends JPanel {
    private Font font;
    private String sampleString;

    public FontSamplePanel(String sampleString) {
        this.sampleString = sampleString;
    }

    public void setSampleFont(Font font) {
        this.font = font;
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.font == null) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        FontRenderContext frc = g2d.getFontRenderContext();
        TextLayout layout = new TextLayout(this.sampleString, this.font, frc);
        Rectangle2D bounds = layout.getBounds();
        int width = (int)Math.round(bounds.getWidth());
        int height = (int)Math.round(bounds.getHeight());
        int x = (this.getWidth() - width) / 2;
        int y = height + (this.getHeight() - height) / 2;
        layout.draw(g2d, x, y);
    }
}

