/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.ui.font;

import javax.swing.BoxLayout;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Document;
import org.gdstash.ui.font.BorderListCellRenderer;
import org.gdstash.ui.font.FieldListener;
import org.gdstash.ui.font.SelectionListener;

public class TextFieldList
extends JPanel {
    private int rightMargin;
    private JList<String> jlist;
    private JTextField textField;
    private ListModel<String> model;
    private SelectionListener selectionListener;

    public TextFieldList(ListModel<String> model) {
        this(model, 10);
    }

    public TextFieldList(ListModel<String> model, int rightMargin) {
        this.model = model;
        this.rightMargin = rightMargin;
        this.selectionListener = new SelectionListener();
        this.createPartControl();
    }

    private void createPartControl() {
        FieldListener fieldListener = new FieldListener();
        new JPanel();
        this.setLayout(new BoxLayout(this, 1));
        this.textField = new JTextField();
        Document document = this.textField.getDocument();
        document.addDocumentListener(fieldListener);
        this.add(this.textField);
        this.jlist = new JList<String>(this.model);
        this.jlist.addListSelectionListener(this.selectionListener);
        this.jlist.setCellRenderer(new BorderListCellRenderer(this.rightMargin));
        this.jlist.setSelectionMode(0);
        JScrollPane scrollPane = new JScrollPane(this.jlist);
        this.add(scrollPane);
        fieldListener.setList(this.jlist);
        fieldListener.setModel(this.model);
        fieldListener.setSelectionListener(this.selectionListener);
        fieldListener.setTextField(this.textField);
        this.selectionListener.setFieldListener(fieldListener);
        this.selectionListener.setList(this.jlist);
        this.selectionListener.setTextField(this.textField);
    }

    public void setVisibleRowCount(int count) {
        this.jlist.setVisibleRowCount(count);
    }

    public void setSelectedValue(Object object) {
        this.jlist.setSelectedValue(object, true);
    }

    public void setSelectedIndex(int index) {
        this.jlist.setSelectedIndex(index);
    }

    public String getSelectedValue() {
        return this.jlist.getSelectedValue();
    }

    public int getSelectedIndex() {
        return this.jlist.getSelectedIndex();
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.jlist.addListSelectionListener(listener);
    }

    public JList getJList() {
        return this.jlist;
    }

    public JTextField getTextField() {
        return this.textField;
    }
}

