/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.ui.select;

import java.awt.Dimension;
import java.awt.Font;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.gdstash.db.DBAffix;
import org.gdstash.db.SelectionCriteria;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.ui.util.AdjustablePanel;
import org.gdstash.util.GDMsgFormatter;

public class AffixPane
extends AdjustablePanel {
    private static List<DBAffix> listPrefix = null;
    private static DBAffix[] arrPrefix = null;
    private static List<DBAffix> listSuffix = null;
    private static DBAffix[] arrSuffix = null;
    private JLabel lblPrefix;
    private JComboBox<DBAffix> cbPrefix;
    private JLabel lblSuffix;
    private JComboBox<DBAffix> cbSuffix;

    public static void loadAffixes() {
        DBAffix affix;
        Iterator<DBAffix> iter;
        int pos;
        if (GDStashFrame.dbConfig == null || !GDStashFrame.dbConfig.gddbInit) {
            arrPrefix = new DBAffix[1];
            AffixPane.arrPrefix[0] = null;
            arrSuffix = new DBAffix[1];
            AffixPane.arrSuffix[0] = null;
            return;
        }
        listPrefix = DBAffix.getPrefixList();
        if (listPrefix == null) {
            arrPrefix = new DBAffix[1];
            AffixPane.arrPrefix[0] = null;
        } else {
            arrPrefix = new DBAffix[listPrefix.size() + 1];
            AffixPane.arrPrefix[0] = null;
            pos = 1;
            iter = listPrefix.iterator();
            while (iter.hasNext()) {
                AffixPane.arrPrefix[pos] = affix = iter.next();
                ++pos;
            }
        }
        listSuffix = DBAffix.getSuffixList();
        if (listSuffix == null) {
            arrSuffix = new DBAffix[1];
            AffixPane.arrSuffix[0] = null;
        } else {
            arrSuffix = new DBAffix[listSuffix.size() + 1];
            AffixPane.arrSuffix[0] = null;
            pos = 1;
            iter = listSuffix.iterator();
            while (iter.hasNext()) {
                AffixPane.arrSuffix[pos] = affix = iter.next();
                ++pos;
            }
        }
    }

    public AffixPane() {
        this.adjustUI();
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(false);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(this.lblPrefix).addComponent(this.lblSuffix)).addGroup(layout.createParallelGroup().addComponent(this.cbPrefix).addComponent(this.cbSuffix));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(this.lblPrefix).addComponent(this.cbPrefix)).addGroup(layout.createParallelGroup().addComponent(this.lblSuffix).addComponent(this.cbSuffix));
        layout.setVerticalGroup(vGroup);
        layout.linkSize(0, this.lblPrefix, this.lblSuffix);
        layout.linkSize(0, this.cbPrefix, this.cbSuffix);
        layout.linkSize(1, this.lblPrefix, this.cbPrefix);
        layout.linkSize(1, this.lblPrefix, this.lblSuffix);
        layout.linkSize(1, this.lblPrefix, this.cbSuffix);
    }

    @Override
    public void adjustUI() {
        Font fntBorder;
        int size = 12;
        if (GDStashFrame.iniConfig != null) {
            size = GDStashFrame.iniConfig.sectUI.fontSize;
        }
        Dimension dimMax = new Dimension(50 * size, 2 * size);
        Font fntLabel = UIManager.getDefaults().getFont("Label.font");
        Font fntCombo = UIManager.getDefaults().getFont("ComboBox.font");
        if (fntCombo == null) {
            fntCombo = fntLabel;
        }
        if ((fntBorder = UIManager.getDefaults().getFont("TitledBorder.font")) == null) {
            fntBorder = fntLabel;
        }
        fntLabel = fntLabel.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntCombo = fntCombo.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        Border lowered = BorderFactory.createEtchedBorder(1);
        Border raised = BorderFactory.createEtchedBorder(0);
        CompoundBorder compound = BorderFactory.createCompoundBorder(raised, lowered);
        this.setBorder(compound);
        if (this.lblPrefix == null) {
            this.lblPrefix = new JLabel();
        }
        this.lblPrefix.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "TXT_PREFIX"));
        this.lblPrefix.setFont(fntLabel);
        if (this.cbPrefix == null) {
            this.cbPrefix = new JComboBox<DBAffix>(arrPrefix);
        }
        this.cbPrefix.setFont(fntCombo);
        this.cbPrefix.setPreferredSize(dimMax);
        this.cbPrefix.setMaximumSize(dimMax);
        if (this.lblSuffix == null) {
            this.lblSuffix = new JLabel();
        }
        this.lblSuffix.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "TXT_SUFFIX"));
        this.lblSuffix.setFont(fntLabel);
        if (this.cbSuffix == null) {
            this.cbSuffix = new JComboBox<DBAffix>(arrSuffix);
        }
        this.cbSuffix.setFont(fntCombo);
        this.cbSuffix.setPreferredSize(dimMax);
        this.cbSuffix.setMaximumSize(dimMax);
    }

    public void updateAffixes() {
        DefaultComboBoxModel<DBAffix> modelPrefix = new DefaultComboBoxModel<DBAffix>(arrPrefix);
        DefaultComboBoxModel<DBAffix> modelSuffix = new DefaultComboBoxModel<DBAffix>(arrSuffix);
        this.cbPrefix.setModel(modelPrefix);
        this.cbSuffix.setModel(modelSuffix);
    }

    public void clear() {
        this.cbPrefix.getModel().setSelectedItem(null);
        this.cbSuffix.getModel().setSelectedItem(null);
    }

    public void addCriteria(SelectionCriteria criteria) {
        DBAffix affix;
        int index = 0;
        criteria.prefixID = null;
        criteria.suffixID = null;
        index = this.cbPrefix.getSelectedIndex();
        if (index >= 0 && (affix = (DBAffix)this.cbPrefix.getSelectedItem()) != null) {
            criteria.prefixID = affix.getAffixID();
        }
        if ((index = this.cbSuffix.getSelectedIndex()) >= 0 && (affix = (DBAffix)this.cbSuffix.getSelectedItem()) != null) {
            criteria.suffixID = affix.getAffixID();
        }
    }

    static {
        AffixPane.loadAffixes();
    }
}

