/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.ui.select;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import org.gdstash.db.SelectionCriteria;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.ui.select.AffixRarityPane;
import org.gdstash.ui.select.AttribSelectionPane;
import org.gdstash.ui.select.DamageSelectionPane;
import org.gdstash.ui.util.AdjustablePanel;
import org.gdstash.util.GDMsgFormatter;

public class AffixSelectionPane
extends AdjustablePanel {
    private AffixRarityPane pnlRarity;
    private DamageSelectionPane pnlDamage;
    private AttribSelectionPane pnlAttrib;

    public AffixSelectionPane() {
        this.adjustUI();
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        JPanel pnlMain = this.buildMainPanel();
        JScrollPane scroll = new JScrollPane(pnlMain);
        scroll.getVerticalScrollBar().setUnitIncrement(2 * GDStashFrame.iniConfig.sectUI.fontSize);
        scroll.setWheelScrollingEnabled(true);
        layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(scroll));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(scroll));
        layout.setVerticalGroup(vGroup);
    }

    @Override
    public void adjustUI() {
        Font fntLabel = UIManager.getDefaults().getFont("Label.font");
        Font fntBorder = UIManager.getDefaults().getFont("TitledBorder.font");
        if (fntBorder == null) {
            fntBorder = fntLabel;
        }
        fntBorder = fntBorder.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        Border lowered = BorderFactory.createEtchedBorder(1);
        Border raised = BorderFactory.createEtchedBorder(0);
        CompoundBorder compound = BorderFactory.createCompoundBorder(raised, lowered);
        TitledBorder text = BorderFactory.createTitledBorder(compound, GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_AFFIX_INFO"));
        text.setTitleFont(fntBorder);
        this.setBorder(text);
        if (this.pnlRarity == null) {
            this.pnlRarity = new AffixRarityPane(0);
        } else {
            this.pnlRarity.adjustUI();
        }
        if (this.pnlDamage == null) {
            this.pnlDamage = new DamageSelectionPane();
        } else {
            this.pnlDamage.adjustUI();
        }
        if (this.pnlAttrib == null) {
            this.pnlAttrib = new AttribSelectionPane();
        } else {
            this.pnlAttrib.adjustUI();
        }
    }

    private JPanel buildMainPanel() {
        JPanel panel = new JPanel();
        BorderLayout layout = new BorderLayout();
        JPanel pnlDmgAttrib = this.buildDamageAttribPanel();
        panel.setLayout(layout);
        panel.add((Component)this.pnlRarity, "North");
        panel.add((Component)pnlDmgAttrib, "Center");
        return panel;
    }

    private JPanel buildDamageAttribPanel() {
        JPanel panel = new JPanel();
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setAutoCreateGaps(false);
        layout.setAutoCreateContainerGaps(false);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(this.pnlDamage)).addGroup(layout.createParallelGroup().addComponent(this.pnlAttrib));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(this.pnlDamage).addComponent(this.pnlAttrib));
        layout.setVerticalGroup(vGroup);
        layout.linkSize(1, this.pnlDamage, this.pnlAttrib);
        return panel;
    }

    public void clear() {
        this.pnlRarity.clear();
        this.pnlDamage.clear();
        this.pnlAttrib.clear();
    }

    public void addCriteria(SelectionCriteria criteria) {
        this.pnlRarity.addCriteria(criteria);
        this.pnlDamage.addCriteria(criteria);
        this.pnlAttrib.addCriteria(criteria);
        criteria.selMode = SelectionCriteria.SELECTION_MODE_AFFIX;
    }
}

