/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.ui.select;

import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import org.gdstash.db.SelectionCriteria;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.ui.util.AdjustablePanel;
import org.gdstash.util.GDMsgFormatter;

public class ArmorClassPane
extends AdjustablePanel {
    private JCheckBox cbCaster;
    private JCheckBox cbLight;
    private JCheckBox cbHeavy;

    public ArmorClassPane(int direction) {
        this.adjustUI();
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(this.cbCaster).addComponent(this.cbLight).addComponent(this.cbHeavy));
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(this.cbCaster)).addGroup(layout.createParallelGroup().addComponent(this.cbLight)).addGroup(layout.createParallelGroup().addComponent(this.cbHeavy));
        if (direction == 0) {
            layout.setHorizontalGroup(vGroup);
            layout.setVerticalGroup(hGroup);
        } else {
            layout.setHorizontalGroup(hGroup);
            layout.setVerticalGroup(vGroup);
        }
        layout.linkSize(0, this.cbCaster, this.cbLight);
        layout.linkSize(0, this.cbCaster, this.cbHeavy);
        layout.linkSize(1, this.cbCaster, this.cbLight);
        layout.linkSize(1, this.cbCaster, this.cbHeavy);
    }

    @Override
    public void adjustUI() {
        Font fntBorder;
        Font fntLabel = UIManager.getDefaults().getFont("Label.font");
        Font fntCheck = UIManager.getDefaults().getFont("CheckBox.font");
        if (fntCheck == null) {
            fntCheck = fntLabel;
        }
        if ((fntBorder = UIManager.getDefaults().getFont("TitledBorder.font")) == null) {
            fntBorder = fntLabel;
        }
        fntLabel = fntLabel.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntCheck = fntCheck.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntBorder = fntBorder.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        Border lowered = BorderFactory.createEtchedBorder(1);
        Border raised = BorderFactory.createEtchedBorder(0);
        CompoundBorder compound = BorderFactory.createCompoundBorder(raised, lowered);
        TitledBorder text = BorderFactory.createTitledBorder(compound, GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_ARMOR_CLASS"));
        text.setTitleFont(fntBorder);
        this.setBorder(text);
        if (this.cbCaster == null) {
            this.cbCaster = new JCheckBox();
        }
        this.cbCaster.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "ARMOR_CLASS_CASTER"));
        this.cbCaster.setFont(fntCheck);
        if (this.cbLight == null) {
            this.cbLight = new JCheckBox();
        }
        this.cbLight.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "ARMOR_CLASS_LIGHT"));
        this.cbLight.setFont(fntCheck);
        if (this.cbHeavy == null) {
            this.cbHeavy = new JCheckBox();
        }
        this.cbHeavy.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "ARMOR_CLASS_HEAVY"));
        this.cbHeavy.setFont(fntCheck);
    }

    public void clear() {
        this.cbCaster.setSelected(false);
        this.cbLight.setSelected(false);
        this.cbHeavy.setSelected(false);
    }

    public void addCriteria(SelectionCriteria criteria) {
        if (this.cbCaster.isSelected()) {
            criteria.armorClass.add("Caster");
        }
        if (this.cbLight.isSelected()) {
            criteria.armorClass.add("Light");
        }
        if (this.cbHeavy.isSelected()) {
            criteria.armorClass.add("Heavy");
        }
    }
}

