/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.ui.select;

import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import org.gdstash.db.SelectionCriteria;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.ui.select.DamageConversionPane;
import org.gdstash.ui.util.AdjustablePanel;
import org.gdstash.util.GDMsgFormatter;

public class AttribPercPane
extends AdjustablePanel {
    private JCheckBox cbPhysique;
    private JCheckBox cbCunning;
    private JCheckBox cbSpirit;
    private JCheckBox cbDefense;
    private JCheckBox cbOffense;
    private JCheckBox cbHealth;
    private JCheckBox cbHealthRegen;
    private JCheckBox cbEnergyRegen;
    private JCheckBox cbXPBonus;
    private JCheckBox cbAttackSpeed;
    private JCheckBox cbCastSpeed;
    private JCheckBox cbRunSpeed;
    private JCheckBox cbTotalSpeed;
    private JCheckBox cbCooldown;
    private JCheckBox cbShieldRecovery;
    private JCheckBox cbAvoidMelee;
    private JCheckBox cbAvoidProjectile;
    private DamageConversionPane pnlDmgConversion;

    public AttribPercPane(int direction) {
        this.adjustUI();
        JPanel pnlMain = this.buildMainPanel(direction);
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateGaps(false);
        layout.setAutoCreateContainerGaps(false);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(pnlMain).addComponent(this.pnlDmgConversion));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(pnlMain)).addGroup(layout.createParallelGroup().addComponent(this.pnlDmgConversion));
        layout.setVerticalGroup(vGroup);
        layout.linkSize(0, pnlMain, this.pnlDmgConversion);
    }

    @Override
    public void adjustUI() {
        Font fntBorder;
        Font fntLabel = UIManager.getDefaults().getFont("Label.font");
        Font fntCheck = UIManager.getDefaults().getFont("CheckBox.font");
        if (fntCheck == null) {
            fntCheck = fntLabel;
        }
        if ((fntBorder = UIManager.getDefaults().getFont("TitledBorder.font")) == null) {
            fntBorder = fntLabel;
        }
        fntLabel = fntLabel.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntCheck = fntCheck.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntBorder = fntBorder.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        Border lowered = BorderFactory.createEtchedBorder(1);
        Border raised = BorderFactory.createEtchedBorder(0);
        CompoundBorder compound = BorderFactory.createCompoundBorder(raised, lowered);
        TitledBorder text = BorderFactory.createTitledBorder(compound, GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_ATTRIB_PERC"));
        text.setTitleFont(fntBorder);
        this.setBorder(text);
        if (this.cbPhysique == null) {
            this.cbPhysique = new JCheckBox();
        }
        this.cbPhysique.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "STAT_PHYSIQUE"));
        this.cbPhysique.setFont(fntCheck);
        if (this.cbCunning == null) {
            this.cbCunning = new JCheckBox();
        }
        this.cbCunning.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "STAT_CUNNING"));
        this.cbCunning.setFont(fntCheck);
        if (this.cbSpirit == null) {
            this.cbSpirit = new JCheckBox();
        }
        this.cbSpirit.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "STAT_SPIRIT"));
        this.cbSpirit.setFont(fntCheck);
        if (this.cbDefense == null) {
            this.cbDefense = new JCheckBox();
        }
        this.cbDefense.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "STAT_DEF_ABIL"));
        this.cbDefense.setFont(fntCheck);
        if (this.cbOffense == null) {
            this.cbOffense = new JCheckBox();
        }
        this.cbOffense.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "STAT_OFF_ABIL"));
        this.cbOffense.setFont(fntCheck);
        if (this.cbHealth == null) {
            this.cbHealth = new JCheckBox();
        }
        this.cbHealth.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "STAT_HEALTH"));
        this.cbHealth.setFont(fntCheck);
        if (this.cbHealthRegen == null) {
            this.cbHealthRegen = new JCheckBox();
        }
        this.cbHealthRegen.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "STAT_REGEN_HEALTH"));
        this.cbHealthRegen.setFont(fntCheck);
        if (this.cbEnergyRegen == null) {
            this.cbEnergyRegen = new JCheckBox();
        }
        this.cbEnergyRegen.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "STAT_REGEN_ENERGY"));
        this.cbEnergyRegen.setFont(fntCheck);
        if (this.cbXPBonus == null) {
            this.cbXPBonus = new JCheckBox();
        }
        this.cbXPBonus.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "STAT_XP_BONUS"));
        this.cbXPBonus.setFont(fntCheck);
        if (this.cbAttackSpeed == null) {
            this.cbAttackSpeed = new JCheckBox();
        }
        this.cbAttackSpeed.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "STAT_SPEED_ATTACK"));
        this.cbAttackSpeed.setFont(fntCheck);
        if (this.cbCastSpeed == null) {
            this.cbCastSpeed = new JCheckBox();
        }
        this.cbCastSpeed.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "STAT_SPEED_CAST"));
        this.cbCastSpeed.setFont(fntCheck);
        if (this.cbRunSpeed == null) {
            this.cbRunSpeed = new JCheckBox();
        }
        this.cbRunSpeed.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "STAT_SPEED_RUN"));
        this.cbRunSpeed.setFont(fntCheck);
        if (this.cbTotalSpeed == null) {
            this.cbTotalSpeed = new JCheckBox();
        }
        this.cbTotalSpeed.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "STAT_SPEED_TOTAL"));
        this.cbTotalSpeed.setFont(fntCheck);
        if (this.cbCooldown == null) {
            this.cbCooldown = new JCheckBox();
        }
        this.cbCooldown.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "STAT_COOLDOWN_REDUCTION"));
        this.cbCooldown.setFont(fntCheck);
        if (this.cbShieldRecovery == null) {
            this.cbShieldRecovery = new JCheckBox();
        }
        this.cbShieldRecovery.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "STAT_SHIELD_RECOVERY_RED"));
        this.cbShieldRecovery.setFont(fntCheck);
        if (this.cbAvoidMelee == null) {
            this.cbAvoidMelee = new JCheckBox();
        }
        this.cbAvoidMelee.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "STAT_AVOID_MELEE"));
        this.cbAvoidMelee.setFont(fntCheck);
        if (this.cbAvoidProjectile == null) {
            this.cbAvoidProjectile = new JCheckBox();
        }
        this.cbAvoidProjectile.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "STAT_AVOID_PROJECTILE"));
        this.cbAvoidProjectile.setFont(fntCheck);
        if (this.pnlDmgConversion == null) {
            this.pnlDmgConversion = new DamageConversionPane();
        } else {
            this.pnlDmgConversion.adjustUI();
        }
    }

    private JPanel buildMainPanel(int direction) {
        JPanel panel = new JPanel();
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        JPanel pnlLeft = this.buildLeftSidePanel(direction);
        JPanel pnlRight = this.buildRightSidePanel(direction);
        layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setAutoCreateGaps(false);
        layout.setAutoCreateContainerGaps(false);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(pnlLeft)).addGroup(layout.createParallelGroup().addComponent(pnlRight));
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(pnlLeft).addComponent(pnlRight));
        if (direction == 0) {
            layout.setHorizontalGroup(vGroup);
            layout.setVerticalGroup(hGroup);
        } else {
            layout.setHorizontalGroup(hGroup);
            layout.setVerticalGroup(vGroup);
        }
        layout.linkSize(1, pnlLeft, pnlRight);
        return panel;
    }

    private JPanel buildLeftSidePanel(int direction) {
        JPanel panel = new JPanel();
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(this.cbPhysique).addComponent(this.cbCunning).addComponent(this.cbSpirit).addComponent(this.cbDefense).addComponent(this.cbOffense).addComponent(this.cbHealth).addComponent(this.cbHealthRegen).addComponent(this.cbEnergyRegen));
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(this.cbPhysique)).addGroup(layout.createParallelGroup().addComponent(this.cbCunning)).addGroup(layout.createParallelGroup().addComponent(this.cbSpirit)).addGroup(layout.createParallelGroup().addComponent(this.cbDefense)).addGroup(layout.createParallelGroup().addComponent(this.cbOffense)).addGroup(layout.createParallelGroup().addComponent(this.cbHealth)).addGroup(layout.createParallelGroup().addComponent(this.cbHealthRegen)).addGroup(layout.createParallelGroup().addComponent(this.cbEnergyRegen));
        if (direction == 0) {
            layout.setHorizontalGroup(vGroup);
            layout.setVerticalGroup(hGroup);
        } else {
            layout.setHorizontalGroup(hGroup);
            layout.setVerticalGroup(vGroup);
        }
        layout.linkSize(0, this.cbPhysique, this.cbCunning);
        layout.linkSize(0, this.cbPhysique, this.cbSpirit);
        layout.linkSize(0, this.cbPhysique, this.cbDefense);
        layout.linkSize(0, this.cbPhysique, this.cbOffense);
        layout.linkSize(0, this.cbPhysique, this.cbHealth);
        layout.linkSize(0, this.cbPhysique, this.cbHealthRegen);
        layout.linkSize(0, this.cbPhysique, this.cbEnergyRegen);
        layout.linkSize(1, this.cbPhysique, this.cbCunning);
        layout.linkSize(1, this.cbPhysique, this.cbSpirit);
        layout.linkSize(1, this.cbPhysique, this.cbDefense);
        layout.linkSize(1, this.cbPhysique, this.cbOffense);
        layout.linkSize(1, this.cbPhysique, this.cbHealth);
        layout.linkSize(1, this.cbPhysique, this.cbHealthRegen);
        layout.linkSize(1, this.cbPhysique, this.cbEnergyRegen);
        return panel;
    }

    private JPanel buildRightSidePanel(int direction) {
        JPanel panel = new JPanel();
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(this.cbXPBonus).addComponent(this.cbAttackSpeed).addComponent(this.cbCastSpeed).addComponent(this.cbRunSpeed).addComponent(this.cbTotalSpeed).addComponent(this.cbCooldown).addComponent(this.cbShieldRecovery).addComponent(this.cbAvoidMelee).addComponent(this.cbAvoidProjectile));
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(this.cbXPBonus)).addGroup(layout.createParallelGroup().addComponent(this.cbAttackSpeed)).addGroup(layout.createParallelGroup().addComponent(this.cbCastSpeed)).addGroup(layout.createParallelGroup().addComponent(this.cbRunSpeed)).addGroup(layout.createParallelGroup().addComponent(this.cbTotalSpeed)).addGroup(layout.createParallelGroup().addComponent(this.cbCooldown)).addGroup(layout.createParallelGroup().addComponent(this.cbShieldRecovery)).addGroup(layout.createParallelGroup().addComponent(this.cbAvoidMelee)).addGroup(layout.createParallelGroup().addComponent(this.cbAvoidProjectile));
        if (direction == 0) {
            layout.setHorizontalGroup(vGroup);
            layout.setVerticalGroup(hGroup);
        } else {
            layout.setHorizontalGroup(hGroup);
            layout.setVerticalGroup(vGroup);
        }
        layout.linkSize(0, this.cbXPBonus, this.cbAttackSpeed);
        layout.linkSize(0, this.cbXPBonus, this.cbCastSpeed);
        layout.linkSize(0, this.cbXPBonus, this.cbRunSpeed);
        layout.linkSize(0, this.cbXPBonus, this.cbTotalSpeed);
        layout.linkSize(0, this.cbXPBonus, this.cbCooldown);
        layout.linkSize(0, this.cbXPBonus, this.cbShieldRecovery);
        layout.linkSize(0, this.cbXPBonus, this.cbAvoidMelee);
        layout.linkSize(0, this.cbXPBonus, this.cbAvoidProjectile);
        layout.linkSize(1, this.cbXPBonus, this.cbAttackSpeed);
        layout.linkSize(1, this.cbXPBonus, this.cbCastSpeed);
        layout.linkSize(1, this.cbXPBonus, this.cbRunSpeed);
        layout.linkSize(1, this.cbXPBonus, this.cbTotalSpeed);
        layout.linkSize(1, this.cbXPBonus, this.cbCooldown);
        layout.linkSize(1, this.cbXPBonus, this.cbShieldRecovery);
        layout.linkSize(1, this.cbXPBonus, this.cbAvoidMelee);
        layout.linkSize(1, this.cbXPBonus, this.cbAvoidProjectile);
        return panel;
    }

    public void clear() {
        this.cbPhysique.setSelected(false);
        this.cbCunning.setSelected(false);
        this.cbSpirit.setSelected(false);
        this.cbDefense.setSelected(false);
        this.cbOffense.setSelected(false);
        this.cbHealth.setSelected(false);
        this.cbHealthRegen.setSelected(false);
        this.cbEnergyRegen.setSelected(false);
        this.cbXPBonus.setSelected(false);
        this.cbAttackSpeed.setSelected(false);
        this.cbCastSpeed.setSelected(false);
        this.cbRunSpeed.setSelected(false);
        this.cbTotalSpeed.setSelected(false);
        this.cbCooldown.setSelected(false);
        this.cbShieldRecovery.setSelected(false);
        this.cbAvoidMelee.setSelected(false);
        this.cbAvoidProjectile.setSelected(false);
        this.pnlDmgConversion.clear();
    }

    public void addCriteria(SelectionCriteria criteria) {
        SelectionCriteria.StatInfo info = null;
        if (this.cbPhysique.isSelected()) {
            info = new SelectionCriteria.StatInfo();
            info.statType = "characterStrength";
            info.percentage = true;
            criteria.statInfos.add(info);
        }
        if (this.cbCunning.isSelected()) {
            info = new SelectionCriteria.StatInfo();
            info.statType = "characterDexterity";
            info.percentage = true;
            criteria.statInfos.add(info);
        }
        if (this.cbSpirit.isSelected()) {
            info = new SelectionCriteria.StatInfo();
            info.statType = "characterIntelligence";
            info.percentage = true;
            criteria.statInfos.add(info);
        }
        if (this.cbDefense.isSelected()) {
            info = new SelectionCriteria.StatInfo();
            info.statType = "characterDefensiveAbility";
            info.percentage = true;
            criteria.statInfos.add(info);
        }
        if (this.cbOffense.isSelected()) {
            info = new SelectionCriteria.StatInfo();
            info.statType = "characterOffensiveAbility";
            info.percentage = true;
            criteria.statInfos.add(info);
        }
        if (this.cbHealth.isSelected()) {
            info = new SelectionCriteria.StatInfo();
            info.statType = "characterLife";
            info.percentage = true;
            criteria.statInfos.add(info);
        }
        if (this.cbHealthRegen.isSelected()) {
            info = new SelectionCriteria.StatInfo();
            info.statType = "characterLifeRegen";
            info.percentage = true;
            criteria.statInfos.add(info);
        }
        if (this.cbEnergyRegen.isSelected()) {
            info = new SelectionCriteria.StatInfo();
            info.statType = "characterManaRegen";
            info.percentage = true;
            criteria.statInfos.add(info);
        }
        if (this.cbXPBonus.isSelected()) {
            info = new SelectionCriteria.StatInfo();
            info.statType = "characterIncreasedExperience";
            info.flat = true;
            criteria.statInfos.add(info);
        }
        if (this.cbAttackSpeed.isSelected()) {
            info = new SelectionCriteria.StatInfo();
            info.statType = "characterAttackSpeed";
            info.percentage = true;
            criteria.statInfos.add(info);
        }
        if (this.cbCastSpeed.isSelected()) {
            info = new SelectionCriteria.StatInfo();
            info.statType = "characterSpellCastSpeed";
            info.percentage = true;
            criteria.statInfos.add(info);
        }
        if (this.cbRunSpeed.isSelected()) {
            info = new SelectionCriteria.StatInfo();
            info.statType = "characterRunSpeed";
            info.percentage = true;
            criteria.statInfos.add(info);
        }
        if (this.cbTotalSpeed.isSelected()) {
            info = new SelectionCriteria.StatInfo();
            info.statType = "characterTotalSpeed";
            info.percentage = true;
            criteria.statInfos.add(info);
        }
        if (this.cbCooldown.isSelected()) {
            info = new SelectionCriteria.StatInfo();
            info.statType = "skillCooldownReduction";
            info.flat = true;
            criteria.statInfos.add(info);
        }
        if (this.cbShieldRecovery.isSelected()) {
            info = new SelectionCriteria.StatInfo();
            info.statType = "characterDefensiveBlockRecoveryReduction";
            info.flat = true;
            criteria.statInfos.add(info);
        }
        if (this.cbAvoidMelee.isSelected()) {
            info = new SelectionCriteria.StatInfo();
            info.statType = "characterDodgePercent";
            info.flat = true;
            criteria.statInfos.add(info);
        }
        if (this.cbAvoidProjectile.isSelected()) {
            info = new SelectionCriteria.StatInfo();
            info.statType = "characterDeflectProjectile";
            info.flat = true;
            criteria.statInfos.add(info);
        }
        this.pnlDmgConversion.addCriteria(criteria);
    }
}

