/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.ui.select;

import java.awt.Toolkit;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;

public class CharLenDocFilter
extends DocumentFilter {
    private int maxLen;

    public CharLenDocFilter(int len) {
        this.maxLen = len;
    }

    @Override
    public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) {
        if (this.accept(fb, offset, string)) {
            try {
                super.insertString(fb, offset, string, attr);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    @Override
    public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) {
        if (this.accept(fb, offset, text)) {
            try {
                super.replace(fb, offset, length, text, attrs);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    protected boolean accept(DocumentFilter.FilterBypass fb, int offset, String str) {
        if (str == null) {
            return true;
        }
        int strLen = str.length();
        int textLen = fb.getDocument().getLength();
        boolean valid = false;
        if (strLen + textLen <= this.maxLen) {
            valid = true;
        }
        if (!valid) {
            Toolkit.getDefaultToolkit().beep();
        }
        return valid;
    }
}

