/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.ui.select;

import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import org.gdstash.db.SelectionCriteria;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.ui.util.AdjustablePanel;
import org.gdstash.util.GDMsgFormatter;

public class DamageClassPane
extends AdjustablePanel {
    private JCheckBox cbOffense;
    private JCheckBox cbDefense;
    private JCheckBox cbRetal;

    public DamageClassPane(int direction) {
        this.adjustUI();
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(this.cbOffense).addComponent(this.cbDefense).addComponent(this.cbRetal));
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(this.cbOffense)).addGroup(layout.createParallelGroup().addComponent(this.cbDefense)).addGroup(layout.createParallelGroup().addComponent(this.cbRetal));
        if (direction == 0) {
            layout.setHorizontalGroup(vGroup);
            layout.setVerticalGroup(hGroup);
        } else {
            layout.setHorizontalGroup(hGroup);
            layout.setVerticalGroup(vGroup);
        }
        layout.linkSize(0, this.cbOffense, this.cbDefense);
        layout.linkSize(0, this.cbOffense, this.cbRetal);
        layout.linkSize(1, this.cbOffense, this.cbDefense);
        layout.linkSize(1, this.cbOffense, this.cbRetal);
    }

    @Override
    public void adjustUI() {
        Font fntBorder;
        Font fntLabel = UIManager.getDefaults().getFont("Label.font");
        Font fntCheck = UIManager.getDefaults().getFont("CheckBox.font");
        if (fntCheck == null) {
            fntCheck = fntLabel;
        }
        if ((fntBorder = UIManager.getDefaults().getFont("TitledBorder.font")) == null) {
            fntBorder = fntLabel;
        }
        fntLabel = fntLabel.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntCheck = fntCheck.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntBorder = fntBorder.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        Border lowered = BorderFactory.createEtchedBorder(1);
        Border raised = BorderFactory.createEtchedBorder(0);
        CompoundBorder compound = BorderFactory.createCompoundBorder(raised, lowered);
        TitledBorder text = BorderFactory.createTitledBorder(compound, GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_DMG_OFF_DEF_RET"));
        text.setTitleFont(fntBorder);
        this.setBorder(text);
        if (this.cbOffense == null) {
            this.cbOffense = new JCheckBox();
        }
        this.cbOffense.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_DMG_OFFENSIVE"));
        this.cbOffense.setFont(fntCheck);
        if (this.cbDefense == null) {
            this.cbDefense = new JCheckBox();
        }
        this.cbDefense.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_DMG_DEFENSIVE"));
        this.cbDefense.setFont(fntCheck);
        if (this.cbRetal == null) {
            this.cbRetal = new JCheckBox();
        }
        this.cbRetal.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_DMG_RETALIATION"));
        this.cbRetal.setFont(fntCheck);
    }

    public void clear() {
        this.cbOffense.setSelected(false);
        this.cbDefense.setSelected(false);
        this.cbRetal.setSelected(false);
    }

    public void addCriteria(SelectionCriteria criteria) {
        criteria.dmgClassInfo.offense = this.cbOffense.isSelected();
        criteria.dmgClassInfo.defense = this.cbDefense.isSelected();
        criteria.dmgClassInfo.retaliation = this.cbRetal.isSelected();
    }
}

