/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.ui.select;

import java.awt.Dimension;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import org.gdstash.db.SelectionCriteria;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.ui.util.AdjustablePanel;
import org.gdstash.util.GDMsgFormatter;

public class DamageConversionPane
extends AdjustablePanel {
    private static String[] dmgTypes = new String[10];
    private JComboBox<String> cbDmgConversionTo;

    private static void loadCBText() {
        DamageConversionPane.dmgTypes[0] = "";
        DamageConversionPane.dmgTypes[1] = GDMsgFormatter.getString(GDMsgFormatter.rbGD, "OFF_POISON");
        DamageConversionPane.dmgTypes[2] = GDMsgFormatter.getString(GDMsgFormatter.rbGD, "OFF_AETHER");
        DamageConversionPane.dmgTypes[3] = GDMsgFormatter.getString(GDMsgFormatter.rbGD, "OFF_CHAOS");
        DamageConversionPane.dmgTypes[4] = GDMsgFormatter.getString(GDMsgFormatter.rbGD, "OFF_COLD");
        DamageConversionPane.dmgTypes[5] = GDMsgFormatter.getString(GDMsgFormatter.rbGD, "OFF_ELEMENTAL");
        DamageConversionPane.dmgTypes[6] = GDMsgFormatter.getString(GDMsgFormatter.rbGD, "OFF_FIRE");
        DamageConversionPane.dmgTypes[7] = GDMsgFormatter.getString(GDMsgFormatter.rbGD, "OFF_LIGHTNING");
        DamageConversionPane.dmgTypes[8] = GDMsgFormatter.getString(GDMsgFormatter.rbGD, "OFF_PHYSICAL");
        DamageConversionPane.dmgTypes[9] = GDMsgFormatter.getString(GDMsgFormatter.rbGD, "OFF_LIFE");
    }

    public DamageConversionPane() {
        this.adjustUI();
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateGaps(false);
        layout.setAutoCreateContainerGaps(false);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(this.cbDmgConversionTo));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(this.cbDmgConversionTo));
        layout.setVerticalGroup(vGroup);
    }

    @Override
    public void adjustUI() {
        Font fntBorder;
        int size = 12;
        if (GDStashFrame.iniConfig != null) {
            size = GDStashFrame.iniConfig.sectUI.fontSize;
        }
        Dimension dimMax = new Dimension(60 * size, 2 * size);
        Font fntLabel = UIManager.getDefaults().getFont("Label.font");
        Font fntCombo = UIManager.getDefaults().getFont("ComboBox.font");
        if (fntCombo == null) {
            fntCombo = fntLabel;
        }
        if ((fntBorder = UIManager.getDefaults().getFont("TitledBorder.font")) == null) {
            fntBorder = fntLabel;
        }
        fntLabel = fntLabel.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntCombo = fntCombo.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntBorder = fntBorder.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        Border lowered = BorderFactory.createEtchedBorder(1);
        Border raised = BorderFactory.createEtchedBorder(0);
        CompoundBorder compound = BorderFactory.createCompoundBorder(raised, lowered);
        TitledBorder text = BorderFactory.createTitledBorder(compound, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "TXT_DAMAGE_CONVERSION"));
        text.setTitleFont(fntBorder);
        this.setBorder(text);
        DamageConversionPane.loadCBText();
        if (this.cbDmgConversionTo == null) {
            this.cbDmgConversionTo = new JComboBox<String>(dmgTypes);
        } else {
            this.updateLanguage(this.cbDmgConversionTo);
        }
        this.cbDmgConversionTo.setFont(fntCombo);
    }

    private void updateLanguage(JComboBox<String> cb) {
        String[] texts = null;
        if (cb == this.cbDmgConversionTo) {
            texts = dmgTypes;
        }
        if (texts != null) {
            int index = cb.getSelectedIndex();
            cb.removeAllItems();
            for (int i = 0; i < texts.length; ++i) {
                cb.addItem(texts[i]);
            }
            cb.setSelectedIndex(index);
        }
    }

    public void clear() {
        this.cbDmgConversionTo.setSelectedIndex(0);
    }

    public void addCriteria(SelectionCriteria criteria) {
        int index = this.cbDmgConversionTo.getSelectedIndex();
        String dmgType = null;
        switch (index) {
            case 1: {
                dmgType = "Poison";
                break;
            }
            case 2: {
                dmgType = "Aether";
                break;
            }
            case 3: {
                dmgType = "Chaos";
                break;
            }
            case 4: {
                dmgType = "Cold";
                break;
            }
            case 5: {
                dmgType = "Elemental";
                break;
            }
            case 6: {
                dmgType = "Fire";
                break;
            }
            case 7: {
                dmgType = "Lightning";
                break;
            }
            case 8: {
                dmgType = "Physical";
                break;
            }
            case 9: {
                dmgType = "Life";
            }
        }
        criteria.dmgConversionTo = dmgType;
    }

    static {
        DamageConversionPane.loadCBText();
    }
}

