/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.ui.select;

import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import org.gdstash.db.SelectionCriteria;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.ui.util.AdjustablePanel;
import org.gdstash.util.GDMsgFormatter;

public class DamageFlatPercPane
extends AdjustablePanel {
    private JCheckBox cbFlat;
    private JCheckBox cbPerc;
    private JCheckBox cbIncMaxRes;

    public DamageFlatPercPane(int direction) {
        this.adjustUI();
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(this.cbFlat).addComponent(this.cbPerc).addComponent(this.cbIncMaxRes));
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(this.cbFlat)).addGroup(layout.createParallelGroup().addComponent(this.cbPerc)).addGroup(layout.createParallelGroup().addComponent(this.cbIncMaxRes));
        if (direction == 0) {
            layout.setHorizontalGroup(vGroup);
            layout.setVerticalGroup(hGroup);
        } else {
            layout.setHorizontalGroup(hGroup);
            layout.setVerticalGroup(vGroup);
        }
        layout.linkSize(0, this.cbFlat, this.cbPerc);
        layout.linkSize(0, this.cbFlat, this.cbIncMaxRes);
        layout.linkSize(1, this.cbFlat, this.cbPerc);
        layout.linkSize(1, this.cbFlat, this.cbIncMaxRes);
    }

    @Override
    public void adjustUI() {
        Font fntBorder;
        Font fntLabel = UIManager.getDefaults().getFont("Label.font");
        Font fntCheck = UIManager.getDefaults().getFont("CheckBox.font");
        if (fntCheck == null) {
            fntCheck = fntLabel;
        }
        if ((fntBorder = UIManager.getDefaults().getFont("TitledBorder.font")) == null) {
            fntBorder = fntLabel;
        }
        fntLabel = fntLabel.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntCheck = fntCheck.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntBorder = fntBorder.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        Border lowered = BorderFactory.createEtchedBorder(1);
        Border raised = BorderFactory.createEtchedBorder(0);
        CompoundBorder compound = BorderFactory.createCompoundBorder(raised, lowered);
        TitledBorder text = BorderFactory.createTitledBorder(compound, GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_DAMAGE"));
        text.setTitleFont(fntBorder);
        this.setBorder(text);
        if (this.cbFlat == null) {
            this.cbFlat = new JCheckBox();
        }
        this.cbFlat.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "DAMAGE_FLAT"));
        this.cbFlat.setFont(fntCheck);
        if (this.cbPerc == null) {
            this.cbPerc = new JCheckBox();
        }
        this.cbPerc.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "DAMAGE_PERCENT"));
        this.cbPerc.setFont(fntCheck);
        if (this.cbIncMaxRes == null) {
            this.cbIncMaxRes = new JCheckBox();
        }
        this.cbIncMaxRes.setText(GDMsgFormatter.getString(GDMsgFormatter.rbGD, "DAMAGE_INC_MAX_RES"));
        this.cbIncMaxRes.setFont(fntCheck);
    }

    public void clear() {
        this.cbFlat.setSelected(false);
        this.cbPerc.setSelected(false);
        this.cbIncMaxRes.setSelected(false);
    }

    public void addCriteria(SelectionCriteria criteria) {
        criteria.fieldInfo.flat = this.cbFlat.isSelected();
        criteria.fieldInfo.percentage = this.cbPerc.isSelected();
        criteria.fieldInfo.maxResist = this.cbIncMaxRes.isSelected();
    }
}

