/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.ui.select;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.gdstash.db.SelectionCriteria;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.ui.select.AffixPane;
import org.gdstash.ui.select.AttribSelectionPane;
import org.gdstash.ui.select.DamageSelectionPane;
import org.gdstash.ui.select.ItemFullSelectionPane;
import org.gdstash.ui.select.ItemSkillPane;
import org.gdstash.ui.select.SkillBonusPane;
import org.gdstash.ui.select.SlotSelectionPane;
import org.gdstash.ui.util.AdjustablePanel;

public class FullSelectionPane
extends AdjustablePanel {
    private ItemFullSelectionPane pnlItem;
    private SlotSelectionPane pnlSlot;
    private DamageSelectionPane pnlDamage;
    private AttribSelectionPane pnlAttrib;
    private SkillBonusPane pnlBonusSkill;
    private ItemSkillPane pnlItemSkill;
    private AffixPane pnlAffix;

    public FullSelectionPane() {
        this.adjustUI();
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        JPanel pnlMain = this.buildMainPanel();
        JScrollPane scroll = new JScrollPane(pnlMain);
        scroll.getVerticalScrollBar().setUnitIncrement(2 * GDStashFrame.iniConfig.sectUI.fontSize);
        scroll.setWheelScrollingEnabled(true);
        layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(scroll));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(scroll));
        layout.setVerticalGroup(vGroup);
    }

    @Override
    public void adjustUI() {
        Font fntLabel = UIManager.getDefaults().getFont("Label.font");
        fntLabel = fntLabel.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        Border lowered = BorderFactory.createEtchedBorder(1);
        Border raised = BorderFactory.createEtchedBorder(0);
        CompoundBorder compound = BorderFactory.createCompoundBorder(raised, lowered);
        this.setBorder(compound);
        if (this.pnlItem == null) {
            this.pnlItem = new ItemFullSelectionPane();
        } else {
            this.pnlItem.adjustUI();
        }
        if (this.pnlSlot == null) {
            this.pnlSlot = new SlotSelectionPane();
        } else {
            this.pnlSlot.adjustUI();
        }
        if (this.pnlDamage == null) {
            this.pnlDamage = new DamageSelectionPane();
        } else {
            this.pnlDamage.adjustUI();
        }
        if (this.pnlAttrib == null) {
            this.pnlAttrib = new AttribSelectionPane();
        } else {
            this.pnlAttrib.adjustUI();
        }
        if (this.pnlBonusSkill == null) {
            this.pnlBonusSkill = new SkillBonusPane();
        } else {
            this.pnlBonusSkill.adjustUI();
        }
        if (this.pnlItemSkill == null) {
            this.pnlItemSkill = new ItemSkillPane();
        } else {
            this.pnlItemSkill.adjustUI();
        }
        if (this.pnlAffix == null) {
            this.pnlAffix = new AffixPane();
        } else {
            this.pnlAffix.adjustUI();
        }
    }

    private JPanel buildMainPanel() {
        JPanel panel = new JPanel();
        BorderLayout layout = new BorderLayout();
        JPanel pnlDmgAttrib = this.buildDamageAttribPanel();
        panel.setLayout(layout);
        panel.add((Component)this.pnlItem, "West");
        panel.add((Component)this.pnlSlot, "Center");
        panel.add((Component)pnlDmgAttrib, "East");
        return panel;
    }

    private JPanel buildDamageAttribPanel() {
        JPanel panel = new JPanel();
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setAutoCreateGaps(false);
        layout.setAutoCreateContainerGaps(false);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(this.pnlDamage).addComponent(this.pnlAttrib).addComponent(this.pnlBonusSkill).addComponent(this.pnlItemSkill).addComponent(this.pnlAffix));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(this.pnlDamage)).addGroup(layout.createParallelGroup().addComponent(this.pnlAttrib)).addGroup(layout.createParallelGroup().addComponent(this.pnlBonusSkill)).addGroup(layout.createParallelGroup().addComponent(this.pnlItemSkill)).addGroup(layout.createParallelGroup().addComponent(this.pnlAffix));
        layout.setVerticalGroup(vGroup);
        layout.linkSize(0, this.pnlDamage, this.pnlAttrib);
        layout.linkSize(0, this.pnlDamage, this.pnlBonusSkill);
        layout.linkSize(0, this.pnlDamage, this.pnlItemSkill);
        layout.linkSize(0, this.pnlDamage, this.pnlAffix);
        return panel;
    }

    public void updateConfig() {
        if (this.pnlItem != null) {
            this.pnlItem.updateItemSets();
        }
        if (this.pnlBonusSkill != null) {
            this.pnlBonusSkill.updateBonusSkills();
        }
        if (this.pnlItemSkill != null) {
            this.pnlItemSkill.updateItemSkills();
        }
        if (this.pnlAffix != null) {
            this.pnlAffix.updateAffixes();
        }
    }

    public void clear() {
        this.pnlItem.clear();
        this.pnlSlot.clear();
        this.pnlDamage.clear();
        this.pnlAttrib.clear();
        this.pnlBonusSkill.clear();
        this.pnlItemSkill.clear();
        this.pnlAffix.clear();
    }

    public void addCriteria(SelectionCriteria criteria) {
        criteria.selMode = SelectionCriteria.SELECTION_MODE_ITEM;
        this.pnlItem.addCriteria(criteria);
        this.pnlSlot.addCriteria(criteria);
        this.pnlDamage.addCriteria(criteria);
        this.pnlAttrib.addCriteria(criteria);
        this.pnlBonusSkill.addCriteria(criteria);
        this.pnlItemSkill.addCriteria(criteria);
        this.pnlAffix.addCriteria(criteria);
    }
}

