/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.ui.select;

import java.awt.Toolkit;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;

public class HexLenDocFilter
extends DocumentFilter {
    private int maxLen;

    public HexLenDocFilter(int len) {
        this.maxLen = len;
    }

    @Override
    public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) {
        if (this.accept(fb, offset, 0, string)) {
            try {
                super.insertString(fb, offset, string, attr);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    @Override
    public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) {
        if (this.accept(fb, offset, length, text)) {
            try {
                super.replace(fb, offset, length, text, attrs);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    protected boolean accept(DocumentFilter.FilterBypass fb, int offset, int length, String str) {
        if (str == null) {
            return true;
        }
        int strLen = str.length();
        int textLen = fb.getDocument().getLength();
        boolean valid = false;
        if (strLen + textLen - length <= this.maxLen && strLen + offset <= this.maxLen && this.isHex(str)) {
            valid = true;
        }
        if (!valid) {
            Toolkit.getDefaultToolkit().beep();
        }
        return valid;
    }

    public boolean isHex(String str) {
        boolean valid = true;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '0' || c == '1' || c == '2' || c == '3' || c == '4' || c == '5' || c == '6' || c == '7' || c == '8' || c == '9' || c == 'A' || c == 'B' || c == 'C' || c == 'D' || c == 'E' || c == 'F' || c == 'a' || c == 'b' || c == 'c' || c == 'd' || c == 'e' || c == 'f') continue;
            valid = false;
            break;
        }
        return valid;
    }
}

