/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.ui.select;

import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import org.gdstash.db.SelectionCriteria;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.ui.select.ArmorClassPane;
import org.gdstash.ui.select.ArtifactRarityPane;
import org.gdstash.ui.select.ItemNamePane;
import org.gdstash.ui.select.ItemRarityPane;
import org.gdstash.ui.select.ItemSetPane;
import org.gdstash.ui.select.ItemTypePane;
import org.gdstash.ui.select.StatReqPane;
import org.gdstash.ui.util.AdjustablePanel;
import org.gdstash.util.GDMsgFormatter;

public class ItemFullSelectionPane
extends AdjustablePanel {
    private ItemTypePane pnlItemTypes;
    private ItemSetPane pnlItemSet;
    private ItemNamePane pnlItemName;
    private ArmorClassPane pnlArmorClasses;
    private ItemRarityPane pnlItemRarity;
    private ArtifactRarityPane pnlArtifactRarity;
    private StatReqPane pnlStats;

    public ItemFullSelectionPane() {
        this.adjustUI();
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        JPanel pnlRarity = new JPanel();
        layout = new GroupLayout(pnlRarity);
        pnlRarity.setLayout(layout);
        layout.setAutoCreateGaps(false);
        layout.setAutoCreateContainerGaps(false);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(this.pnlItemSet).addComponent(this.pnlItemName).addComponent(this.pnlItemRarity).addComponent(this.pnlArtifactRarity).addComponent(this.pnlArmorClasses));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(this.pnlItemSet)).addGroup(layout.createParallelGroup().addComponent(this.pnlItemName)).addGroup(layout.createParallelGroup().addComponent(this.pnlItemRarity)).addGroup(layout.createParallelGroup().addComponent(this.pnlArtifactRarity)).addGroup(layout.createParallelGroup().addComponent(this.pnlArmorClasses));
        layout.setVerticalGroup(vGroup);
        layout.linkSize(0, this.pnlItemSet, this.pnlItemName);
        layout.linkSize(0, this.pnlItemSet, this.pnlItemRarity);
        layout.linkSize(0, this.pnlItemSet, this.pnlArtifactRarity);
        layout.linkSize(0, this.pnlItemSet, this.pnlArmorClasses);
        layout.linkSize(1, this.pnlItemSet, this.pnlItemTypes);
        layout.linkSize(1, this.pnlItemSet, this.pnlItemName);
        layout.linkSize(1, this.pnlItemSet, this.pnlArtifactRarity);
        layout.linkSize(1, this.pnlItemSet, this.pnlArmorClasses);
        layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateGaps(false);
        layout.setAutoCreateContainerGaps(false);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(this.pnlItemTypes).addComponent(pnlRarity).addComponent(this.pnlStats));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(this.pnlItemTypes)).addGroup(layout.createParallelGroup().addComponent(pnlRarity)).addGroup(layout.createParallelGroup().addComponent(this.pnlStats));
        layout.setVerticalGroup(vGroup);
        layout.linkSize(0, this.pnlItemTypes, pnlRarity);
        layout.linkSize(0, this.pnlItemTypes, this.pnlStats);
    }

    @Override
    public void adjustUI() {
        Font fntLabel = UIManager.getDefaults().getFont("Label.font");
        Font fntBorder = UIManager.getDefaults().getFont("TitledBorder.font");
        if (fntBorder == null) {
            fntBorder = fntLabel;
        }
        fntLabel = fntLabel.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntBorder = fntBorder.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        Border lowered = BorderFactory.createEtchedBorder(1);
        Border raised = BorderFactory.createEtchedBorder(0);
        CompoundBorder compound = BorderFactory.createCompoundBorder(raised, lowered);
        TitledBorder text = BorderFactory.createTitledBorder(compound, GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_ITEM_INFO"));
        text.setTitleFont(fntBorder);
        this.setBorder(text);
        if (this.pnlItemTypes == null) {
            this.pnlItemTypes = new ItemTypePane();
        } else {
            this.pnlItemTypes.adjustUI();
        }
        if (this.pnlItemSet == null) {
            this.pnlItemSet = new ItemSetPane();
        } else {
            this.pnlItemSet.adjustUI();
        }
        if (this.pnlItemName == null) {
            this.pnlItemName = new ItemNamePane();
        } else {
            this.pnlItemName.adjustUI();
        }
        if (this.pnlItemRarity == null) {
            this.pnlItemRarity = new ItemRarityPane(0);
        } else {
            this.pnlItemRarity.adjustUI();
        }
        if (this.pnlArtifactRarity == null) {
            this.pnlArtifactRarity = new ArtifactRarityPane(0);
        } else {
            this.pnlArtifactRarity.adjustUI();
        }
        if (this.pnlArmorClasses == null) {
            this.pnlArmorClasses = new ArmorClassPane(0);
        } else {
            this.pnlArmorClasses.adjustUI();
        }
        if (this.pnlStats == null) {
            this.pnlStats = new StatReqPane();
        } else {
            this.pnlStats.adjustUI();
        }
    }

    public void updateItemSets() {
        if (this.pnlItemSet != null) {
            this.pnlItemSet.updateItemSets();
        }
    }

    public void clear() {
        this.pnlItemTypes.clear();
        this.pnlItemSet.clear();
        this.pnlItemName.clear();
        this.pnlArmorClasses.clear();
        this.pnlItemRarity.clear();
        this.pnlArtifactRarity.clear();
        this.pnlStats.clear();
    }

    public void addCriteria(SelectionCriteria criteria) {
        this.pnlItemTypes.addCriteria(criteria);
        this.pnlItemSet.addCriteria(criteria);
        this.pnlItemName.addCriteria(criteria);
        this.pnlArmorClasses.addCriteria(criteria);
        this.pnlItemRarity.addCriteria(criteria);
        this.pnlArtifactRarity.addCriteria(criteria);
        this.pnlStats.addCriteria(criteria);
        criteria.selMode = SelectionCriteria.SELECTION_MODE_ITEM;
    }
}

