/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.ui.select;

import java.awt.Font;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import org.gdstash.db.DBItemSet;
import org.gdstash.db.SelectionCriteria;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.ui.util.AdjustablePanel;
import org.gdstash.util.GDMsgFormatter;

public class ItemSetPane
extends AdjustablePanel {
    private static List<DBItemSet> sets = null;
    private static DBItemSet[] itemSets = null;
    private JComboBox<DBItemSet> cbSets;

    public static void loadSets() {
        if (GDStashFrame.dbConfig == null || !GDStashFrame.dbConfig.gddbInit) {
            itemSets = new DBItemSet[1];
            ItemSetPane.itemSets[0] = null;
            return;
        }
        sets = DBItemSet.getAll();
        if (sets == null) {
            itemSets = new DBItemSet[1];
            ItemSetPane.itemSets[0] = null;
        } else {
            Iterator<DBItemSet> iter = sets.iterator();
            itemSets = new DBItemSet[sets.size() + 1];
            ItemSetPane.itemSets[0] = null;
            int pos = 1;
            while (iter.hasNext()) {
                DBItemSet set;
                ItemSetPane.itemSets[pos] = set = iter.next();
                ++pos;
            }
        }
    }

    public ItemSetPane() {
        this.adjustUI();
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateGaps(false);
        layout.setAutoCreateContainerGaps(false);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(this.cbSets));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(this.cbSets));
        layout.setVerticalGroup(vGroup);
    }

    @Override
    public void adjustUI() {
        Font fntBorder;
        Font fntLabel = UIManager.getDefaults().getFont("Label.font");
        Font fntCombo = UIManager.getDefaults().getFont("ComboBox.font");
        if (fntCombo == null) {
            fntCombo = fntLabel;
        }
        if ((fntBorder = UIManager.getDefaults().getFont("TitledBorder.font")) == null) {
            fntBorder = fntLabel;
        }
        fntLabel = fntLabel.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntCombo = fntCombo.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntBorder = fntBorder.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        Border lowered = BorderFactory.createEtchedBorder(1);
        Border raised = BorderFactory.createEtchedBorder(0);
        CompoundBorder compound = BorderFactory.createCompoundBorder(raised, lowered);
        TitledBorder text = BorderFactory.createTitledBorder(compound, GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_SETS"));
        text.setTitleFont(fntBorder);
        this.setBorder(text);
        if (this.cbSets == null) {
            this.cbSets = new JComboBox<DBItemSet>(itemSets);
        }
        this.cbSets.setFont(fntCombo);
    }

    public void updateItemSets() {
        DefaultComboBoxModel<DBItemSet> model = new DefaultComboBoxModel<DBItemSet>(itemSets);
        this.cbSets.setModel(model);
    }

    public void clear() {
        this.cbSets.getModel().setSelectedItem(null);
    }

    public void addCriteria(SelectionCriteria criteria) {
        DBItemSet set = (DBItemSet)this.cbSets.getSelectedItem();
        criteria.itemIDs = set != null ? set.getItemIDList() : null;
    }

    static {
        ItemSetPane.loadSets();
    }
}

