/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.ui.select;

import java.awt.Dimension;
import java.awt.Font;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import org.gdstash.db.DBViewItemSkill;
import org.gdstash.db.SelectionCriteria;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.ui.util.AdjustablePanel;
import org.gdstash.util.GDMsgFormatter;

public class ItemSkillPane
extends AdjustablePanel {
    private static List<DBViewItemSkill> skills = null;
    private static DBViewItemSkill[] itemSkills = null;
    private JComboBox<DBViewItemSkill> cbSkills;

    public static void loadSkills() {
        if (GDStashFrame.dbConfig == null || !GDStashFrame.dbConfig.gddbInit) {
            itemSkills = new DBViewItemSkill[1];
            ItemSkillPane.itemSkills[0] = null;
            return;
        }
        skills = DBViewItemSkill.getItemSkills();
        if (skills == null) {
            itemSkills = new DBViewItemSkill[1];
            ItemSkillPane.itemSkills[0] = null;
        } else {
            Iterator<DBViewItemSkill> iter = skills.iterator();
            itemSkills = new DBViewItemSkill[skills.size() + 1];
            ItemSkillPane.itemSkills[0] = null;
            int pos = 1;
            while (iter.hasNext()) {
                DBViewItemSkill skill;
                ItemSkillPane.itemSkills[pos] = skill = iter.next();
                ++pos;
            }
        }
    }

    public ItemSkillPane() {
        this.adjustUI();
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateGaps(false);
        layout.setAutoCreateContainerGaps(false);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(this.cbSkills));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(this.cbSkills));
        layout.setVerticalGroup(vGroup);
    }

    @Override
    public void adjustUI() {
        Font fntBorder;
        int size = 12;
        if (GDStashFrame.iniConfig != null) {
            size = GDStashFrame.iniConfig.sectUI.fontSize;
        }
        Dimension dimMax = new Dimension(50 * size, 2 * size);
        Font fntLabel = UIManager.getDefaults().getFont("Label.font");
        Font fntCombo = UIManager.getDefaults().getFont("ComboBox.font");
        if (fntCombo == null) {
            fntCombo = fntLabel;
        }
        if ((fntBorder = UIManager.getDefaults().getFont("TitledBorder.font")) == null) {
            fntBorder = fntLabel;
        }
        fntLabel = fntLabel.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntCombo = fntCombo.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntBorder = fntBorder.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        Border lowered = BorderFactory.createEtchedBorder(1);
        Border raised = BorderFactory.createEtchedBorder(0);
        CompoundBorder compound = BorderFactory.createCompoundBorder(raised, lowered);
        TitledBorder text = BorderFactory.createTitledBorder(compound, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "TXT_ITEM_SKILL"));
        text.setTitleFont(fntBorder);
        this.setBorder(text);
        if (this.cbSkills == null) {
            this.cbSkills = new JComboBox<DBViewItemSkill>(itemSkills);
        }
        this.cbSkills.setFont(fntCombo);
        this.cbSkills.setPreferredSize(dimMax);
        this.cbSkills.setMaximumSize(dimMax);
    }

    public void updateItemSkills() {
        DefaultComboBoxModel<DBViewItemSkill> model = new DefaultComboBoxModel<DBViewItemSkill>(itemSkills);
        this.cbSkills.setModel(model);
    }

    public void clear() {
        this.cbSkills.getModel().setSelectedItem(null);
    }

    public void addCriteria(SelectionCriteria criteria) {
        int index = this.cbSkills.getSelectedIndex();
        criteria.itemSkill = null;
        DBViewItemSkill skill = (DBViewItemSkill)this.cbSkills.getSelectedItem();
        if (skill != null) {
            criteria.itemSkill = skill.getSkillID();
        }
    }

    static {
        ItemSkillPane.loadSkills();
    }
}

