/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.ui.select;

import java.awt.Dimension;
import java.awt.Font;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import org.gdstash.db.DBSkill;
import org.gdstash.db.SelectionCriteria;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.ui.util.AdjustablePanel;
import org.gdstash.util.GDMsgFormatter;

public class SkillBonusPane
extends AdjustablePanel {
    private static List<DBSkill> skills = null;
    private static DBSkill[] bonusSkills = null;
    private JComboBox<DBSkill> cbSkills;

    public static void loadSkills() {
        String s = GDMsgFormatter.getString(GDMsgFormatter.rbUI, "TXT_SKILL_ALL");
        if (GDStashFrame.dbConfig == null || !GDStashFrame.dbConfig.gddbInit) {
            DBSkill all;
            bonusSkills = new DBSkill[2];
            SkillBonusPane.bonusSkills[0] = null;
            SkillBonusPane.bonusSkills[1] = all = new DBSkill(s);
            return;
        }
        skills = DBSkill.getBonusSkills();
        if (skills == null) {
            DBSkill all;
            bonusSkills = new DBSkill[2];
            SkillBonusPane.bonusSkills[0] = null;
            SkillBonusPane.bonusSkills[1] = all = new DBSkill(s);
        } else {
            DBSkill all;
            bonusSkills = new DBSkill[skills.size() + 2];
            SkillBonusPane.bonusSkills[0] = null;
            SkillBonusPane.bonusSkills[1] = all = new DBSkill(s);
            int pos = 2;
            Iterator<DBSkill> iter = skills.iterator();
            while (iter.hasNext()) {
                DBSkill skill;
                SkillBonusPane.bonusSkills[pos] = skill = iter.next();
                ++pos;
            }
        }
    }

    public SkillBonusPane() {
        this.adjustUI();
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateGaps(false);
        layout.setAutoCreateContainerGaps(false);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(this.cbSkills));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(this.cbSkills));
        layout.setVerticalGroup(vGroup);
    }

    @Override
    public void adjustUI() {
        Font fntBorder;
        int size = 12;
        if (GDStashFrame.iniConfig != null) {
            size = GDStashFrame.iniConfig.sectUI.fontSize;
        }
        Dimension dimMax = new Dimension(50 * size, 2 * size);
        Font fntLabel = UIManager.getDefaults().getFont("Label.font");
        Font fntCombo = UIManager.getDefaults().getFont("ComboBox.font");
        if (fntCombo == null) {
            fntCombo = fntLabel;
        }
        if ((fntBorder = UIManager.getDefaults().getFont("TitledBorder.font")) == null) {
            fntBorder = fntLabel;
        }
        fntLabel = fntLabel.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntCombo = fntCombo.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntBorder = fntBorder.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        Border lowered = BorderFactory.createEtchedBorder(1);
        Border raised = BorderFactory.createEtchedBorder(0);
        CompoundBorder compound = BorderFactory.createCompoundBorder(raised, lowered);
        TitledBorder text = BorderFactory.createTitledBorder(compound, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "TXT_SKILL_BONUS"));
        text.setTitleFont(fntBorder);
        this.setBorder(text);
        if (this.cbSkills == null) {
            this.cbSkills = new JComboBox<DBSkill>(bonusSkills);
        }
        this.cbSkills.setFont(fntCombo);
        this.cbSkills.setPreferredSize(dimMax);
        this.cbSkills.setMaximumSize(dimMax);
    }

    public void updateBonusSkills() {
        DefaultComboBoxModel<DBSkill> model = new DefaultComboBoxModel<DBSkill>(bonusSkills);
        this.cbSkills.setModel(model);
    }

    public void clear() {
        this.cbSkills.getModel().setSelectedItem(null);
    }

    public void addCriteria(SelectionCriteria criteria) {
        int index = this.cbSkills.getSelectedIndex();
        criteria.bonusSkill = null;
        criteria.allSkills = false;
        if (index == 1) {
            criteria.allSkills = true;
        } else {
            DBSkill skill = (DBSkill)this.cbSkills.getSelectedItem();
            if (skill != null) {
                criteria.bonusSkill = skill.getSkillID();
            }
        }
    }

    static {
        SkillBonusPane.loadSkills();
    }
}

