/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.ui.select;

import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import org.gdstash.db.SelectionCriteria;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.ui.select.ArmorTypePane;
import org.gdstash.ui.select.WeaponTypePane;
import org.gdstash.ui.util.AdjustablePanel;
import org.gdstash.util.GDMsgFormatter;

public class SlotSelectionPane
extends AdjustablePanel {
    private WeaponTypePane pnlWeaponTypes;
    private ArmorTypePane pnlArmorTypes;

    public SlotSelectionPane() {
        this.adjustUI();
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateGaps(false);
        layout.setAutoCreateContainerGaps(false);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(this.pnlWeaponTypes).addComponent(this.pnlArmorTypes));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(this.pnlWeaponTypes)).addGroup(layout.createParallelGroup().addComponent(this.pnlArmorTypes));
        layout.setVerticalGroup(vGroup);
        layout.linkSize(0, this.pnlWeaponTypes, this.pnlArmorTypes);
    }

    @Override
    public void adjustUI() {
        Font fntLabel = UIManager.getDefaults().getFont("Label.font");
        Font fntBorder = UIManager.getDefaults().getFont("TitledBorder.font");
        if (fntBorder == null) {
            fntBorder = fntLabel;
        }
        fntLabel = fntLabel.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntBorder = fntBorder.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        Border lowered = BorderFactory.createEtchedBorder(1);
        Border raised = BorderFactory.createEtchedBorder(0);
        CompoundBorder compound = BorderFactory.createCompoundBorder(raised, lowered);
        TitledBorder text = BorderFactory.createTitledBorder(compound, GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_SLOT_INFO"));
        text.setTitleFont(fntBorder);
        this.setBorder(text);
        if (this.pnlWeaponTypes == null) {
            this.pnlWeaponTypes = new WeaponTypePane();
        } else {
            this.pnlWeaponTypes.adjustUI();
        }
        if (this.pnlArmorTypes == null) {
            this.pnlArmorTypes = new ArmorTypePane();
        } else {
            this.pnlArmorTypes.adjustUI();
        }
    }

    public void clear() {
        this.pnlWeaponTypes.clear();
        this.pnlArmorTypes.clear();
    }

    public void addCriteria(SelectionCriteria criteria) {
        criteria.selMode = SelectionCriteria.SELECTION_MODE_COMPONENT;
        this.pnlWeaponTypes.addComponentCriteria(criteria);
        this.pnlArmorTypes.addComponentCriteria(criteria);
    }
}

