/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.ui.select;

import java.awt.Font;
import javax.swing.UIManager;
import org.gdstash.db.SelectionCriteria;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.ui.select.DamageFullSelectionPane;
import org.gdstash.ui.select.FullSelectionPane;
import org.gdstash.ui.select.ItemFullSelectionPane;
import org.gdstash.ui.util.AdjustableTabbedPane;
import org.gdstash.util.GDMsgFormatter;

public class TabbedSelectionPane
extends AdjustableTabbedPane {
    private ItemFullSelectionPane pnlItem = new ItemFullSelectionPane();
    private FullSelectionPane pnlComponent = new FullSelectionPane();
    private DamageFullSelectionPane pnlDamage = new DamageFullSelectionPane();

    public TabbedSelectionPane() {
        this.add(this.pnlItem);
        this.add(this.pnlComponent);
        this.add(this.pnlDamage);
        this.adjustUI();
    }

    @Override
    public void adjustUI() {
        Font fntLabel = UIManager.getDefaults().getFont("Label.font");
        Font fntTabbed = UIManager.getDefaults().getFont("TabbedPane.font");
        fntTabbed = fntTabbed.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        this.setFont(fntTabbed);
        this.setTitleAt(0, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "HEADER_SEL_ITEM"));
        this.setTitleAt(1, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "HEADER_SEL_COMPONENT"));
        this.setTitleAt(2, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "HEADER_SEL_DAMAGE"));
        this.pnlItem.adjustUI();
        this.pnlComponent.adjustUI();
        this.pnlDamage.adjustUI();
    }

    public void clear() {
        int index = this.getSelectedIndex();
        if (index == 0) {
            this.pnlItem.clear();
        }
        if (index == 1) {
            this.pnlComponent.clear();
        }
        if (index == 2) {
            this.pnlDamage.clear();
        }
    }

    public void addCriteria(SelectionCriteria criteria) {
        int index = this.getSelectedIndex();
        if (index == 0) {
            this.pnlItem.addCriteria(criteria);
        }
        if (index == 1) {
            this.pnlComponent.addCriteria(criteria);
        }
        if (index == 2) {
            this.pnlDamage.addCriteria(criteria);
        }
    }
}

