/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.ui.stash;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.event.MouseInputAdapter;
import org.gdstash.file.DDSLoader;
import org.gdstash.item.GDItem;
import org.gdstash.item.GDItemContainer;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.ui.GDUITransfer;
import org.gdstash.ui.stash.GDContainerPane;
import org.gdstash.ui.stash.GDUIContainer;
import org.gdstash.ui.stash.GDUIInventory;
import org.gdstash.util.GDImagePool;

public class GDEquippedContainerPane
extends JLabel
implements GDUIContainer {
    private static Rectangle[] itemRectangles = new Rectangle[16];
    protected GDItemContainer container;
    protected int containerType;
    protected GDUIInventory uiInventory;
    protected GDUITransfer uiTransfer;
    protected Rectangle mouseRect;
    protected int xOffset;
    protected int yOffset;
    protected GDStashFrame frame;

    public GDEquippedContainerPane(int xOffset, int yOffset, GDStashFrame frame, GDUIInventory uiInventory, GDUITransfer uiTransfer) {
        this.frame = frame;
        this.containerType = 5;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.uiInventory = uiInventory;
        this.uiTransfer = uiTransfer;
        this.mouseRect = null;
        this.addMouseListener(new GDContainerPageMouseListener());
        this.addMouseMotionListener(new GDContainerPageMouseListener());
    }

    private int getItemPosition(GDItem item) {
        if (item == null) {
            return -1;
        }
        int pos = item.getY();
        if (item.getX() >= 1) {
            pos += 12;
        }
        if (item.getX() >= 2) {
            pos += 2;
        }
        return pos;
    }

    private int getPositionFromCoord(int x, int y) {
        for (int i = 0; i < itemRectangles.length; ++i) {
            if (!itemRectangles[i].contains(x, y)) continue;
            return i;
        }
        return -1;
    }

    private GDItem getItemFromCoord(int x, int y) {
        GDItem posItem = null;
        if (this.container != null) {
            for (int i = 0; i < itemRectangles.length; ++i) {
                if (!itemRectangles[i].contains(x, y)) continue;
                for (GDItem item : this.container.getItemList()) {
                    int pos;
                    if (item == null || (pos = this.getItemPosition(item)) != i) continue;
                    posItem = item;
                }
            }
        }
        return posItem;
    }

    @Override
    public void setContainer(GDItemContainer container) {
        if (container == null) {
            return;
        }
        if (container.getContainerType() != 5) {
            return;
        }
        this.container = container;
        this.containerType = container.getContainerType();
        this.layoutPage();
    }

    @Override
    public BufferedImage getBackgroundImage() {
        return GDImagePool.imgCharEquipped;
    }

    @Override
    public BufferedImage drawGraphics() {
        GDItem selItem = null;
        if (this.uiTransfer != null) {
            selItem = this.uiTransfer.getSelectedItem();
        }
        BufferedImage imgBG = this.getBackgroundImage();
        BufferedImage image = new BufferedImage(imgBG.getWidth(), imgBG.getHeight(), imgBG.getType());
        Graphics2D g = image.createGraphics();
        if (this.container == null) {
            g.setColor(GDContainerPane.COLOR_DARK_RED);
            g.setComposite(AlphaComposite.getInstance(10, 0.8f));
            g.fillRect(0, 0, imgBG.getWidth(), imgBG.getHeight());
        }
        g.drawImage((Image)imgBG, 0, 0, null);
        Rectangle rect = null;
        if (this.container != null) {
            for (GDItem item : this.container.getItemList()) {
                BufferedImage img = item.getFullImage();
                if (img == null) continue;
                int pos = this.getItemPosition(item);
                int x = GDEquippedContainerPane.itemRectangles[pos].x;
                int y = GDEquippedContainerPane.itemRectangles[pos].y;
                int w = GDEquippedContainerPane.itemRectangles[pos].width;
                int h = GDEquippedContainerPane.itemRectangles[pos].height;
                int xpos = x + (GDEquippedContainerPane.itemRectangles[pos].width - img.getWidth()) / 2;
                int ypos = y + (GDEquippedContainerPane.itemRectangles[pos].height - img.getHeight()) / 2;
                if (img != null) {
                    Color color = item.getBackgroundColor();
                    if (color != null) {
                        g.setColor(color);
                        g.setComposite(AlphaComposite.getInstance(10, 0.3f));
                        g.fillRect(x + 1, y + 1, w - 2, h - 2);
                        g.setComposite(AlphaComposite.getInstance(10, 1.0f));
                        g.drawRect(x + 1, y + 1, w - 2, h - 2);
                    }
                    g.drawImage((Image)img, xpos, ypos, null);
                }
                if (item != selItem) continue;
                rect = itemRectangles[pos];
            }
        }
        if (rect != null) {
            g.setColor(GDContainerPane.COLOR_GREEN);
            g.drawRect((int)rect.getX(), (int)rect.getY(), (int)rect.getWidth(), (int)rect.getHeight());
            g.drawRect((int)rect.getX() + 1, (int)rect.getY() - 1, (int)rect.getWidth() - 2, (int)rect.getHeight() + 2);
        }
        if (this.mouseRect != null) {
            if (this.isBlocked()) {
                g.setColor(GDContainerPane.COLOR_RED);
            } else {
                g.setColor(GDContainerPane.COLOR_WHITE);
            }
            g.drawRect((int)this.mouseRect.getX(), (int)this.mouseRect.getY(), (int)this.mouseRect.getWidth(), (int)this.mouseRect.getHeight());
            g.drawRect((int)this.mouseRect.getX() + 1, (int)this.mouseRect.getY() - 1, (int)this.mouseRect.getWidth() - 2, (int)this.mouseRect.getHeight() + 2);
        }
        return image;
    }

    @Override
    public int getXOffset() {
        return this.xOffset;
    }

    @Override
    public int getYOffset() {
        return this.yOffset;
    }

    @Override
    public int getHeight() {
        return this.getPreferredHeight();
    }

    @Override
    public int getWidth() {
        return this.getPreferredWidth();
    }

    @Override
    public boolean addItem(GDItem item, int action, int xCoord, int yCoord) {
        return false;
    }

    @Override
    public boolean deleteItem(GDItem item, int action, boolean update) {
        return false;
    }

    @Override
    public boolean hasChanged() {
        if (this.container == null) {
            return false;
        }
        return this.container.hasChanged();
    }

    @Override
    public List<GDItem> getItemList(int action) {
        LinkedList<GDItem> list = new LinkedList<GDItem>();
        if (this.container == null) {
            return list;
        }
        return this.container.getItemList();
    }

    @Override
    public void refresh() {
        if (this.container != null) {
            this.container.refresh();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        BufferedImage image = this.getBackgroundImage();
        int w = image.getWidth() * GDStashFrame.iniConfig.sectUI.graphicScale / 100;
        int h = image.getHeight() * GDStashFrame.iniConfig.sectUI.graphicScale / 100;
        return new Dimension(w, h);
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public int getPreferredWidth() {
        return (int)this.getPreferredSize().getWidth();
    }

    public int getPreferredHeight() {
        return (int)this.getPreferredSize().getHeight();
    }

    public void layoutPage() {
        if (this.uiTransfer == null) {
            this.mouseRect = null;
        } else if (this.uiTransfer.getSelectedItem() == null) {
            this.mouseRect = null;
        }
        BufferedImage image = this.drawGraphics();
        if (GDStashFrame.iniConfig.sectUI.graphicScale != 100) {
            int w = image.getWidth() * GDStashFrame.iniConfig.sectUI.graphicScale / 100;
            int h = image.getHeight() * GDStashFrame.iniConfig.sectUI.graphicScale / 100;
            image = DDSLoader.getScaledImage(image, w, h);
        }
        this.setIcon(new ImageIcon(image));
    }

    private boolean isBlocked() {
        return true;
    }

    static {
        GDEquippedContainerPane.itemRectangles[0] = new Rectangle(226, 3, 73, 72);
        GDEquippedContainerPane.itemRectangles[1] = new Rectangle(312, 3, 38, 37);
        GDEquippedContainerPane.itemRectangles[2] = new Rectangle(89, 151, 73, 104);
        GDEquippedContainerPane.itemRectangles[3] = new Rectangle(89, 281, 73, 104);
        GDEquippedContainerPane.itemRectangles[4] = new Rectangle(363, 313, 73, 72);
        GDEquippedContainerPane.itemRectangles[5] = new Rectangle(363, 232, 73, 72);
        GDEquippedContainerPane.itemRectangles[6] = new Rectangle(175, 54, 38, 37);
        GDEquippedContainerPane.itemRectangles[7] = new Rectangle(312, 54, 38, 37);
        GDEquippedContainerPane.itemRectangles[8] = new Rectangle(226, 375, 73, 40);
        GDEquippedContainerPane.itemRectangles[9] = new Rectangle(363, 151, 73, 72);
        GDEquippedContainerPane.itemRectangles[10] = new Rectangle(312, 375, 41, 40);
        GDEquippedContainerPane.itemRectangles[11] = new Rectangle(172, 375, 41, 40);
        GDEquippedContainerPane.itemRectangles[12] = new Rectangle(3, 3, 73, 134);
        GDEquippedContainerPane.itemRectangles[13] = new Rectangle(363, 3, 73, 134);
        GDEquippedContainerPane.itemRectangles[14] = new Rectangle(89, 3, 73, 134);
        GDEquippedContainerPane.itemRectangles[15] = new Rectangle(449, 3, 73, 134);
    }

    private class GDContainerPageMouseListener
    extends MouseInputAdapter {
        private GDContainerPageMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.selectItem(e);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            GDItem item = null;
            if (GDEquippedContainerPane.this.uiTransfer != null) {
                item = GDEquippedContainerPane.this.uiTransfer.getSelectedItem();
            }
            if (item == null) {
                return;
            }
            BufferedImage img = item.getImage();
            if (img == null) {
                return;
            }
            int x = e.getX();
            int y = e.getY();
            int xOff = GDEquippedContainerPane.this.getXOffset();
            int yOff = GDEquippedContainerPane.this.getYOffset();
            int w = GDEquippedContainerPane.this.getWidth();
            int h = GDEquippedContainerPane.this.getHeight();
            if (GDStashFrame.iniConfig.sectUI.graphicScale != 100) {
                xOff = xOff * GDStashFrame.iniConfig.sectUI.graphicScale / 100;
                yOff = yOff * GDStashFrame.iniConfig.sectUI.graphicScale / 100;
            }
            if (x < xOff || x > xOff + w || y < yOff || y > yOff + h) {
                return;
            }
            x -= xOff;
            y -= yOff;
            if (GDStashFrame.iniConfig.sectUI.graphicScale != 100) {
                x = x * 100 / GDStashFrame.iniConfig.sectUI.graphicScale;
                y = y * 100 / GDStashFrame.iniConfig.sectUI.graphicScale;
                w = w * 100 / GDStashFrame.iniConfig.sectUI.graphicScale;
                h = h * 100 / GDStashFrame.iniConfig.sectUI.graphicScale;
            }
            for (int i = 0; i < itemRectangles.length; ++i) {
                if (!itemRectangles[i].contains(x, y)) continue;
                GDEquippedContainerPane.this.mouseRect = itemRectangles[i];
            }
            GDEquippedContainerPane.this.layoutPage();
        }

        private void selectItem(MouseEvent e) {
            GDItem item;
            if (GDEquippedContainerPane.this.container == null) {
                return;
            }
            int button = e.getButton();
            if (button == 3 && GDEquippedContainerPane.this.uiInventory != null) {
                GDEquippedContainerPane.this.uiInventory.setSelectedItem(null);
            }
            if (button != 1) {
                return;
            }
            int x = e.getX();
            int y = e.getY();
            int xOff = GDEquippedContainerPane.this.getXOffset();
            int yOff = GDEquippedContainerPane.this.getYOffset();
            int w = GDEquippedContainerPane.this.getWidth();
            int h = GDEquippedContainerPane.this.getHeight();
            if (GDStashFrame.iniConfig.sectUI.graphicScale != 100) {
                xOff = xOff * GDStashFrame.iniConfig.sectUI.graphicScale / 100;
                yOff = yOff * GDStashFrame.iniConfig.sectUI.graphicScale / 100;
            }
            if (x < xOff || x > xOff + w || y < yOff || y > yOff + h) {
                GDEquippedContainerPane.this.layoutPage();
                return;
            }
            x -= xOff;
            y -= yOff;
            if (GDStashFrame.iniConfig.sectUI.graphicScale != 100) {
                x = x * 100 / GDStashFrame.iniConfig.sectUI.graphicScale;
                y = y * 100 / GDStashFrame.iniConfig.sectUI.graphicScale;
            }
            GDItem selItem = null;
            if (GDEquippedContainerPane.this.uiTransfer != null) {
                selItem = GDEquippedContainerPane.this.uiTransfer.getSelectedItem();
            }
            if ((item = GDEquippedContainerPane.this.getItemFromCoord(x, y)) != null) {
                GDEquippedContainerPane.this.uiInventory.setSelectedItem(item);
            }
            item = null;
            if (GDEquippedContainerPane.this.uiTransfer != null) {
                item = GDEquippedContainerPane.this.uiTransfer.getSelectedItem();
            }
            if (item != null && !GDEquippedContainerPane.this.isBlocked()) {
                GDEquippedContainerPane.this.mouseRect = null;
                if (GDEquippedContainerPane.this.uiTransfer.getItemLocation() == 1) {
                    GDEquippedContainerPane.this.uiTransfer.transferSelectedItem(1, e.getX(), e.getY());
                }
                if (GDEquippedContainerPane.this.uiTransfer.getItemLocation() == 2) {
                    GDEquippedContainerPane.this.uiTransfer.transferSelectedItem(4, e.getX(), e.getY());
                }
            }
        }
    }
}

