/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.ui.stash;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import org.gdstash.item.GDItem;
import org.gdstash.item.GDStash;
import org.gdstash.item.GDStashPage;
import org.gdstash.ui.GDLogoDialog;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.ui.GDUITransfer;
import org.gdstash.ui.stash.GDContainerMapPane;
import org.gdstash.ui.stash.GDContainerPane;
import org.gdstash.ui.stash.GDUIInventory;
import org.gdstash.ui.util.AdjustablePanel;
import org.gdstash.ui.util.GDStashInfoList;
import org.gdstash.util.GDConstants;
import org.gdstash.util.GDImagePool;
import org.gdstash.util.GDLog;
import org.gdstash.util.GDMsgFormatter;

public class GDSharedStashPane
extends AdjustablePanel
implements GDUIInventory {
    private GDStashFrame frame;
    private JTabbedPane tabPages;
    private GDContainerMapPane[] pnlPages;
    private JComboBox<String> cbSelStash;
    private JLabel lblSelMod;
    private JComboBox<String> cbSelMod;
    private GDStashInfoList.GDStashFileInfo info;
    private GDItem selItem;
    private GDContainerMapPane selPage;
    private JPanel pnlMain;
    private GDUITransfer uiTransfer;
    private boolean blockEvents;

    public GDSharedStashPane(GDStashInfoList.GDStashFileInfo info, GDStashFrame frame, GDUITransfer uiTransfer) {
        this.info = info;
        this.frame = frame;
        this.uiTransfer = uiTransfer;
        this.pnlPages = new GDContainerMapPane[4];
        this.selItem = null;
        this.selPage = null;
        this.blockEvents = false;
        this.adjustUI();
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        this.pnlMain = this.buildMainPanel();
        layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(this.pnlMain));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(this.pnlMain));
        layout.setVerticalGroup(vGroup);
    }

    @Override
    public void adjustUI() {
        Font fntTabbed;
        Font fntLabel = UIManager.getDefaults().getFont("Label.font");
        Font fntCombo = UIManager.getDefaults().getFont("ComboBox.font");
        if (fntCombo == null) {
            fntCombo = fntLabel;
        }
        if ((fntTabbed = UIManager.getDefaults().getFont("TabbedPane.font")) == null) {
            fntTabbed = fntLabel;
        }
        fntCombo = fntCombo.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntTabbed = fntTabbed.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        if (this.pnlPages[0] == null) {
            this.pnlPages[0] = new GDContainerMapPane(this, this.uiTransfer, GDImagePool.getSharedStashGrid());
        }
        if (this.pnlPages[1] == null) {
            this.pnlPages[1] = new GDContainerMapPane(this, this.uiTransfer, GDImagePool.getSharedStashGrid());
        }
        if (this.pnlPages[2] == null) {
            this.pnlPages[2] = new GDContainerMapPane(this, this.uiTransfer, GDImagePool.getSharedStashGrid());
        }
        if (this.pnlPages[3] == null) {
            this.pnlPages[3] = new GDContainerMapPane(this, this.uiTransfer, GDImagePool.getSharedStashGrid());
        }
        if (this.tabPages == null) {
            this.tabPages = new JTabbedPane();
            this.tabPages.setTabPlacement(2);
            this.tabPages.add("I", this.pnlPages[0]);
            this.tabPages.add("II", this.pnlPages[1]);
            this.tabPages.add("III", this.pnlPages[2]);
            this.tabPages.add("IV", this.pnlPages[3]);
        }
        this.tabPages.setFont(fntTabbed);
        this.tabPages.setMaximumSize(new Dimension(this.pnlPages[0].getPreferredWidth() + 80, this.pnlPages[0].getPreferredHeight()));
        if (this.cbSelStash == null) {
            this.cbSelStash = new JComboBox();
            this.cbSelStash.addActionListener(new StashSelectActionListener());
        }
        if (this.lblSelMod == null) {
            this.lblSelMod = new JLabel();
        }
        this.lblSelMod.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "TXT_MOD"));
        this.lblSelMod.setFont(fntLabel);
        if (this.cbSelMod == null) {
            this.cbSelMod = new JComboBox();
            this.cbSelMod.addActionListener(new ModSelectActionListener());
        }
        this.refreshStashSelection();
        this.cbSelStash.setFont(fntCombo);
        this.cbSelStash.setPreferredSize(new Dimension(270, fntCombo.getSize() + 8));
        this.cbSelStash.setMaximumSize(new Dimension(270, fntCombo.getSize() + 8));
    }

    private JPanel buildMainPanel() {
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        JPanel panel = new JPanel();
        JPanel pnlMod = this.buildModPanel();
        this.layoutStash();
        layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(this.cbSelStash).addComponent(pnlMod).addComponent(this.tabPages));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(this.cbSelStash)).addGroup(layout.createParallelGroup().addComponent(pnlMod)).addGroup(layout.createParallelGroup().addComponent(this.tabPages));
        layout.setVerticalGroup(vGroup);
        layout.linkSize(1, this.cbSelStash, pnlMod);
        layout.linkSize(0, this.cbSelStash, pnlMod);
        layout.linkSize(0, this.cbSelStash, this.tabPages);
        return panel;
    }

    private JPanel buildModPanel() {
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        JPanel panel = new JPanel();
        this.layoutStash();
        layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(false);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(this.lblSelMod)).addGroup(layout.createParallelGroup().addComponent(this.cbSelMod));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(this.lblSelMod).addComponent(this.cbSelMod));
        layout.setVerticalGroup(vGroup);
        layout.linkSize(1, this.lblSelMod, this.cbSelMod);
        return panel;
    }

    public void refreshStashSelection() {
        this.blockEvents = true;
        int idx = -1;
        this.cbSelStash.removeAllItems();
        String[] entries = GDStashInfoList.getStashInfos();
        for (int i = 0; i < entries.length; ++i) {
            this.cbSelStash.addItem(entries[i]);
            if (this.info == null || !entries[i].equals(this.info.stashInfo)) continue;
            idx = i;
        }
        this.cbSelMod.removeAllItems();
        if (GDStashInfoList.modDirs != null) {
            for (String s : GDStashInfoList.modDirs) {
                this.cbSelMod.addItem(s);
            }
            if (GDStashInfoList.modDirs.isEmpty()) {
                this.cbSelMod.addItem("");
            }
        }
        this.blockEvents = false;
        if (idx == -1) {
            this.cbSelStash.setSelectedIndex(0);
        } else {
            this.cbSelStash.setSelectedIndex(idx);
        }
    }

    public void setStash(GDStashInfoList.GDStashFileInfo info) {
        this.info = info;
        this.uiTransfer.setStash(info);
        GDStash stash = null;
        if (info != null) {
            stash = info.gdStash;
        }
        if (stash == null) {
            this.cbSelMod.setSelectedItem("");
            GDImagePool.buildSharedStash(8, 16);
        } else {
            this.cbSelMod.setSelectedItem(stash.getModName());
            GDImagePool.buildSharedStash(stash.getWidth(), stash.getHeight());
        }
        for (int i = 0; i < this.pnlPages.length; ++i) {
            this.pnlPages[i].setBGImage(GDImagePool.getSharedStashGrid());
        }
        this.setSelectedItem(null);
        this.layoutStash();
    }

    public GDContainerMapPane getCurrentPage() {
        int index = this.tabPages.getSelectedIndex();
        return this.pnlPages[index];
    }

    public void layoutStash() {
        GDStash stash = null;
        if (this.info != null) {
            stash = this.info.gdStash;
        }
        int i = 0;
        if (stash != null) {
            for (GDStashPage page : stash.getPages()) {
                GDContainerPane container = new GDContainerPane(1, 0, 0, this.frame, this, this.uiTransfer);
                container.setContainer(page);
                this.pnlPages[i].clearContainers();
                this.pnlPages[i].addContainer(container);
                this.tabPages.setEnabledAt(i, true);
                ++i;
            }
        }
        while (i < 4) {
            GDContainerPane container = new GDContainerPane(1, 0, 0, this.frame, this, this.uiTransfer);
            this.pnlPages[i].clearContainers();
            this.pnlPages[i].addContainer(container);
            this.tabPages.setEnabledAt(i, false);
            ++i;
        }
    }

    public void updateModSelection() {
        if (this.info == null) {
            return;
        }
        if (this.info.gdStash == null) {
            return;
        }
        String s = this.info.gdStash.getModName();
        if (s == null) {
            s = "";
        }
        this.cbSelMod.setSelectedItem(s);
    }

    public void deleteSelectedItem(int action) {
        if (this.selItem == null) {
            return;
        }
        boolean success = this.selPage.deleteItem(this.selItem, action, true);
        if (success) {
            this.setSelectedItem(null);
        }
    }

    public void moveSelectedItem(int action, int x, int y) {
        GDItem clone;
        if (this.selItem == null) {
            return;
        }
        GDContainerMapPane page = this.getCurrentPage();
        boolean success = page.addItem(clone = this.selItem.clone(), action, x, y);
        if (success && (success = this.selPage.deleteItem(this.selItem, action, true))) {
            this.selItem = clone;
            this.selPage = page;
        }
    }

    private boolean isModStashConflict(String mod) {
        if (this.info == null) {
            return false;
        }
        if (this.info.gdStash == null) {
            return false;
        }
        if (GDStashFrame.iniConfig == null) {
            return false;
        }
        if (GDStashFrame.iniConfig.sectDir.savePath == null) {
            return false;
        }
        boolean conflict = false;
        try {
            String stashMod;
            String sMod = mod;
            if (sMod == null) {
                sMod = "";
            }
            if ((stashMod = this.info.gdStash.getModName()) == null) {
                stashMod = "";
            }
            if (sMod.equals(stashMod)) {
                return false;
            }
            String dir = this.info.gdStash.getFile().getParentFile().getCanonicalPath();
            dir = dir.length() > GDStashFrame.iniConfig.sectDir.savePath.length() ? dir.substring(GDStashFrame.iniConfig.sectDir.savePath.length() + 1) : "";
            if (mod.equals(dir)) {
                return false;
            }
            dir = GDStashFrame.iniConfig.sectDir.savePath;
            if (!dir.endsWith(GDConstants.FILE_SEPARATOR)) {
                dir = dir + GDConstants.FILE_SEPARATOR;
            }
            if (!sMod.equals("")) {
                dir = dir + sMod + GDConstants.FILE_SEPARATOR;
            }
            dir = this.info.gdStash.isHardcore() ? dir + "transfer.gsh" : dir + "transfer.gst";
            File file = new File(dir);
            conflict = file.exists();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return conflict;
    }

    @Override
    public GDItem getSelectedItem() {
        return this.selItem;
    }

    @Override
    public void setSelectedItem(GDItem item) {
        this.selItem = item;
        if (item == null) {
            this.selPage = null;
        } else {
            this.selPage = this.getCurrentPage();
            this.selPage.layoutContainers();
        }
        this.uiTransfer.setSelectedItem(item, 1);
    }

    @Override
    public void refresh() {
        if (this.pnlPages != null) {
            for (int i = 0; i < this.pnlPages.length; ++i) {
                this.pnlPages[i].refresh();
            }
        }
    }

    public boolean addItem(GDItem item, int action, int x, int y) {
        if (item == null) {
            return false;
        }
        GDContainerMapPane page = this.getCurrentPage();
        return page.addItem(item.clone(), action, x, y);
    }

    private class ModSelectActionListener
    implements ActionListener {
        private ModSelectActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            if (GDSharedStashPane.this.blockEvents) {
                return;
            }
            int idx = GDSharedStashPane.this.cbSelMod.getSelectedIndex();
            if (idx == -1) {
                return;
            }
            String mod = (String)GDSharedStashPane.this.cbSelMod.getSelectedItem();
            if (GDSharedStashPane.this.info != null) {
                if (GDSharedStashPane.this.isModStashConflict(mod)) {
                    GDLogoDialog dialog = new GDLogoDialog(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERR_STASH_EXISTS"), 4, GDSharedStashPane.this.uiTransfer.getFrame());
                    dialog.setVisible(true);
                    String s = ((GDSharedStashPane)GDSharedStashPane.this).info.gdStash.getModName();
                    if (s == null) {
                        s = "";
                    }
                    GDSharedStashPane.this.cbSelMod.setSelectedItem(s);
                    return;
                }
                if (((GDSharedStashPane)GDSharedStashPane.this).info.gdStash != null) {
                    ((GDSharedStashPane)GDSharedStashPane.this).info.gdStash.setModName(mod);
                }
                GDSharedStashPane.this.uiTransfer.checkSaveButton();
            }
        }
    }

    private class StashSelectActionListener
    implements ActionListener {
        private StashSelectActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            if (GDSharedStashPane.this.blockEvents) {
                return;
            }
            GDLog log = new GDLog();
            int idx = GDSharedStashPane.this.cbSelStash.getSelectedIndex();
            if (idx == -1) {
                return;
            }
            int i = 0;
            for (GDStashInfoList.GDStashFileInfo info : GDStashInfoList.gdStashFileInfos) {
                if (i == idx) {
                    if (info.gdStash == null) {
                        info.gdStash = new GDStash(info.stashFile, log);
                    }
                    if (info.gdStash.hasStashErrors()) {
                        info.gdStash = null;
                        GDStashFrame.iniConfig.sectHistory.lastStash = "";
                    } else {
                        GDStashFrame.iniConfig.sectHistory.lastStash = info.fileName;
                    }
                    GDSharedStashPane.this.setStash(info);
                    break;
                }
                ++i;
            }
            log.showLog(GDSharedStashPane.this, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERRORS"));
        }
    }
}

