/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.ui.table;

import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import org.gdstash.character.GDChar;
import org.gdstash.ui.table.GDDevotionRow;

public class GDDevotionTableModel
extends DefaultTableModel {
    private GDChar gdc;
    private GDDevotionRow[] rows;

    public GDDevotionTableModel(GDChar gdc) {
        this.gdc = gdc;
        this.adjustUI();
    }

    public void adjustUI() {
        GDDevotionRow.updateColumnNames();
        this.setColumnIdentifiers(GDDevotionRow.columnNames);
        this.setData(this.gdc);
    }

    public void setData(GDChar gdc) {
        this.gdc = gdc;
        this.rows = null;
        if (gdc == null) {
            return;
        }
        GDChar.SkillInfo[] devotions = gdc.getDevotionInfo();
        if (devotions == null) {
            return;
        }
        int size = devotions.length;
        this.rows = new GDDevotionRow[size];
        for (int i = 0; i < devotions.length; ++i) {
            this.rows[i] = new GDDevotionRow(devotions[i], gdc.getSkillMaxLevel(devotions[i].id));
        }
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        if (this.rows == null) {
            return 0;
        }
        return this.rows.length;
    }

    @Override
    public int getColumnCount() {
        return GDDevotionRow.columnNames.length;
    }

    @Override
    public String getColumnName(int column) {
        return GDDevotionRow.columnNames[column];
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (this.rows == null) {
            return null;
        }
        if (column == 0) {
            return this.rows[row].devotion.name;
        }
        if (column == 1) {
            return Integer.toString(this.rows[row].devotion.points);
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return column == 1;
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        if (!this.isCellEditable(row, column)) {
            return;
        }
        if (column == 0) {
            this.rows[row].devotion.name = (String)value;
        }
        if (column == 1) {
            this.rows[row].devotion.points = Integer.parseInt((String)value);
        }
    }

    public Class getColumnClass(int column) {
        return GDDevotionRow.COLUMN_CLASSES[column];
    }

    public GDChar.SkillInfo[] getDevotions() {
        GDChar.SkillInfo[] devotions = null;
        if (this.rows != null && this.rows.length > 0) {
            devotions = new GDChar.SkillInfo[this.rows.length];
            for (int i = 0; i < this.rows.length; ++i) {
                devotions[i] = this.rows[i].devotion;
            }
        }
        return devotions;
    }

    public TableCellEditor getLevelEditor(int row) {
        if (row > this.rows.length) {
            return null;
        }
        return this.rows[row].editor;
    }
}

