/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.ui.table;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.table.DefaultTableModel;
import org.gdstash.file.DDSLoader;
import org.gdstash.item.GDItem;
import org.gdstash.ui.GDCollectionPane;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.ui.table.GDItemCollectionRow;
import org.gdstash.util.GDImagePool;

public class GDItemCollectionTableModel
extends DefaultTableModel {
    public static final int FILTER_ALL = 1;
    public static final int FILTER_FOUND = 2;
    public static final int FILTER_MISSING = 3;
    public static final Color GREEN_BG = new Color(170, 255, 180);
    public static final Color RED_BG = new Color(255, 180, 170);
    private List<GDCollectionPane.GDItemInfo> data;
    private GDItemCollectionRow[] rowsAll;
    private GDItemCollectionRow[] rows;

    public GDItemCollectionTableModel(List<GDCollectionPane.GDItemInfo> data) {
        this.data = data;
        this.adjustUI();
    }

    public void adjustUI() {
        GDItemCollectionRow.updateColumnNames();
        this.setColumnIdentifiers(GDItemCollectionRow.columnNames);
        this.setData(this.data);
    }

    public void setData(List<GDCollectionPane.GDItemInfo> data) {
        this.data = data;
        this.rowsAll = null;
        this.rows = null;
        if (data == null) {
            return;
        }
        int size = data.size();
        this.rowsAll = new GDItemCollectionRow[size];
        this.rows = new GDItemCollectionRow[size];
        GDItem.LabelInfo liEmpty = new GDItem.LabelInfo();
        liEmpty.text = "";
        int i = 0;
        GDItem.LabelInfo li = null;
        Iterator<GDCollectionPane.GDItemInfo> iter = data.iterator();
        while (iter.hasNext()) {
            this.rowsAll[i] = new GDItemCollectionRow();
            this.rows[i] = this.rowsAll[i];
            GDCollectionPane.GDItemInfo item = iter.next();
            BufferedImage img = item.gdItem.getImage();
            this.rowsAll[i].item = item;
            if (img != null) {
                if (GDStashFrame.iniConfig.sectUI.graphicScale != 100) {
                    int w = img.getWidth() * GDStashFrame.iniConfig.sectUI.graphicScale / 100;
                    int h = img.getHeight() * GDStashFrame.iniConfig.sectUI.graphicScale / 100;
                    img = DDSLoader.getScaledImage(img, w, h);
                }
                this.rowsAll[i].icon = new ImageIcon(img);
            }
            if ((li = item.gdItem.getCompleteNameInfo(false)) == null) {
                li = liEmpty;
            }
            this.rowsAll[i].name = li;
            li = item.gdItem.getRequiredLevelInfo();
            if (li == null) {
                li = liEmpty;
            }
            this.rowsAll[i].level = li;
            this.rowsAll[i].softcore = item.scCount == 0 ? GDImagePool.iconBtnCancel24 : GDImagePool.iconBtnOk24;
            this.rowsAll[i].hardcore = item.hcCount == 0 ? GDImagePool.iconBtnCancel24 : GDImagePool.iconBtnOk24;
            ++i;
        }
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        if (this.rows == null) {
            return 0;
        }
        return this.rows.length;
    }

    @Override
    public int getColumnCount() {
        return GDItemCollectionRow.columnNames.length;
    }

    @Override
    public String getColumnName(int column) {
        return GDItemCollectionRow.columnNames[column];
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (this.rows == null) {
            return null;
        }
        if (column == 0) {
            return this.rows[row].icon;
        }
        if (column == 1) {
            return this.rows[row].name.text;
        }
        if (column == 2) {
            return this.rows[row].level.text;
        }
        if (column == 3) {
            return this.rows[row].softcore;
        }
        if (column == 4) {
            return this.rows[row].hardcore;
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        if (!this.isCellEditable(row, column)) {
            return;
        }
        if (column == 0) {
            this.rows[row].icon = (ImageIcon)value;
        }
        if (column == 1) {
            this.rows[row].name.text = (String)value;
        }
        if (column == 2) {
            this.rows[row].level.text = (String)value;
        }
        if (column == 3) {
            this.rows[row].softcore = (ImageIcon)value;
        }
        if (column == 4) {
            this.rows[row].hardcore = (ImageIcon)value;
        }
    }

    public Class getColumnClass(int column) {
        return GDItemCollectionRow.COLUMN_CLASSES[column];
    }

    public String getCellText(int row, int column) {
        if (column == 1) {
            return this.rows[row].name.text;
        }
        if (column == 2) {
            return this.rows[row].level.text;
        }
        return "";
    }

    public Color getCellTextColor(int row, int column) {
        if (column == 1) {
            return this.rows[row].name.foreground;
        }
        if (column == 2) {
            return this.rows[row].level.foreground;
        }
        return Color.BLACK;
    }

    public Color getCellBgColor(int row, int column) {
        if (column == 1 || column == 2) {
            if (this.rows[row].item.scCount > 0) {
                return GREEN_BG;
            }
            if (this.rows[row].item.hcCount > 0) {
                return GREEN_BG;
            }
            return RED_BG;
        }
        return Color.WHITE;
    }

    public GDCollectionPane.GDItemInfo getItem(int row) {
        if (row < 0) {
            return null;
        }
        if (row > this.rows.length) {
            return null;
        }
        return this.rows[row].item;
    }

    public void filter(int filter) {
        if (this.rowsAll == null) {
            return;
        }
        Object li = null;
        GDItem.LabelInfo liEmpty = new GDItem.LabelInfo();
        liEmpty.text = "";
        int size = 0;
        block10: for (int i = 0; i < this.rowsAll.length; ++i) {
            switch (filter) {
                case 1: {
                    ++size;
                    continue block10;
                }
                case 2: {
                    if (this.rowsAll[i].item.scCount <= 0 && this.rowsAll[i].item.hcCount <= 0) continue block10;
                    ++size;
                    continue block10;
                }
                case 3: {
                    if (this.rowsAll[i].item.scCount != 0 || this.rowsAll[i].item.hcCount != 0) continue block10;
                    ++size;
                }
            }
        }
        if (size == 0) {
            this.rows = null;
        } else {
            this.rows = new GDItemCollectionRow[size];
            int pos = 0;
            for (int i = 0; i < this.rowsAll.length; ++i) {
                boolean addItem = false;
                switch (filter) {
                    case 1: {
                        addItem = true;
                        break;
                    }
                    case 2: {
                        if (this.rowsAll[i].item.scCount <= 0 && this.rowsAll[i].item.hcCount <= 0) break;
                        addItem = true;
                        break;
                    }
                    case 3: {
                        if (this.rowsAll[i].item.scCount != 0 || this.rowsAll[i].item.hcCount != 0) break;
                        addItem = true;
                    }
                }
                if (!addItem) continue;
                this.rows[pos] = this.rowsAll[i];
                ++pos;
            }
        }
        this.fireTableDataChanged();
    }

    public void sort(Comparator<GDItemCollectionRow> comp) {
        if (comp == null) {
            return;
        }
        if (this.rows == null) {
            return;
        }
        Arrays.sort(this.rows, comp);
    }
}

