/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.ui.table;

import java.util.Comparator;
import javax.swing.table.TableRowSorter;
import org.gdstash.ui.table.GDItemNameRow;
import org.gdstash.ui.table.GDItemNameTableModel;

public class GDItemNameSorter
extends TableRowSorter<GDItemNameTableModel> {
    public static final int SORTORDER_DEFAULT = 0;
    public static final int SORTORDER_BASE = 1;
    public static final int SORTORDER_BASE_REV = 2;
    public static final int SORTORDER_NAME = 3;
    public static final int SORTORDER_NAME_REV = 4;
    public static final int SORTORDER_LEVEL = 5;
    public static final int SORTORDER_LEVEL_REV = 6;
    private static final Comparator<GDItemNameRow> COMP_BASE = new BaseComparator();
    private static final Comparator<GDItemNameRow> COMP_BASE_REV = new BaseReverseComparator();
    private static final Comparator<GDItemNameRow> COMP_NAME = new NameComparator();
    private static final Comparator<GDItemNameRow> COMP_NAME_REV = new NameReverseComparator();
    private static final Comparator<GDItemNameRow> COMP_LEVEL = new LevelComparator();
    private static final Comparator<GDItemNameRow> COMP_LEVEL_REV = new LevelReverseComparator();
    private int sortOrder;

    public GDItemNameSorter() {
        this(null);
    }

    public GDItemNameSorter(GDItemNameTableModel model) {
        this.setModel(model);
    }

    @Override
    public void setModel(GDItemNameTableModel m) {
        super.setModel(m);
        if (m != null) {
            this.setSortable(0, false);
            this.sortOrder = 0;
        }
    }

    @Override
    public void toggleSortOrder(int column) {
        if (column == 0) {
            this.sortOrder = this.sortOrder == 1 ? 2 : 1;
        }
        if (column == 1) {
            this.sortOrder = this.sortOrder == 3 ? 4 : 3;
        }
        if (column == 2) {
            this.sortOrder = this.sortOrder == 5 ? 6 : 5;
        }
    }

    @Override
    public void sort() {
        GDItemNameTableModel model = (GDItemNameTableModel)this.getModel();
        if (this.sortOrder == 1) {
            model.sort(COMP_BASE);
        }
        if (this.sortOrder == 2) {
            model.sort(COMP_BASE_REV);
        }
        if (this.sortOrder == 3) {
            model.sort(COMP_NAME);
        }
        if (this.sortOrder == 4) {
            model.sort(COMP_NAME_REV);
        }
        if (this.sortOrder == 5) {
            model.sort(COMP_LEVEL);
        }
        if (this.sortOrder == 6) {
            model.sort(COMP_LEVEL_REV);
        }
    }

    private static class LevelReverseComparator
    implements Comparator<GDItemNameRow> {
        private LevelReverseComparator() {
        }

        @Override
        public int compare(GDItemNameRow ir1, GDItemNameRow ir2) {
            int iLvl2;
            int iLvl1 = Integer.parseInt(ir1.level.text);
            int iLevel = iLvl1 - (iLvl2 = Integer.parseInt(ir2.level.text));
            if (iLevel != 0) {
                return -iLevel;
            }
            return ir1.name.text.compareTo(ir2.name.text);
        }
    }

    private static class LevelComparator
    implements Comparator<GDItemNameRow> {
        private LevelComparator() {
        }

        @Override
        public int compare(GDItemNameRow ir1, GDItemNameRow ir2) {
            int iLvl2;
            int iLvl1 = Integer.parseInt(ir1.level.text);
            int iLevel = iLvl1 - (iLvl2 = Integer.parseInt(ir2.level.text));
            if (iLevel != 0) {
                return iLevel;
            }
            return ir1.name.text.compareTo(ir2.name.text);
        }
    }

    private static class NameReverseComparator
    implements Comparator<GDItemNameRow> {
        private NameReverseComparator() {
        }

        @Override
        public int compare(GDItemNameRow ir1, GDItemNameRow ir2) {
            int iName = ir1.name.text.compareTo(ir2.name.text);
            if (iName != 0) {
                return -iName;
            }
            return ir1.level.text.compareTo(ir2.level.text);
        }
    }

    public static class NameComparator
    implements Comparator<GDItemNameRow> {
        @Override
        public int compare(GDItemNameRow ir1, GDItemNameRow ir2) {
            int iName = ir1.name.text.compareTo(ir2.name.text);
            if (iName != 0) {
                return iName;
            }
            return ir1.level.text.compareTo(ir2.level.text);
        }
    }

    private static class BaseReverseComparator
    implements Comparator<GDItemNameRow> {
        private BaseReverseComparator() {
        }

        @Override
        public int compare(GDItemNameRow ir1, GDItemNameRow ir2) {
            int iLvl2;
            int iBase = ir1.baseName.compareTo(ir2.baseName);
            if (iBase != 0) {
                return -iBase;
            }
            int iLvl1 = Integer.parseInt(ir1.level.text);
            int iLevel = iLvl1 - (iLvl2 = Integer.parseInt(ir2.level.text));
            if (iLevel != 0) {
                return iLevel;
            }
            return ir1.name.text.compareTo(ir2.name.text);
        }
    }

    public static class BaseComparator
    implements Comparator<GDItemNameRow> {
        @Override
        public int compare(GDItemNameRow ir1, GDItemNameRow ir2) {
            int iLvl2;
            int iBase = ir1.baseName.compareTo(ir2.baseName);
            if (iBase != 0) {
                return iBase;
            }
            int iLvl1 = Integer.parseInt(ir1.level.text);
            int iLevel = iLvl1 - (iLvl2 = Integer.parseInt(ir2.level.text));
            if (iLevel != 0) {
                return iLevel;
            }
            return ir1.name.text.compareTo(ir2.name.text);
        }
    }
}

