/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.ui.table;

import java.awt.Color;
import javax.swing.table.DefaultTableModel;
import org.gdstash.db.DBStashItem;
import org.gdstash.ui.table.GDItemSimilarRow;

public class GDItemSimilarTableModel
extends DefaultTableModel {
    private DBStashItem.DuplicateInfo data;
    private GDItemSimilarRow[] rows;

    public GDItemSimilarTableModel(DBStashItem.DuplicateInfo info) {
        this.data = info;
        this.adjustUI();
    }

    public void adjustUI() {
        GDItemSimilarRow.updateColumnNames();
        this.setColumnIdentifiers(GDItemSimilarRow.columnNames);
        this.setData(this.data);
    }

    public void setData(DBStashItem.DuplicateInfo info) {
        this.data = info;
        this.rows = new GDItemSimilarRow[1];
        this.rows[0] = new GDItemSimilarRow(info);
        this.fireTableDataChanged();
    }

    @Override
    public void removeRow(int row) {
    }

    @Override
    public int getRowCount() {
        if (this.rows == null) {
            return 0;
        }
        return this.rows.length;
    }

    @Override
    public int getColumnCount() {
        return GDItemSimilarRow.columnNames.length;
    }

    @Override
    public String getColumnName(int column) {
        return GDItemSimilarRow.columnNames[column];
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (this.rows == null) {
            return null;
        }
        if (column == 0) {
            return this.rows[row].itemCombo.text;
        }
        if (column == 1) {
            return this.rows[row].classCombo.text;
        }
        if (column == 2) {
            return this.rows[row].itemPrefix.text;
        }
        if (column == 3) {
            return this.rows[row].levelPrefix.text;
        }
        if (column == 4) {
            return this.rows[row].itemSuffix.text;
        }
        if (column == 5) {
            return this.rows[row].levelSuffix.text;
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        if (!this.isCellEditable(row, column)) {
            return;
        }
        if (column == 0) {
            this.rows[row].itemCombo.text = (String)value;
        }
        if (column == 1) {
            this.rows[row].classCombo.text = (String)value;
        }
        if (column == 2) {
            this.rows[row].itemPrefix.text = (String)value;
        }
        if (column == 3) {
            this.rows[row].levelPrefix.text = (String)value;
        }
        if (column == 4) {
            this.rows[row].itemSuffix.text = (String)value;
        }
        if (column == 5) {
            this.rows[row].levelSuffix.text = (String)value;
        }
    }

    public Class getColumnClass(int column) {
        return GDItemSimilarRow.COLUMN_CLASSES[column];
    }

    public String getCellText(int row, int column) {
        if (column == 0) {
            return this.rows[row].itemCombo.text;
        }
        if (column == 1) {
            return this.rows[row].classCombo.text;
        }
        if (column == 2) {
            return this.rows[row].itemPrefix.text;
        }
        if (column == 3) {
            return this.rows[row].levelPrefix.text;
        }
        if (column == 4) {
            return this.rows[row].itemSuffix.text;
        }
        if (column == 5) {
            return this.rows[row].levelSuffix.text;
        }
        return "";
    }

    public Color getCellTextColor(int row, int column) {
        if (column == 0) {
            return this.rows[row].itemCombo.foreground;
        }
        if (column == 1) {
            return this.rows[row].classCombo.foreground;
        }
        if (column == 2) {
            return this.rows[row].itemPrefix.foreground;
        }
        if (column == 3) {
            return this.rows[row].levelPrefix.foreground;
        }
        if (column == 4) {
            return this.rows[row].itemSuffix.foreground;
        }
        if (column == 5) {
            return this.rows[row].levelSuffix.foreground;
        }
        return Color.BLACK;
    }

    public Color getCellBackgroundColor(int row, int column) {
        if (column == 0) {
            return this.rows[row].itemCombo.background;
        }
        if (column == 1) {
            return this.rows[row].classCombo.background;
        }
        if (column == 2) {
            return this.rows[row].itemPrefix.background;
        }
        if (column == 3) {
            return this.rows[row].levelPrefix.background;
        }
        if (column == 4) {
            return this.rows[row].itemSuffix.background;
        }
        if (column == 5) {
            return this.rows[row].levelSuffix.background;
        }
        return Color.WHITE;
    }
}

