/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.ui.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.ui.select.FullSelectionPane;
import org.gdstash.ui.util.AdjustablePanel;
import org.gdstash.ui.util.AdjustableTabbedPane;
import org.gdstash.ui.util.VerticalButtonUI;
import org.gdstash.util.GDImagePool;
import org.gdstash.util.GDMsgFormatter;

public class CollapsiblePanel
extends AdjustablePanel {
    private JButton btnCollapse;
    private boolean collapsed;
    private String tagTitle;
    private AdjustablePanel panel;
    private AdjustableTabbedPane tabbedPane;
    private int direction;

    public CollapsiblePanel(AdjustablePanel panel, String tagTitle) {
        this(panel, tagTitle, 0, false);
    }

    public CollapsiblePanel(AdjustablePanel panel, String tagTitle, int direction) {
        this(panel, tagTitle, direction, false);
    }

    public CollapsiblePanel(AdjustablePanel panel, String tagTitle, boolean collapsed) {
        this(panel, tagTitle, 0, collapsed);
    }

    public CollapsiblePanel(AdjustablePanel panel, String tagTitle, int direction, boolean collapsed) {
        this.panel = panel;
        this.tabbedPane = null;
        this.tagTitle = tagTitle;
        this.collapsed = collapsed;
        this.direction = direction;
        this.adjustUI();
        BorderLayout layout = new BorderLayout();
        this.setLayout(layout);
        if (direction == 0) {
            this.add((Component)this.btnCollapse, "North");
        } else {
            this.add((Component)this.btnCollapse, "West");
        }
        this.add((Component)panel, "Center");
        if (collapsed) {
            panel.setVisible(false);
        } else {
            panel.setVisible(true);
        }
        Border lowered = BorderFactory.createEtchedBorder(1);
        Border raised = BorderFactory.createEtchedBorder(0);
        CompoundBorder compound = BorderFactory.createCompoundBorder(raised, lowered);
        this.setBorder(compound);
    }

    public CollapsiblePanel(AdjustableTabbedPane tabbedPane, String tagTitle) {
        this(tabbedPane, tagTitle, 0, false);
    }

    public CollapsiblePanel(AdjustableTabbedPane tabbedPane, String tagTitle, int direction) {
        this(tabbedPane, tagTitle, direction, false);
    }

    public CollapsiblePanel(AdjustableTabbedPane tabbedPane, String tagTitle, boolean collapsed) {
        this(tabbedPane, tagTitle, 0, collapsed);
    }

    public CollapsiblePanel(AdjustableTabbedPane tabbedPane, String tagTitle, int direction, boolean collapsed) {
        this.panel = null;
        this.tabbedPane = tabbedPane;
        this.tagTitle = tagTitle;
        this.collapsed = collapsed;
        this.direction = direction;
        this.adjustUI();
        BorderLayout layout = new BorderLayout();
        this.setLayout(layout);
        if (direction == 0) {
            this.add((Component)this.btnCollapse, "North");
        } else {
            this.add((Component)this.btnCollapse, "West");
        }
        this.add((Component)tabbedPane, "Center");
        if (collapsed) {
            tabbedPane.setVisible(false);
        } else {
            tabbedPane.setVisible(true);
        }
        Border lowered = BorderFactory.createEtchedBorder(1);
        Border raised = BorderFactory.createEtchedBorder(0);
        CompoundBorder compound = BorderFactory.createCompoundBorder(raised, lowered);
        this.setBorder(compound);
    }

    @Override
    public void adjustUI() {
        Font fntLabel = UIManager.getDefaults().getFont("Label.font");
        Font fntButton = UIManager.getDefaults().getFont("Button.font");
        if (fntButton == null) {
            fntButton = fntLabel;
        }
        fntLabel = fntLabel.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        fntButton = fntButton.deriveFont((float)GDStashFrame.iniConfig.sectUI.fontSize);
        if (this.btnCollapse == null) {
            this.btnCollapse = new JButton();
            this.btnCollapse.addActionListener(new CollapsibleListener());
        }
        this.btnCollapse.setText(GDMsgFormatter.getString(GDMsgFormatter.rbUI, this.tagTitle));
        if (this.collapsed) {
            this.btnCollapse.setIcon(GDImagePool.iconWindowExpand24);
        } else {
            this.btnCollapse.setIcon(GDImagePool.iconWindowCollapse24);
        }
        this.btnCollapse.setFont(fntButton);
        if (this.direction == 1) {
            this.btnCollapse.setUI(new VerticalButtonUI(270));
        }
        if (this.panel != null) {
            this.panel.adjustUI();
        }
        if (this.tabbedPane != null) {
            this.tabbedPane.adjustUI();
        }
    }

    public static void test() {
        FullSelectionPane pnlSel1 = new FullSelectionPane();
        FullSelectionPane pnlSel2 = new FullSelectionPane();
        CollapsiblePanel pnl1 = new CollapsiblePanel((AdjustablePanel)pnlSel1, "TXT_LANG_COUNTRY", 0);
        CollapsiblePanel pnl2 = new CollapsiblePanel(pnlSel2, "TXT_LANG_COUNTRY", 0, true);
        JPanel panel = new JPanel();
        GroupLayout layout = null;
        GroupLayout.SequentialGroup hGroup = null;
        GroupLayout.SequentialGroup vGroup = null;
        layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(pnl1)).addGroup(layout.createParallelGroup().addComponent(pnl2));
        layout.setHorizontalGroup(hGroup);
        vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup().addComponent(pnl1).addComponent(pnl2));
        layout.setVerticalGroup(vGroup);
        JFrame frame = new JFrame();
        frame.add(panel);
        frame.setLocation(GDStashFrame.iniConfig.sectWindow.x, GDStashFrame.iniConfig.sectWindow.y);
        if (GDStashFrame.iniConfig.sectWindow.maximized) {
            frame.setExtendedState(frame.getExtendedState() | 6);
        } else {
            frame.setSize(GDStashFrame.iniConfig.sectWindow.w, GDStashFrame.iniConfig.sectWindow.h);
        }
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }

    private class CollapsibleListener
    implements ActionListener {
        private CollapsibleListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CollapsiblePanel.this.collapsed = !CollapsiblePanel.this.collapsed;
            if (CollapsiblePanel.this.collapsed) {
                if (CollapsiblePanel.this.panel != null) {
                    CollapsiblePanel.this.panel.setVisible(false);
                }
                if (CollapsiblePanel.this.tabbedPane != null) {
                    CollapsiblePanel.this.tabbedPane.setVisible(false);
                }
                CollapsiblePanel.this.btnCollapse.setIcon(GDImagePool.iconWindowExpand24);
            } else {
                if (CollapsiblePanel.this.panel != null) {
                    CollapsiblePanel.this.panel.setVisible(true);
                }
                if (CollapsiblePanel.this.tabbedPane != null) {
                    CollapsiblePanel.this.tabbedPane.setVisible(true);
                }
                CollapsiblePanel.this.btnCollapse.setIcon(GDImagePool.iconWindowCollapse24);
            }
            CollapsiblePanel.this.validate();
            CollapsiblePanel.this.repaint();
        }
    }
}

